/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import kala.Conditions;
import kala.collection.SeqView;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.immutable.primitive.ImmutableIntSeq;
import kala.collection.primitive.IntArraySeq;
import kala.collection.primitive.IntCollectionView;
import kala.collection.primitive.IntSeqLike;
import kala.collection.primitive.PrimitiveSeqView;
import kala.collection.primitive.internal.view.IntSeqViews;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface IntSeqView
extends IntSeqLike,
IntCollectionView,
PrimitiveSeqView<Integer> {
    @NotNull
    public static IntSeqView empty() {
        return IntSeqViews.EMPTY;
    }

    @Override
    @NotNull
    default public String className() {
        return "IntSeqView";
    }

    @Override
    @NotNull
    default public IntSeqView view() {
        return this;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public IntSeqView slice(int beginIndex, int endIndex) {
        int ks = this.knownSize();
        if (ks == 0) {
            if (beginIndex != 0) {
                throw new IndexOutOfBoundsException("beginIndex: " + beginIndex);
            }
            if (endIndex != 0) {
                throw new IndexOutOfBoundsException("endIndex: " + endIndex);
            }
            return IntSeqView.empty();
        }
        if (ks > 0) {
            Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)ks);
        } else {
            if (beginIndex < 0) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") < 0");
            }
            if (beginIndex > endIndex) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") > endIndex(" + endIndex + ")");
            }
        }
        return new IntSeqViews.Slice(this, beginIndex, endIndex);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public IntSeqView drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return IntSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return IntSeqView.empty();
        }
        return new IntSeqViews.Drop(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public IntSeqView dropLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return IntSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return IntSeqView.empty();
        }
        return new IntSeqViews.DropLast(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public IntSeqView dropWhile(@NotNull IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new IntSeqViews.DropWhile(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public IntSeqView take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return IntSeqView.empty();
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return IntSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return this;
        }
        return new IntSeqViews.Take(this, n);
    }

    @Override
    @NotNull
    default public IntSeqView takeLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return IntSeqView.empty();
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return IntSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return this;
        }
        return new IntSeqViews.TakeLast(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public IntSeqView takeWhile(@NotNull IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new IntSeqViews.TakeWhile(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public IntSeqView updated(int index, int newValue) {
        int ks = this.knownSize();
        if (ks < 0) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
        } else {
            Conditions.checkElementIndex((int)index, (int)ks);
        }
        return new IntSeqViews.Updated(this, index, newValue);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public IntSeqView concat(@NotNull IntSeqLike other) {
        Objects.requireNonNull(other);
        return new IntSeqViews.Concat(this, other.view());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public IntSeqView prepended(int value) {
        return new IntSeqViews.Prepended(this, value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public IntSeqView prependedAll(int @NotNull [] values) {
        Objects.requireNonNull(values);
        return new IntSeqViews.Concat(IntArraySeq.wrap(values), this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public IntSeqView prependedAll(@NotNull IntTraversable values) {
        Objects.requireNonNull(values);
        return new IntSeqViews.Concat(values instanceof IntSeqLike ? (IntSeqLike)values : ImmutableIntSeq.from(values), this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public IntSeqView appended(int value) {
        return new IntSeqViews.Appended(this, value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public IntSeqView appendedAll(int @NotNull [] values) {
        Objects.requireNonNull(values);
        return new IntSeqViews.Concat(this, IntArraySeq.wrap(values));
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public IntSeqView appendedAll(@NotNull IntTraversable values) {
        Objects.requireNonNull(values);
        return new IntSeqViews.Concat(this, values instanceof IntSeqLike ? (IntSeqLike)values : ImmutableIntSeq.from(values));
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public IntSeqView sorted() {
        return new IntSeqViews.Sorted(this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public IntSeqView reversed() {
        return new IntSeqViews.Reversed(this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public IntSeqView filter(@NotNull IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new IntSeqViews.Filter(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public IntSeqView filterNot(@NotNull IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new IntSeqViews.FilterNot(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public IntSeqView map(@NotNull IntUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return new IntSeqViews.Mapped(this, mapper);
    }

    @Contract(pure=true)
    @NotNull
    default public <U> SeqView<U> mapToObj(@NotNull IntFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return new IntSeqViews.MapToObj<U>(this, mapper);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public IntSeqView flatMap(@NotNull IntFunction<? extends IntTraversable> mapper) {
        Objects.requireNonNull(mapper);
        return new IntSeqViews.FlatMapped(this, mapper);
    }
}

