/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import kala.collection.base.primitive.AbstractByteIterator;
import kala.collection.mutable.primitive.MutableByteList;
import kala.collection.mutable.primitive.MutableByteListIterator;
import kala.collection.mutable.primitive.MutableByteSeq;
import kala.collection.mutable.primitive.MutableByteSeqIterator;
import kala.collection.primitive.AbstractByteSeqIterator;
import kala.collection.primitive.ByteSeqIterator;
import kala.collection.primitive.ByteSeqLike;
import org.jetbrains.annotations.NotNull;

public final class ByteSeqIterators {
    public static final ByteSeqIterator EMPTY = new EmptyByteSeqIterator();
    public static final MutableByteSeqIterator EMPTY_MUTABLE = new EmptyMutableByteSeqIterator();

    private ByteSeqIterators() {
    }

    private static class EmptyByteSeqIterator
    extends AbstractByteIterator
    implements ByteSeqIterator {
        private EmptyByteSeqIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public byte nextByte() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public byte previousByte() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }
    }

    private static class EmptyMutableByteSeqIterator
    extends EmptyByteSeqIterator
    implements MutableByteSeqIterator {
        private EmptyMutableByteSeqIterator() {
        }

        @Override
        public void set(byte e) {
            throw new IllegalStateException();
        }
    }

    public static final class FrozenByteSeqIterator
    implements ByteSeqIterator {
        @NotNull
        private final ByteSeqIterator source;

        public FrozenByteSeqIterator(@NotNull ByteSeqIterator source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public byte nextByte() {
            return this.source.nextByte();
        }

        @Override
        public boolean hasPrevious() {
            return this.source.hasPrevious();
        }

        @Override
        public byte previousByte() {
            return this.source.previousByte();
        }

        @Override
        public int nextIndex() {
            return this.source.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.source.previousIndex();
        }

        public String toString() {
            return "FrozenByteSeqIterator[" + this.source + ']';
        }
    }

    public static class DefaultMutableByteListIterator<S extends MutableByteList>
    extends DefaultMutableByteSeqIterator<S>
    implements MutableByteListIterator {
        public DefaultMutableByteListIterator(@NotNull S seq, int index) {
            super(seq, index);
        }

        @Override
        public void add(byte e) {
            try {
                int i = this.cursor;
                ((MutableByteList)this.seq).insert(i, e);
                this.lastRet = -1;
                this.cursor = i + 1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                ((MutableByteList)this.seq).removeAt(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public static class DefaultMutableByteSeqIterator<S extends MutableByteSeq>
    extends DefaultByteSeqIterator<S>
    implements MutableByteSeqIterator {
        public DefaultMutableByteSeqIterator(@NotNull S seq, int index) {
            super(seq, index);
        }

        @Override
        public void set(byte e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                ((MutableByteSeq)this.seq).set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public static class DefaultByteSeqIterator<S extends ByteSeqLike>
    extends AbstractByteSeqIterator {
        @NotNull
        protected final S seq;
        protected int lastRet = -1;

        public DefaultByteSeqIterator(@NotNull S seq, int index) {
            super(index);
            this.seq = seq;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.seq.size();
        }

        @Override
        public byte nextByte() {
            try {
                int i = this.cursor;
                byte next = this.seq.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public byte previousByte() {
            try {
                int i = this.cursor - 1;
                byte previous = this.seq.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }
    }
}

