/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal.view;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kala.Conditions;
import kala.collection.AbstractSeqView;
import kala.collection.SeqView;
import kala.collection.base.primitive.AbstractBooleanIterator;
import kala.collection.base.primitive.BooleanArrays;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.base.primitive.BooleanTraversable;
import kala.collection.mutable.primitive.MutableBooleanArrayList;
import kala.collection.primitive.AbstractBooleanSeqView;
import kala.collection.primitive.BooleanSeq;
import kala.collection.primitive.BooleanSeqLike;
import kala.collection.primitive.BooleanSeqView;
import kala.collection.primitive.IndexedBooleanSeqLike;
import kala.collection.primitive.internal.view.BooleanCollectionViews;
import kala.function.BooleanFunction;
import kala.function.BooleanPredicate;
import kala.function.BooleanUnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class BooleanSeqViews {
    public static final BooleanSeqView EMPTY = new Empty();

    public static class Empty
    extends BooleanCollectionViews.Empty
    implements BooleanSeqView {
        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public BooleanSeqView reversed() {
            return this;
        }

        @Override
        @NotNull
        public BooleanIterator reverseIterator() {
            return BooleanIterator.empty();
        }

        @Override
        public boolean get(int index) {
            throw new IndexOutOfBoundsException("index: " + index);
        }

        @Override
        @NotNull
        public BooleanSeqView concat(@NotNull BooleanSeqLike other) {
            return other.view();
        }

        @Override
        @NotNull
        public BooleanSeqView filter(@NotNull BooleanPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public BooleanSeqView filterNot(@NotNull BooleanPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public BooleanSeqView map(@NotNull BooleanUnaryOperator mapper) {
            return this;
        }

        @Override
        @NotNull
        public <U> SeqView<U> mapToObj(@NotNull BooleanFunction<? extends U> mapper) {
            return SeqView.empty();
        }

        @Override
        @NotNull
        public BooleanSeqView flatMap(@NotNull BooleanFunction<? extends BooleanTraversable> mapper) {
            return this;
        }

        @Override
        @NotNull
        public BooleanSeqView sorted() {
            return this;
        }
    }

    public static final class Sorted
    extends AbstractBooleanSeqView {
        private final BooleanSeqView source;
        private boolean[] sorted;

        public Sorted(@NotNull BooleanSeqView source) {
            this.source = source;
        }

        private void initSorted() {
            if (this.sorted == null) {
                boolean[] arr = this.source.toArray();
                BooleanArrays.sort((boolean[])arr);
                this.sorted = arr;
            }
        }

        @NotNull
        public final BooleanIterator iterator() {
            this.initSorted();
            return BooleanArrays.iterator((boolean[])this.sorted);
        }

        public final int size() {
            return this.sorted == null ? this.source.size() : this.sorted.length;
        }

        public final int knownSize() {
            return this.sorted == null ? this.source.knownSize() : this.sorted.length;
        }

        @Override
        public final boolean get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
            this.initSorted();
            try {
                return this.sorted[index];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException(e.getMessage());
            }
        }

        @Override
        @NotNull
        public final BooleanSeqView sorted() {
            return this;
        }
    }

    public static class MapToObj<E>
    extends AbstractSeqView<E> {
        @NotNull
        private final BooleanSeqView source;
        @NotNull
        private final BooleanFunction<? extends E> mapper;

        public MapToObj(@NotNull BooleanSeqView source, @NotNull BooleanFunction<? extends E> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return this.source.iterator().mapToObj(this.mapper);
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        public boolean isDefinedAt(int index) {
            return this.source.isDefinedAt(index);
        }

        public final E get(int index) {
            return (E)this.mapper.apply(this.source.get(index));
        }
    }

    public static class Mapped
    extends AbstractBooleanSeqView {
        @NotNull
        private final BooleanSeqView source;
        @NotNull
        private final BooleanUnaryOperator mapper;

        public Mapped(@NotNull BooleanSeqView source, @NotNull BooleanUnaryOperator mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final BooleanIterator iterator() {
            return this.source.iterator().map(this.mapper);
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public final boolean get(int index) {
            return this.mapper.applyAsBoolean(this.source.get(index));
        }
    }

    public static final class FlatMapped
    extends AbstractBooleanSeqView {
        @NotNull
        private final BooleanSeqLike source;
        @NotNull
        private final BooleanFunction<? extends BooleanTraversable> mapper;

        public FlatMapped(@NotNull BooleanSeqLike source, @NotNull BooleanFunction<? extends BooleanTraversable> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final BooleanIterator iterator() {
            return BooleanIterator.concat(this.source.mapToObj(it -> ((BooleanTraversable)this.mapper.apply(it)).iterator()));
        }
    }

    public static final class FilterNot
    extends AbstractBooleanSeqView {
        @NotNull
        private final BooleanSeqView source;
        @NotNull
        private final BooleanPredicate predicate;

        public FilterNot(@NotNull BooleanSeqView source, @NotNull BooleanPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final BooleanIterator iterator() {
            return this.source.iterator().filterNot(this.predicate);
        }
    }

    public static final class Filter
    extends AbstractBooleanSeqView {
        @NotNull
        private final BooleanSeqView source;
        @NotNull
        private final BooleanPredicate predicate;

        public Filter(@NotNull BooleanSeqView source, @NotNull BooleanPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public BooleanIterator iterator() {
            return this.source.iterator().filter(this.predicate);
        }
    }

    public static class Reversed
    extends AbstractBooleanSeqView {
        @NotNull
        protected final BooleanSeqView source;

        public Reversed(@NotNull BooleanSeqView source) {
            this.source = source;
        }

        @NotNull
        public final BooleanIterator iterator() {
            return this.source.reverseIterator();
        }

        public final boolean isEmpty() {
            return this.source.isEmpty();
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public final boolean get(int index) {
            return this.source.get(this.size() - 1 - index);
        }

        @Override
        @NotNull
        public final BooleanSeqView reversed() {
            return this.source;
        }

        @Override
        @NotNull
        public final BooleanIterator reverseIterator() {
            return this.source.iterator();
        }
    }

    public static class Appended
    extends AbstractBooleanSeqView {
        @NotNull
        protected final BooleanSeqView source;
        protected final boolean value;

        public Appended(@NotNull BooleanSeqView source, boolean value) {
            this.source = source;
            this.value = value;
        }

        public final int size() {
            return this.source.size() + 1;
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return sks + 1;
        }

        @NotNull
        public final BooleanIterator iterator() {
            return this.source.iterator().appended(this.value);
        }
    }

    public static class Prepended
    extends AbstractBooleanSeqView {
        @NotNull
        private final BooleanSeqView source;
        private final boolean value;

        public Prepended(@NotNull BooleanSeqView source, boolean value) {
            this.source = source;
            this.value = value;
        }

        @NotNull
        public final BooleanIterator iterator() {
            return this.source.iterator().prepended(this.value);
        }

        @Override
        public final boolean get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
            return index == 0 ? this.value : this.source.get(index - 1);
        }

        public final int size() {
            return this.source.size() + 1;
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return sks + 1;
        }
    }

    public static class Concat
    extends AbstractBooleanSeqView {
        @NotNull
        protected final BooleanSeqLike seq1;
        @NotNull
        protected final BooleanSeqLike seq2;

        public Concat(@NotNull BooleanSeqLike seq1, @NotNull BooleanSeqLike seq2) {
            this.seq1 = seq1;
            this.seq2 = seq2;
        }

        @NotNull
        public final BooleanIterator iterator() {
            return BooleanIterator.concat((BooleanIterator)this.seq1.iterator(), (BooleanIterator)this.seq2.iterator());
        }

        public final int size() {
            return this.seq1.size() + this.seq2.size();
        }

        public int knownSize() {
            int ks1 = this.seq1.knownSize();
            if (ks1 < 0) {
                return -1;
            }
            int ks2 = this.seq2.knownSize();
            if (ks2 < 0) {
                return -1;
            }
            return ks1 + ks2;
        }
    }

    public static class TakeWhile
    extends AbstractBooleanSeqView {
        @NotNull
        private final BooleanSeqView source;
        @NotNull
        private final BooleanPredicate predicate;

        public TakeWhile(@NotNull BooleanSeqView source, @NotNull BooleanPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final BooleanIterator iterator() {
            return this.source.iterator().takeWhile(this.predicate);
        }
    }

    public static class TakeLast
    extends AbstractBooleanSeqView {
        @NotNull
        protected final BooleanSeqView source;
        private final int n;
        private final int delta;

        public TakeLast(@NotNull BooleanSeqView source, int n) {
            this.source = source;
            this.n = Integer.max(n, 0);
            this.delta = Integer.max(0, source.size() - Integer.max(0, n));
        }

        @Override
        public final boolean get(int index) {
            return this.source.get(index + this.delta);
        }

        public final int size() {
            return this.source.size() - this.delta;
        }

        public final int knownSize() {
            int kn = this.source.knownSize();
            return kn >= 0 ? Integer.min(kn, this.n) : -1;
        }

        @NotNull
        public final BooleanIterator iterator() {
            int k = this.source.knownSize();
            if (k == 0 || this.n <= 0) {
                return BooleanIterator.empty();
            }
            if (this.n == Integer.MAX_VALUE) {
                return this.source.iterator();
            }
            if (k > 0) {
                return this.source.iterator().drop(Integer.max(k - this.n, 0));
            }
            return new AbstractBooleanIterator(){
                BooleanIterator it;
                int len;
                int pos;
                MutableBooleanArrayList buf;
                {
                    this.it = source.iterator();
                    this.len = -1;
                    this.pos = 0;
                    this.buf = null;
                }

                private void init() {
                    if (this.buf != null) {
                        return;
                    }
                    this.buf = new MutableBooleanArrayList();
                    this.len = 0;
                    while (this.it.hasNext()) {
                        boolean next = this.it.nextBoolean();
                        if (this.pos >= this.buf.size()) {
                            this.buf.append(next);
                        } else {
                            this.buf.set(this.pos, next);
                        }
                        if (++this.pos == n) {
                            this.pos = 0;
                        }
                        ++this.len;
                    }
                    this.it = null;
                    if (this.len > n) {
                        this.len = n;
                    }
                    this.pos -= this.len;
                    if (this.pos < 0) {
                        this.pos += n;
                    }
                }

                public final boolean hasNext() {
                    this.init();
                    return this.len > 0;
                }

                public final boolean nextBoolean() {
                    this.init();
                    if (this.len == 0) {
                        throw new NoSuchElementException();
                    }
                    boolean v = this.buf.get(this.pos);
                    ++this.pos;
                    if (this.pos == n) {
                        this.pos = 0;
                    }
                    --this.len;
                    return v;
                }
            };
        }
    }

    public static class Take
    extends AbstractBooleanSeqView {
        @NotNull
        protected final BooleanSeqView source;
        protected final @Range(from=1L, to=0x7FFFFFFFL) int n;

        public Take(@NotNull BooleanSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final BooleanIterator iterator() {
            return this.source.iterator().take(this.n);
        }

        public int size() {
            if (this.n <= 0) {
                return 0;
            }
            return Integer.min(this.n, this.source.size());
        }

        public int knownSize() {
            if (this.n <= 0) {
                return 0;
            }
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return Integer.min(sks, this.n);
        }

        @Override
        @NotNull
        public BooleanSeqView take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            if (this.n <= n) {
                return this;
            }
            return new Take(this.source, n);
        }
    }

    public static class DropWhile
    extends AbstractBooleanSeqView {
        @NotNull
        private final BooleanSeqView source;
        @NotNull
        private final BooleanPredicate predicate;

        public DropWhile(@NotNull BooleanSeqView source, @NotNull BooleanPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final BooleanIterator iterator() {
            return this.source.iterator().dropWhile(this.predicate);
        }
    }

    public static class DropLast
    extends AbstractBooleanSeqView {
        @NotNull
        protected final BooleanSeqView source;
        private final @Range(from=1L, to=0x7FFFFFFFL) int n;

        public DropLast(@NotNull BooleanSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final BooleanIterator iterator() {
            int ss = this.source.size();
            if (this.n >= ss) {
                return BooleanIterator.empty();
            }
            return this.source.iterator().take(ss - this.n);
        }

        @Override
        public final boolean get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index(" + index + ") < 0");
            }
            BooleanSeqView source = this.source;
            int n = this.n;
            if (n <= 0) {
                return this.source.get(index);
            }
            int size = Integer.max(source.size() - n, 0);
            Conditions.checkElementIndex((int)index, (int)size);
            return this.source.get(index);
        }

        public final int size() {
            return Integer.max(0, this.source.size() - this.n);
        }

        public final int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            if (this.n >= sks) {
                return 0;
            }
            return sks - this.n;
        }
    }

    public static class Drop
    extends AbstractBooleanSeqView {
        @NotNull
        protected final BooleanSeqView source;
        protected final int n;

        public Drop(@NotNull BooleanSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final BooleanIterator iterator() {
            return this.iterator().drop(this.n);
        }

        public final int size() {
            return Integer.max(0, this.source.size() - this.n);
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            return sks < 0 ? -1 : Integer.max(0, sks - this.n);
        }

        @Override
        @NotNull
        public BooleanSeqView drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            return this.source.drop(n + this.n);
        }
    }

    public static class Updated
    extends AbstractBooleanSeqView {
        @NotNull
        private final BooleanSeqView source;
        private final int index;
        private final boolean newValue;

        public Updated(@NotNull BooleanSeqView source, int index, boolean newValue) {
            this.source = source;
            this.index = index;
            this.newValue = newValue;
        }

        @NotNull
        public final BooleanIterator iterator() {
            return new AbstractBooleanIterator(){
                private final BooleanIterator it;
                private int i;
                {
                    this.it = source.iterator();
                    this.i = 0;
                }

                public final boolean hasNext() {
                    if (this.it.hasNext()) {
                        return true;
                    }
                    if (index >= this.i) {
                        throw new IndexOutOfBoundsException();
                    }
                    return false;
                }

                public final boolean nextBoolean() {
                    boolean value = this.it.next();
                    if (this.i++ == index) {
                        value = newValue;
                    }
                    return value;
                }
            };
        }

        public final int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public boolean isDefinedAt(int index) {
            return this.source.isDefinedAt(index);
        }

        @Override
        public final boolean get(int index) {
            if (index == this.index) {
                return this.newValue;
            }
            return this.source.get(index);
        }
    }

    public static class Slice
    extends AbstractBooleanSeqView {
        @NotNull
        protected final BooleanSeqView source;
        protected final int beginIndex;
        protected final int endIndex;

        public Slice(@NotNull BooleanSeqView source, int beginIndex, int endIndex) {
            this.source = source;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @NotNull
        public BooleanIterator iterator() {
            return new Itr();
        }

        public boolean isEmpty() {
            return this.beginIndex == this.endIndex;
        }

        public int size() {
            return this.endIndex - this.beginIndex;
        }

        public int knownSize() {
            return this.endIndex - this.beginIndex;
        }

        private final class Itr
        extends AbstractBooleanIterator {
            private int idx;
            private final BooleanIterator it;

            Itr() {
                BooleanIterator it = Slice.this.source.iterator();
                for (int i = Slice.this.beginIndex; i > 0; --i) {
                    try {
                        it.next();
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        throw new IndexOutOfBoundsException();
                    }
                }
                this.idx = Slice.this.beginIndex;
                this.it = it;
            }

            public final boolean hasNext() {
                return this.idx < Slice.this.endIndex;
            }

            public final boolean nextBoolean() {
                if (this.idx >= Slice.this.endIndex) {
                    throw new NoSuchElementException();
                }
                try {
                    boolean next = this.it.next();
                    ++this.idx;
                    return next;
                }
                catch (NoSuchElementException e) {
                    throw new IndexOutOfBoundsException();
                }
            }
        }
    }

    public static class WithCachedSize<C extends BooleanSeq>
    extends Of<C> {
        protected int cachedSize = -1;

        public WithCachedSize(@NotNull C source) {
            super(source);
        }

        public WithCachedSize(@NotNull C source, int size) {
            super(source);
            this.cachedSize = size;
        }

        @Override
        public boolean isEmpty() {
            int cachedSize = this.cachedSize;
            if (cachedSize == 0) {
                return true;
            }
            if (cachedSize > 0) {
                return false;
            }
            return ((BooleanSeq)this.source).isEmpty();
        }

        @Override
        public final int size() {
            int ss;
            if (this.cachedSize >= 0) {
                return this.cachedSize;
            }
            this.cachedSize = ss = ((BooleanSeq)this.source).size();
            return ss;
        }

        @Override
        public final int knownSize() {
            if (this.cachedSize >= 0) {
                return this.cachedSize;
            }
            int sks = ((BooleanSeq)this.source).knownSize();
            if (sks >= 0) {
                this.cachedSize = sks;
                return sks;
            }
            return -1;
        }
    }

    public static class OfArraySlice
    implements BooleanSeqView,
    IndexedBooleanSeqLike {
        protected final boolean[] array;
        protected final int beginIndex;
        protected final int endIndex;

        public OfArraySlice(boolean[] array, int beginIndex, int endIndex) {
            this.array = array;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public BooleanIterator iterator() {
            return BooleanArrays.iterator((boolean[])this.array, (int)this.beginIndex, (int)this.endIndex);
        }

        public final int size() {
            return this.endIndex - this.beginIndex;
        }

        public final int beginIndex() {
            return this.beginIndex;
        }

        public final int endIndex() {
            return this.endIndex;
        }

        @Override
        public final boolean get(int index) {
            Conditions.checkElementIndex((int)index, (int)this.size());
            return this.array[index + this.beginIndex];
        }

        @Override
        @NotNull
        public BooleanSeqView slice(int beginIndex, int endIndex) {
            Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size());
            int ns = endIndex - beginIndex;
            switch (ns) {
                case 0: {
                    return EMPTY;
                }
                case 1: {
                    return new Single(this.array[this.beginIndex + beginIndex]);
                }
            }
            return new OfArraySlice(this.array, this.beginIndex + beginIndex, this.beginIndex + endIndex);
        }

        @Override
        @NotNull
        public BooleanSeqView drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            int size = this.size();
            if (n >= size) {
                return EMPTY;
            }
            return new OfArraySlice(this.array, this.beginIndex + n, this.endIndex);
        }

        @Override
        @NotNull
        public BooleanSeqView dropLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            int size = this.size();
            if (n >= size) {
                return EMPTY;
            }
            return new OfArraySlice(this.array, this.beginIndex, this.endIndex - n);
        }

        @Override
        @NotNull
        public BooleanSeqView take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            int size = this.size();
            if (n >= size) {
                return this;
            }
            if (n == 1) {
                return new Single(this.array[this.beginIndex]);
            }
            return new OfArraySlice(this.array, this.beginIndex, this.beginIndex + n);
        }

        @Override
        @NotNull
        public BooleanSeqView takeLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            int size = this.size();
            if (n >= size) {
                return this;
            }
            if (n == 1) {
                return new Single(this.array[this.beginIndex]);
            }
            return new OfArraySlice(this.array, this.endIndex - n, this.endIndex);
        }
    }

    public static class Of<C extends BooleanSeqLike>
    extends BooleanCollectionViews.Of<C>
    implements BooleanSeqView {
        public Of(@NotNull C source) {
            super(source);
        }

        public boolean supportsFastRandomAccess() {
            return ((BooleanSeqLike)this.source).supportsFastRandomAccess();
        }

        @Override
        public boolean get(int index) {
            return ((BooleanSeqLike)this.source).get(index);
        }

        @Override
        public boolean isDefinedAt(int index) {
            return ((BooleanSeqLike)this.source).isDefinedAt(index);
        }

        @Override
        public int indexOf(boolean value) {
            return ((BooleanSeqLike)this.source).indexOf(value);
        }

        @Override
        public int indexOf(boolean value, int from) {
            return ((BooleanSeqLike)this.source).indexOf(value, from);
        }

        @Override
        public int indexWhere(@NotNull BooleanPredicate predicate) {
            return ((BooleanSeqLike)this.source).indexWhere(predicate);
        }

        @Override
        public int indexWhere(@NotNull BooleanPredicate predicate, int from) {
            return ((BooleanSeqLike)this.source).indexWhere(predicate, from);
        }

        @Override
        public int lastIndexOf(boolean value) {
            return ((BooleanSeqLike)this.source).lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(boolean value, int end) {
            return ((BooleanSeqLike)this.source).lastIndexOf(value, end);
        }

        @Override
        public int lastIndexWhere(@NotNull BooleanPredicate predicate) {
            return ((BooleanSeqLike)this.source).lastIndexWhere(predicate);
        }

        @Override
        public int lastIndexWhere(@NotNull BooleanPredicate predicate, int end) {
            return ((BooleanSeqLike)this.source).lastIndexWhere(predicate, end);
        }

        @Override
        @NotNull
        public BooleanIterator reverseIterator() {
            return ((BooleanSeqLike)this.source).reverseIterator();
        }
    }

    public static class Single
    extends BooleanCollectionViews.Single
    implements BooleanSeqView {
        public Single(boolean value) {
            super(value);
        }

        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public BooleanSeqView reversed() {
            return this;
        }

        @Override
        @NotNull
        public final BooleanIterator reverseIterator() {
            return BooleanIterator.of((boolean)this.value);
        }

        @Override
        public boolean get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this.value;
        }

        @Override
        @NotNull
        public BooleanSeqView updated(int index, boolean newValue) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return new Single(newValue);
        }
    }
}

