/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal.view;

import java.util.Iterator;
import kala.collection.AbstractCollectionView;
import kala.collection.CollectionView;
import kala.collection.base.primitive.ByteArrays;
import kala.collection.base.primitive.ByteIterator;
import kala.collection.base.primitive.ByteTraversable;
import kala.collection.primitive.AbstractByteCollectionView;
import kala.collection.primitive.ByteCollectionLike;
import kala.collection.primitive.ByteCollectionView;
import kala.control.primitive.ByteOption;
import kala.function.ByteConsumer;
import kala.function.ByteFunction;
import kala.function.BytePredicate;
import kala.function.ByteUnaryOperator;
import org.jetbrains.annotations.NotNull;

public final class ByteCollectionViews {
    public static final ByteCollectionView EMPTY = new Empty();

    private ByteCollectionViews() {
    }

    public static class Empty
    extends AbstractByteCollectionView {
        @NotNull
        public final ByteIterator iterator() {
            return ByteIterator.empty();
        }

        public final boolean isEmpty() {
            return true;
        }

        public final int size() {
            return 0;
        }

        public final int knownSize() {
            return 0;
        }

        @Override
        @NotNull
        public ByteCollectionView filter(@NotNull BytePredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public ByteCollectionView filterNot(@NotNull BytePredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public ByteCollectionView map(@NotNull ByteUnaryOperator mapper) {
            return this;
        }

        @Override
        @NotNull
        public <U> CollectionView<U> mapToObj(@NotNull ByteFunction<? extends U> mapper) {
            return CollectionView.empty();
        }

        @Override
        @NotNull
        public ByteCollectionView flatMap(@NotNull ByteFunction<? extends ByteTraversable> mapper) {
            return this;
        }

        public final byte @NotNull [] toArray() {
            return ByteArrays.EMPTY;
        }

        @Override
        public final String toString() {
            return this.className() + "[]";
        }
    }

    public static final class FlatMapped
    extends AbstractByteCollectionView {
        @NotNull
        private final ByteCollectionView source;
        @NotNull
        private final ByteFunction<? extends ByteTraversable> mapper;

        public FlatMapped(@NotNull ByteCollectionView source, @NotNull ByteFunction<? extends ByteTraversable> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public ByteIterator iterator() {
            return ByteIterator.concat(this.source.mapToObj(it -> ((ByteTraversable)this.mapper.apply(it)).iterator()));
        }
    }

    public static final class FilterNot
    extends AbstractByteCollectionView {
        @NotNull
        private final ByteCollectionView source;
        @NotNull
        private final BytePredicate predicate;

        public FilterNot(@NotNull ByteCollectionView source, @NotNull BytePredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public ByteIterator iterator() {
            return this.source.iterator().filterNot(this.predicate);
        }
    }

    public static final class Filter
    extends AbstractByteCollectionView {
        @NotNull
        private final ByteCollectionView source;
        @NotNull
        private final BytePredicate predicate;

        public Filter(@NotNull ByteCollectionView source, @NotNull BytePredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public ByteIterator iterator() {
            return this.source.iterator().filter(this.predicate);
        }
    }

    public static final class MapToObj<T>
    extends AbstractCollectionView<T> {
        @NotNull
        private final ByteCollectionView source;
        @NotNull
        private final ByteFunction<? extends T> mapper;

        public MapToObj(@NotNull ByteCollectionView source, @NotNull ByteFunction<? extends T> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public Iterator<T> iterator() {
            return this.source.iterator().mapToObj(this.mapper);
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }
    }

    public static final class Mapped
    extends AbstractByteCollectionView {
        @NotNull
        private final ByteCollectionView source;
        @NotNull
        private final ByteUnaryOperator mapper;

        public Mapped(@NotNull ByteCollectionView source, @NotNull ByteUnaryOperator mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public ByteIterator iterator() {
            return this.iterator().map(this.mapper);
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }
    }

    public static class Of<C extends ByteCollectionLike>
    extends AbstractByteCollectionView {
        @NotNull
        protected final C source;

        public Of(@NotNull C source) {
            this.source = source;
        }

        @NotNull
        public final ByteIterator iterator() {
            return this.source.iterator();
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }

        @NotNull
        public ByteOption find(@NotNull BytePredicate predicate) {
            return this.source.find(predicate);
        }

        public final boolean contains(byte value) {
            return this.source.contains(value);
        }

        public final boolean containsAll(byte @NotNull [] values) {
            return this.source.containsAll(values);
        }

        public final boolean containsAll(@NotNull ByteTraversable values) {
            return this.source.containsAll(values);
        }

        public final boolean sameElements(@NotNull Iterable<?> other) {
            return this.source.sameElements(other);
        }

        public final boolean anyMatch(@NotNull BytePredicate predicate) {
            return this.source.anyMatch(predicate);
        }

        public final boolean allMatch(@NotNull BytePredicate predicate) {
            return this.source.allMatch(predicate);
        }

        public final boolean noneMatch(@NotNull BytePredicate predicate) {
            return this.source.noneMatch(predicate);
        }

        public final int count(@NotNull BytePredicate predicate) {
            return this.source.count(predicate);
        }

        public final byte max() {
            return this.source.max();
        }

        public final byte min() {
            return this.source.min();
        }

        public final byte @NotNull [] toArray() {
            return this.source.toArray();
        }

        public final void forEach(@NotNull ByteConsumer action) {
            this.source.forEach(action);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer) {
            return (A)this.source.joinTo(buffer);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull CharSequence separator) {
            return (A)this.source.joinTo(buffer, separator);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix) {
            return (A)this.source.joinTo(buffer, separator, prefix, postfix);
        }

        @NotNull
        public final String joinToString() {
            return this.source.joinToString();
        }

        @NotNull
        public final String joinToString(@NotNull CharSequence separator) {
            return this.source.joinToString(separator);
        }

        @NotNull
        public final String joinToString(@NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix) {
            return this.source.joinToString(separator, prefix, postfix);
        }

        @Override
        public final String toString() {
            return this.joinToString(", ", this.className() + "[", "]");
        }
    }

    public static class Single
    extends AbstractByteCollectionView {
        protected final byte value;

        public Single(byte value) {
            this.value = value;
        }

        @NotNull
        public final ByteIterator iterator() {
            return ByteIterator.of((byte)this.value);
        }

        public final boolean isEmpty() {
            return false;
        }

        public final int size() {
            return 1;
        }

        public final int knownSize() {
            return 1;
        }

        public void forEach(@NotNull ByteConsumer action) {
            action.accept(this.value);
        }
    }
}

