/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal.view;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import kala.Conditions;
import kala.collection.AbstractSeqView;
import kala.collection.SeqView;
import kala.collection.base.primitive.AbstractIntIterator;
import kala.collection.base.primitive.IntArrays;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.mutable.primitive.MutableIntArrayList;
import kala.collection.primitive.AbstractIntSeqView;
import kala.collection.primitive.IndexedIntSeqLike;
import kala.collection.primitive.IntSeq;
import kala.collection.primitive.IntSeqLike;
import kala.collection.primitive.IntSeqView;
import kala.collection.primitive.internal.view.IntCollectionViews;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class IntSeqViews {
    public static final IntSeqView EMPTY = new Empty();

    public static class Empty
    extends IntCollectionViews.Empty
    implements IntSeqView {
        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public IntSeqView reversed() {
            return this;
        }

        @Override
        @NotNull
        public IntIterator reverseIterator() {
            return IntIterator.empty();
        }

        @Override
        public int get(int index) {
            throw new IndexOutOfBoundsException("index: " + index);
        }

        @Override
        @NotNull
        public IntSeqView concat(@NotNull IntSeqLike other) {
            return other.view();
        }

        @Override
        @NotNull
        public IntSeqView filter(@NotNull IntPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public IntSeqView filterNot(@NotNull IntPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public IntSeqView map(@NotNull IntUnaryOperator mapper) {
            return this;
        }

        @Override
        @NotNull
        public <U> SeqView<U> mapToObj(@NotNull IntFunction<? extends U> mapper) {
            return SeqView.empty();
        }

        @Override
        @NotNull
        public IntSeqView flatMap(@NotNull IntFunction<? extends IntTraversable> mapper) {
            return this;
        }

        @Override
        @NotNull
        public IntSeqView sorted() {
            return this;
        }
    }

    public static final class Sorted
    extends AbstractIntSeqView {
        private final IntSeqView source;
        private int[] sorted;

        public Sorted(@NotNull IntSeqView source) {
            this.source = source;
        }

        private void initSorted() {
            if (this.sorted == null) {
                int[] arr = this.source.toArray();
                IntArrays.sort((int[])arr);
                this.sorted = arr;
            }
        }

        @NotNull
        public final IntIterator iterator() {
            this.initSorted();
            return IntArrays.iterator((int[])this.sorted);
        }

        public final int size() {
            return this.sorted == null ? this.source.size() : this.sorted.length;
        }

        public final int knownSize() {
            return this.sorted == null ? this.source.knownSize() : this.sorted.length;
        }

        @Override
        public final int get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
            this.initSorted();
            try {
                return this.sorted[index];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException(e.getMessage());
            }
        }

        @Override
        @NotNull
        public final IntSeqView sorted() {
            return this;
        }
    }

    public static class MapToObj<E>
    extends AbstractSeqView<E> {
        @NotNull
        private final IntSeqView source;
        @NotNull
        private final IntFunction<? extends E> mapper;

        public MapToObj(@NotNull IntSeqView source, @NotNull IntFunction<? extends E> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return this.source.iterator().mapToObj(this.mapper);
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        public boolean isDefinedAt(int index) {
            return this.source.isDefinedAt(index);
        }

        public final E get(int index) {
            return this.mapper.apply(this.source.get(index));
        }
    }

    public static class Mapped
    extends AbstractIntSeqView {
        @NotNull
        private final IntSeqView source;
        @NotNull
        private final IntUnaryOperator mapper;

        public Mapped(@NotNull IntSeqView source, @NotNull IntUnaryOperator mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final IntIterator iterator() {
            return this.source.iterator().map(this.mapper);
        }

        @NotNull
        public final IntStream stream() {
            return this.source.stream().map(this.mapper);
        }

        @NotNull
        public final IntStream parallelStream() {
            return this.source.parallelStream().map(this.mapper);
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public final int get(int index) {
            return this.mapper.applyAsInt(this.source.get(index));
        }
    }

    public static final class FlatMapped
    extends AbstractIntSeqView {
        @NotNull
        private final IntSeqLike source;
        @NotNull
        private final IntFunction<? extends IntTraversable> mapper;

        public FlatMapped(@NotNull IntSeqLike source, @NotNull IntFunction<? extends IntTraversable> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final IntIterator iterator() {
            return IntIterator.concat(this.source.mapToObj((int it) -> this.mapper.apply(it).iterator()));
        }
    }

    public static final class FilterNot
    extends AbstractIntSeqView {
        @NotNull
        private final IntSeqView source;
        @NotNull
        private final IntPredicate predicate;

        public FilterNot(@NotNull IntSeqView source, @NotNull IntPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final IntIterator iterator() {
            return this.source.iterator().filterNot(this.predicate);
        }

        @NotNull
        public IntStream stream() {
            return this.source.stream().filter(this.predicate.negate());
        }

        @NotNull
        public IntStream parallelStream() {
            return this.source.parallelStream().filter(this.predicate.negate());
        }
    }

    public static final class Filter
    extends AbstractIntSeqView {
        @NotNull
        private final IntSeqView source;
        @NotNull
        private final IntPredicate predicate;

        public Filter(@NotNull IntSeqView source, @NotNull IntPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public IntIterator iterator() {
            return this.source.iterator().filter(this.predicate);
        }

        @NotNull
        public IntStream stream() {
            return this.source.stream().filter(this.predicate);
        }

        @NotNull
        public IntStream parallelStream() {
            return this.source.parallelStream().filter(this.predicate);
        }
    }

    public static class Reversed
    extends AbstractIntSeqView {
        @NotNull
        protected final IntSeqView source;

        public Reversed(@NotNull IntSeqView source) {
            this.source = source;
        }

        @NotNull
        public final IntIterator iterator() {
            return this.source.reverseIterator();
        }

        public final boolean isEmpty() {
            return this.source.isEmpty();
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public final int get(int index) {
            return this.source.get(this.size() - 1 - index);
        }

        @Override
        @NotNull
        public final IntSeqView reversed() {
            return this.source;
        }

        @Override
        @NotNull
        public final IntIterator reverseIterator() {
            return this.source.iterator();
        }
    }

    public static class Appended
    extends AbstractIntSeqView {
        @NotNull
        protected final IntSeqView source;
        protected final int value;

        public Appended(@NotNull IntSeqView source, int value) {
            this.source = source;
            this.value = value;
        }

        public final int size() {
            return this.source.size() + 1;
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return sks + 1;
        }

        @NotNull
        public final IntIterator iterator() {
            return this.source.iterator().appended(this.value);
        }
    }

    public static class Prepended
    extends AbstractIntSeqView {
        @NotNull
        private final IntSeqView source;
        private final int value;

        public Prepended(@NotNull IntSeqView source, int value) {
            this.source = source;
            this.value = value;
        }

        @NotNull
        public final IntIterator iterator() {
            return this.source.iterator().prepended(this.value);
        }

        @Override
        public final int get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
            return index == 0 ? this.value : this.source.get(index - 1);
        }

        public final int size() {
            return this.source.size() + 1;
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return sks + 1;
        }
    }

    public static class Concat
    extends AbstractIntSeqView {
        @NotNull
        protected final IntSeqLike seq1;
        @NotNull
        protected final IntSeqLike seq2;

        public Concat(@NotNull IntSeqLike seq1, @NotNull IntSeqLike seq2) {
            this.seq1 = seq1;
            this.seq2 = seq2;
        }

        @NotNull
        public final IntIterator iterator() {
            return IntIterator.concat((IntIterator)this.seq1.iterator(), (IntIterator)this.seq2.iterator());
        }

        public final int size() {
            return this.seq1.size() + this.seq2.size();
        }

        public int knownSize() {
            int ks1 = this.seq1.knownSize();
            if (ks1 < 0) {
                return -1;
            }
            int ks2 = this.seq2.knownSize();
            if (ks2 < 0) {
                return -1;
            }
            return ks1 + ks2;
        }
    }

    public static class TakeWhile
    extends AbstractIntSeqView {
        @NotNull
        private final IntSeqView source;
        @NotNull
        private final IntPredicate predicate;

        public TakeWhile(@NotNull IntSeqView source, @NotNull IntPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final IntIterator iterator() {
            return this.source.iterator().takeWhile(this.predicate);
        }
    }

    public static class TakeLast
    extends AbstractIntSeqView {
        @NotNull
        protected final IntSeqView source;
        private final int n;
        private final int delta;

        public TakeLast(@NotNull IntSeqView source, int n) {
            this.source = source;
            this.n = Integer.max(n, 0);
            this.delta = Integer.max(0, source.size() - Integer.max(0, n));
        }

        @Override
        public final int get(int index) {
            return this.source.get(index + this.delta);
        }

        public final int size() {
            return this.source.size() - this.delta;
        }

        public final int knownSize() {
            int kn = this.source.knownSize();
            return kn >= 0 ? Integer.min(kn, this.n) : -1;
        }

        @NotNull
        public final IntIterator iterator() {
            int k = this.source.knownSize();
            if (k == 0 || this.n <= 0) {
                return IntIterator.empty();
            }
            if (this.n == Integer.MAX_VALUE) {
                return this.source.iterator();
            }
            if (k > 0) {
                return this.source.iterator().drop(Integer.max(k - this.n, 0));
            }
            return new AbstractIntIterator(){
                IntIterator it;
                int len;
                int pos;
                MutableIntArrayList buf;
                {
                    this.it = source.iterator();
                    this.len = -1;
                    this.pos = 0;
                    this.buf = null;
                }

                private void init() {
                    if (this.buf != null) {
                        return;
                    }
                    this.buf = new MutableIntArrayList();
                    this.len = 0;
                    while (this.it.hasNext()) {
                        int next = this.it.nextInt();
                        if (this.pos >= this.buf.size()) {
                            this.buf.append(next);
                        } else {
                            this.buf.set(this.pos, next);
                        }
                        if (++this.pos == n) {
                            this.pos = 0;
                        }
                        ++this.len;
                    }
                    this.it = null;
                    if (this.len > n) {
                        this.len = n;
                    }
                    this.pos -= this.len;
                    if (this.pos < 0) {
                        this.pos += n;
                    }
                }

                public final boolean hasNext() {
                    this.init();
                    return this.len > 0;
                }

                public final int nextInt() {
                    this.init();
                    if (this.len == 0) {
                        throw new NoSuchElementException();
                    }
                    int v = this.buf.get(this.pos);
                    ++this.pos;
                    if (this.pos == n) {
                        this.pos = 0;
                    }
                    --this.len;
                    return v;
                }
            };
        }
    }

    public static class Take
    extends AbstractIntSeqView {
        @NotNull
        protected final IntSeqView source;
        protected final @Range(from=1L, to=0x7FFFFFFFL) int n;

        public Take(@NotNull IntSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final IntIterator iterator() {
            return this.source.iterator().take(this.n);
        }

        @NotNull
        public IntStream stream() {
            return this.source.stream().limit(this.n);
        }

        @NotNull
        public IntStream parallelStream() {
            return this.source.stream().limit(this.n).parallel();
        }

        public int size() {
            if (this.n <= 0) {
                return 0;
            }
            return Integer.min(this.n, this.source.size());
        }

        public int knownSize() {
            if (this.n <= 0) {
                return 0;
            }
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return Integer.min(sks, this.n);
        }

        @Override
        @NotNull
        public IntSeqView take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            if (this.n <= n) {
                return this;
            }
            return new Take(this.source, n);
        }
    }

    public static class DropWhile
    extends AbstractIntSeqView {
        @NotNull
        private final IntSeqView source;
        @NotNull
        private final IntPredicate predicate;

        public DropWhile(@NotNull IntSeqView source, @NotNull IntPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final IntIterator iterator() {
            return this.source.iterator().dropWhile(this.predicate);
        }
    }

    public static class DropLast
    extends AbstractIntSeqView {
        @NotNull
        protected final IntSeqView source;
        private final @Range(from=1L, to=0x7FFFFFFFL) int n;

        public DropLast(@NotNull IntSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final IntIterator iterator() {
            int ss = this.source.size();
            if (this.n >= ss) {
                return IntIterator.empty();
            }
            return this.source.iterator().take(ss - this.n);
        }

        @Override
        public final int get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index(" + index + ") < 0");
            }
            IntSeqView source = this.source;
            int n = this.n;
            if (n <= 0) {
                return this.source.get(index);
            }
            int size = Integer.max(source.size() - n, 0);
            Conditions.checkElementIndex((int)index, (int)size);
            return this.source.get(index);
        }

        public final int size() {
            return Integer.max(0, this.source.size() - this.n);
        }

        public final int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            if (this.n >= sks) {
                return 0;
            }
            return sks - this.n;
        }
    }

    public static class Drop
    extends AbstractIntSeqView {
        @NotNull
        protected final IntSeqView source;
        protected final int n;

        public Drop(@NotNull IntSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final IntIterator iterator() {
            return this.iterator().drop(this.n);
        }

        @NotNull
        public IntStream stream() {
            return this.source.stream().skip(this.n);
        }

        @NotNull
        public IntStream parallelStream() {
            return this.source.stream().skip(this.n).parallel();
        }

        public final int size() {
            return Integer.max(0, this.source.size() - this.n);
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            return sks < 0 ? -1 : Integer.max(0, sks - this.n);
        }

        @Override
        @NotNull
        public IntSeqView drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            return this.source.drop(n + this.n);
        }
    }

    public static class Updated
    extends AbstractIntSeqView {
        @NotNull
        private final IntSeqView source;
        private final int index;
        private final int newValue;

        public Updated(@NotNull IntSeqView source, int index, int newValue) {
            this.source = source;
            this.index = index;
            this.newValue = newValue;
        }

        @NotNull
        public final IntIterator iterator() {
            return new AbstractIntIterator(){
                private final IntIterator it;
                private int i;
                {
                    this.it = source.iterator();
                    this.i = 0;
                }

                public final boolean hasNext() {
                    if (this.it.hasNext()) {
                        return true;
                    }
                    if (index >= this.i) {
                        throw new IndexOutOfBoundsException();
                    }
                    return false;
                }

                public final int nextInt() {
                    int value = this.it.next();
                    if (this.i++ == index) {
                        value = newValue;
                    }
                    return value;
                }
            };
        }

        public final int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public boolean isDefinedAt(int index) {
            return this.source.isDefinedAt(index);
        }

        @Override
        public final int get(int index) {
            if (index == this.index) {
                return this.newValue;
            }
            return this.source.get(index);
        }
    }

    public static class Slice
    extends AbstractIntSeqView {
        @NotNull
        protected final IntSeqView source;
        protected final int beginIndex;
        protected final int endIndex;

        public Slice(@NotNull IntSeqView source, int beginIndex, int endIndex) {
            this.source = source;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @NotNull
        public IntIterator iterator() {
            return new Itr();
        }

        public boolean isEmpty() {
            return this.beginIndex == this.endIndex;
        }

        public int size() {
            return this.endIndex - this.beginIndex;
        }

        public int knownSize() {
            return this.endIndex - this.beginIndex;
        }

        private final class Itr
        extends AbstractIntIterator {
            private int idx;
            private final IntIterator it;

            Itr() {
                IntIterator it = Slice.this.source.iterator();
                for (int i = Slice.this.beginIndex; i > 0; --i) {
                    try {
                        it.next();
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        throw new IndexOutOfBoundsException();
                    }
                }
                this.idx = Slice.this.beginIndex;
                this.it = it;
            }

            public final boolean hasNext() {
                return this.idx < Slice.this.endIndex;
            }

            public final int nextInt() {
                if (this.idx >= Slice.this.endIndex) {
                    throw new NoSuchElementException();
                }
                try {
                    int next = this.it.next();
                    ++this.idx;
                    return next;
                }
                catch (NoSuchElementException e) {
                    throw new IndexOutOfBoundsException();
                }
            }
        }
    }

    public static class WithCachedSize<C extends IntSeq>
    extends Of<C> {
        protected int cachedSize = -1;

        public WithCachedSize(@NotNull C source) {
            super(source);
        }

        public WithCachedSize(@NotNull C source, int size) {
            super(source);
            this.cachedSize = size;
        }

        @Override
        public boolean isEmpty() {
            int cachedSize = this.cachedSize;
            if (cachedSize == 0) {
                return true;
            }
            if (cachedSize > 0) {
                return false;
            }
            return ((IntSeq)this.source).isEmpty();
        }

        @Override
        public final int size() {
            int ss;
            if (this.cachedSize >= 0) {
                return this.cachedSize;
            }
            this.cachedSize = ss = ((IntSeq)this.source).size();
            return ss;
        }

        @Override
        public final int knownSize() {
            if (this.cachedSize >= 0) {
                return this.cachedSize;
            }
            int sks = ((IntSeq)this.source).knownSize();
            if (sks >= 0) {
                this.cachedSize = sks;
                return sks;
            }
            return -1;
        }
    }

    public static class OfArraySlice
    implements IntSeqView,
    IndexedIntSeqLike {
        protected final int[] array;
        protected final int beginIndex;
        protected final int endIndex;

        public OfArraySlice(int[] array, int beginIndex, int endIndex) {
            this.array = array;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public IntIterator iterator() {
            return IntArrays.iterator((int[])this.array, (int)this.beginIndex, (int)this.endIndex);
        }

        public final int size() {
            return this.endIndex - this.beginIndex;
        }

        public final int beginIndex() {
            return this.beginIndex;
        }

        public final int endIndex() {
            return this.endIndex;
        }

        @Override
        public final int get(int index) {
            Conditions.checkElementIndex((int)index, (int)this.size());
            return this.array[index + this.beginIndex];
        }

        @Override
        @NotNull
        public IntSeqView slice(int beginIndex, int endIndex) {
            Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size());
            int ns = endIndex - beginIndex;
            switch (ns) {
                case 0: {
                    return EMPTY;
                }
                case 1: {
                    return new Single(this.array[this.beginIndex + beginIndex]);
                }
            }
            return new OfArraySlice(this.array, this.beginIndex + beginIndex, this.beginIndex + endIndex);
        }

        @Override
        @NotNull
        public IntSeqView drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            int size = this.size();
            if (n >= size) {
                return EMPTY;
            }
            return new OfArraySlice(this.array, this.beginIndex + n, this.endIndex);
        }

        @Override
        @NotNull
        public IntSeqView dropLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            int size = this.size();
            if (n >= size) {
                return EMPTY;
            }
            return new OfArraySlice(this.array, this.beginIndex, this.endIndex - n);
        }

        @Override
        @NotNull
        public IntSeqView take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            int size = this.size();
            if (n >= size) {
                return this;
            }
            if (n == 1) {
                return new Single(this.array[this.beginIndex]);
            }
            return new OfArraySlice(this.array, this.beginIndex, this.beginIndex + n);
        }

        @Override
        @NotNull
        public IntSeqView takeLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            int size = this.size();
            if (n >= size) {
                return this;
            }
            if (n == 1) {
                return new Single(this.array[this.beginIndex]);
            }
            return new OfArraySlice(this.array, this.endIndex - n, this.endIndex);
        }
    }

    public static class Of<C extends IntSeqLike>
    extends IntCollectionViews.Of<C>
    implements IntSeqView {
        public Of(@NotNull C source) {
            super(source);
        }

        public boolean supportsFastRandomAccess() {
            return ((IntSeqLike)this.source).supportsFastRandomAccess();
        }

        @Override
        public int get(int index) {
            return ((IntSeqLike)this.source).get(index);
        }

        @Override
        public boolean isDefinedAt(int index) {
            return ((IntSeqLike)this.source).isDefinedAt(index);
        }

        @Override
        public int indexOf(int value) {
            return ((IntSeqLike)this.source).indexOf(value);
        }

        @Override
        public int indexOf(int value, int from) {
            return ((IntSeqLike)this.source).indexOf(value, from);
        }

        @Override
        public int indexWhere(@NotNull IntPredicate predicate) {
            return ((IntSeqLike)this.source).indexWhere(predicate);
        }

        @Override
        public int indexWhere(@NotNull IntPredicate predicate, int from) {
            return ((IntSeqLike)this.source).indexWhere(predicate, from);
        }

        @Override
        public int lastIndexOf(int value) {
            return ((IntSeqLike)this.source).lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(int value, int end) {
            return ((IntSeqLike)this.source).lastIndexOf(value, end);
        }

        @Override
        public int lastIndexWhere(@NotNull IntPredicate predicate) {
            return ((IntSeqLike)this.source).lastIndexWhere(predicate);
        }

        @Override
        public int lastIndexWhere(@NotNull IntPredicate predicate, int end) {
            return ((IntSeqLike)this.source).lastIndexWhere(predicate, end);
        }

        @Override
        @NotNull
        public IntIterator reverseIterator() {
            return ((IntSeqLike)this.source).reverseIterator();
        }
    }

    public static class Single
    extends IntCollectionViews.Single
    implements IntSeqView {
        public Single(int value) {
            super(value);
        }

        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public IntSeqView reversed() {
            return this;
        }

        @Override
        @NotNull
        public final IntIterator reverseIterator() {
            return IntIterator.of((int)this.value);
        }

        @Override
        public int get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this.value;
        }

        @Override
        @NotNull
        public IntSeqView updated(int index, int newValue) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return new Single(newValue);
        }
    }
}

