/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal.view;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongUnaryOperator;
import java.util.stream.LongStream;
import kala.Conditions;
import kala.collection.AbstractSeqView;
import kala.collection.SeqView;
import kala.collection.base.primitive.AbstractLongIterator;
import kala.collection.base.primitive.LongArrays;
import kala.collection.base.primitive.LongIterator;
import kala.collection.base.primitive.LongTraversable;
import kala.collection.mutable.primitive.MutableLongArrayList;
import kala.collection.primitive.AbstractLongSeqView;
import kala.collection.primitive.IndexedLongSeqLike;
import kala.collection.primitive.LongSeq;
import kala.collection.primitive.LongSeqLike;
import kala.collection.primitive.LongSeqView;
import kala.collection.primitive.internal.view.LongCollectionViews;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class LongSeqViews {
    public static final LongSeqView EMPTY = new Empty();

    public static class Empty
    extends LongCollectionViews.Empty
    implements LongSeqView {
        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public LongSeqView reversed() {
            return this;
        }

        @Override
        @NotNull
        public LongIterator reverseIterator() {
            return LongIterator.empty();
        }

        @Override
        public long get(int index) {
            throw new IndexOutOfBoundsException("index: " + index);
        }

        @Override
        @NotNull
        public LongSeqView concat(@NotNull LongSeqLike other) {
            return other.view();
        }

        @Override
        @NotNull
        public LongSeqView filter(@NotNull LongPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public LongSeqView filterNot(@NotNull LongPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public LongSeqView map(@NotNull LongUnaryOperator mapper) {
            return this;
        }

        @Override
        @NotNull
        public <U> SeqView<U> mapToObj(@NotNull LongFunction<? extends U> mapper) {
            return SeqView.empty();
        }

        @Override
        @NotNull
        public LongSeqView flatMap(@NotNull LongFunction<? extends LongTraversable> mapper) {
            return this;
        }

        @Override
        @NotNull
        public LongSeqView sorted() {
            return this;
        }
    }

    public static final class Sorted
    extends AbstractLongSeqView {
        private final LongSeqView source;
        private long[] sorted;

        public Sorted(@NotNull LongSeqView source) {
            this.source = source;
        }

        private void initSorted() {
            if (this.sorted == null) {
                long[] arr = this.source.toArray();
                LongArrays.sort((long[])arr);
                this.sorted = arr;
            }
        }

        @NotNull
        public final LongIterator iterator() {
            this.initSorted();
            return LongArrays.iterator((long[])this.sorted);
        }

        public final int size() {
            return this.sorted == null ? this.source.size() : this.sorted.length;
        }

        public final int knownSize() {
            return this.sorted == null ? this.source.knownSize() : this.sorted.length;
        }

        @Override
        public final long get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
            this.initSorted();
            try {
                return this.sorted[index];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException(e.getMessage());
            }
        }

        @Override
        @NotNull
        public final LongSeqView sorted() {
            return this;
        }
    }

    public static class MapToObj<E>
    extends AbstractSeqView<E> {
        @NotNull
        private final LongSeqView source;
        @NotNull
        private final LongFunction<? extends E> mapper;

        public MapToObj(@NotNull LongSeqView source, @NotNull LongFunction<? extends E> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return this.source.iterator().mapToObj(this.mapper);
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        public boolean isDefinedAt(int index) {
            return this.source.isDefinedAt(index);
        }

        public final E get(int index) {
            return this.mapper.apply(this.source.get(index));
        }
    }

    public static class Mapped
    extends AbstractLongSeqView {
        @NotNull
        private final LongSeqView source;
        @NotNull
        private final LongUnaryOperator mapper;

        public Mapped(@NotNull LongSeqView source, @NotNull LongUnaryOperator mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final LongIterator iterator() {
            return this.source.iterator().map(this.mapper);
        }

        @NotNull
        public final LongStream stream() {
            return this.source.stream().map(this.mapper);
        }

        @NotNull
        public final LongStream parallelStream() {
            return this.source.parallelStream().map(this.mapper);
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public final long get(int index) {
            return this.mapper.applyAsLong(this.source.get(index));
        }
    }

    public static final class FlatMapped
    extends AbstractLongSeqView {
        @NotNull
        private final LongSeqLike source;
        @NotNull
        private final LongFunction<? extends LongTraversable> mapper;

        public FlatMapped(@NotNull LongSeqLike source, @NotNull LongFunction<? extends LongTraversable> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final LongIterator iterator() {
            return LongIterator.concat(this.source.mapToObj((long it) -> this.mapper.apply(it).iterator()));
        }
    }

    public static final class FilterNot
    extends AbstractLongSeqView {
        @NotNull
        private final LongSeqView source;
        @NotNull
        private final LongPredicate predicate;

        public FilterNot(@NotNull LongSeqView source, @NotNull LongPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final LongIterator iterator() {
            return this.source.iterator().filterNot(this.predicate);
        }

        @NotNull
        public LongStream stream() {
            return this.source.stream().filter(this.predicate.negate());
        }

        @NotNull
        public LongStream parallelStream() {
            return this.source.parallelStream().filter(this.predicate.negate());
        }
    }

    public static final class Filter
    extends AbstractLongSeqView {
        @NotNull
        private final LongSeqView source;
        @NotNull
        private final LongPredicate predicate;

        public Filter(@NotNull LongSeqView source, @NotNull LongPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public LongIterator iterator() {
            return this.source.iterator().filter(this.predicate);
        }

        @NotNull
        public LongStream stream() {
            return this.source.stream().filter(this.predicate);
        }

        @NotNull
        public LongStream parallelStream() {
            return this.source.parallelStream().filter(this.predicate);
        }
    }

    public static class Reversed
    extends AbstractLongSeqView {
        @NotNull
        protected final LongSeqView source;

        public Reversed(@NotNull LongSeqView source) {
            this.source = source;
        }

        @NotNull
        public final LongIterator iterator() {
            return this.source.reverseIterator();
        }

        public final boolean isEmpty() {
            return this.source.isEmpty();
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public final long get(int index) {
            return this.source.get(this.size() - 1 - index);
        }

        @Override
        @NotNull
        public final LongSeqView reversed() {
            return this.source;
        }

        @Override
        @NotNull
        public final LongIterator reverseIterator() {
            return this.source.iterator();
        }
    }

    public static class Appended
    extends AbstractLongSeqView {
        @NotNull
        protected final LongSeqView source;
        protected final long value;

        public Appended(@NotNull LongSeqView source, long value) {
            this.source = source;
            this.value = value;
        }

        public final int size() {
            return this.source.size() + 1;
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return sks + 1;
        }

        @NotNull
        public final LongIterator iterator() {
            return this.source.iterator().appended(this.value);
        }
    }

    public static class Prepended
    extends AbstractLongSeqView {
        @NotNull
        private final LongSeqView source;
        private final long value;

        public Prepended(@NotNull LongSeqView source, long value) {
            this.source = source;
            this.value = value;
        }

        @NotNull
        public final LongIterator iterator() {
            return this.source.iterator().prepended(this.value);
        }

        @Override
        public final long get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
            return index == 0 ? this.value : this.source.get(index - 1);
        }

        public final int size() {
            return this.source.size() + 1;
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return sks + 1;
        }
    }

    public static class Concat
    extends AbstractLongSeqView {
        @NotNull
        protected final LongSeqLike seq1;
        @NotNull
        protected final LongSeqLike seq2;

        public Concat(@NotNull LongSeqLike seq1, @NotNull LongSeqLike seq2) {
            this.seq1 = seq1;
            this.seq2 = seq2;
        }

        @NotNull
        public final LongIterator iterator() {
            return LongIterator.concat((LongIterator)this.seq1.iterator(), (LongIterator)this.seq2.iterator());
        }

        public final int size() {
            return this.seq1.size() + this.seq2.size();
        }

        public int knownSize() {
            int ks1 = this.seq1.knownSize();
            if (ks1 < 0) {
                return -1;
            }
            int ks2 = this.seq2.knownSize();
            if (ks2 < 0) {
                return -1;
            }
            return ks1 + ks2;
        }
    }

    public static class TakeWhile
    extends AbstractLongSeqView {
        @NotNull
        private final LongSeqView source;
        @NotNull
        private final LongPredicate predicate;

        public TakeWhile(@NotNull LongSeqView source, @NotNull LongPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final LongIterator iterator() {
            return this.source.iterator().takeWhile(this.predicate);
        }
    }

    public static class TakeLast
    extends AbstractLongSeqView {
        @NotNull
        protected final LongSeqView source;
        private final int n;
        private final int delta;

        public TakeLast(@NotNull LongSeqView source, int n) {
            this.source = source;
            this.n = Integer.max(n, 0);
            this.delta = Integer.max(0, source.size() - Integer.max(0, n));
        }

        @Override
        public final long get(int index) {
            return this.source.get(index + this.delta);
        }

        public final int size() {
            return this.source.size() - this.delta;
        }

        public final int knownSize() {
            int kn = this.source.knownSize();
            return kn >= 0 ? Integer.min(kn, this.n) : -1;
        }

        @NotNull
        public final LongIterator iterator() {
            int k = this.source.knownSize();
            if (k == 0 || this.n <= 0) {
                return LongIterator.empty();
            }
            if (this.n == Integer.MAX_VALUE) {
                return this.source.iterator();
            }
            if (k > 0) {
                return this.source.iterator().drop(Integer.max(k - this.n, 0));
            }
            return new AbstractLongIterator(){
                LongIterator it;
                int len;
                int pos;
                MutableLongArrayList buf;
                {
                    this.it = source.iterator();
                    this.len = -1;
                    this.pos = 0;
                    this.buf = null;
                }

                private void init() {
                    if (this.buf != null) {
                        return;
                    }
                    this.buf = new MutableLongArrayList();
                    this.len = 0;
                    while (this.it.hasNext()) {
                        long next = this.it.nextLong();
                        if (this.pos >= this.buf.size()) {
                            this.buf.append(next);
                        } else {
                            this.buf.set(this.pos, next);
                        }
                        if (++this.pos == n) {
                            this.pos = 0;
                        }
                        ++this.len;
                    }
                    this.it = null;
                    if (this.len > n) {
                        this.len = n;
                    }
                    this.pos -= this.len;
                    if (this.pos < 0) {
                        this.pos += n;
                    }
                }

                public final boolean hasNext() {
                    this.init();
                    return this.len > 0;
                }

                public final long nextLong() {
                    this.init();
                    if (this.len == 0) {
                        throw new NoSuchElementException();
                    }
                    long v = this.buf.get(this.pos);
                    ++this.pos;
                    if (this.pos == n) {
                        this.pos = 0;
                    }
                    --this.len;
                    return v;
                }
            };
        }
    }

    public static class Take
    extends AbstractLongSeqView {
        @NotNull
        protected final LongSeqView source;
        protected final @Range(from=1L, to=0x7FFFFFFFL) int n;

        public Take(@NotNull LongSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final LongIterator iterator() {
            return this.source.iterator().take(this.n);
        }

        @NotNull
        public LongStream stream() {
            return this.source.stream().limit(this.n);
        }

        @NotNull
        public LongStream parallelStream() {
            return this.source.stream().limit(this.n).parallel();
        }

        public int size() {
            if (this.n <= 0) {
                return 0;
            }
            return Integer.min(this.n, this.source.size());
        }

        public int knownSize() {
            if (this.n <= 0) {
                return 0;
            }
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return Integer.min(sks, this.n);
        }

        @Override
        @NotNull
        public LongSeqView take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            if (this.n <= n) {
                return this;
            }
            return new Take(this.source, n);
        }
    }

    public static class DropWhile
    extends AbstractLongSeqView {
        @NotNull
        private final LongSeqView source;
        @NotNull
        private final LongPredicate predicate;

        public DropWhile(@NotNull LongSeqView source, @NotNull LongPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final LongIterator iterator() {
            return this.source.iterator().dropWhile(this.predicate);
        }
    }

    public static class DropLast
    extends AbstractLongSeqView {
        @NotNull
        protected final LongSeqView source;
        private final @Range(from=1L, to=0x7FFFFFFFL) int n;

        public DropLast(@NotNull LongSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final LongIterator iterator() {
            int ss = this.source.size();
            if (this.n >= ss) {
                return LongIterator.empty();
            }
            return this.source.iterator().take(ss - this.n);
        }

        @Override
        public final long get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index(" + index + ") < 0");
            }
            LongSeqView source = this.source;
            int n = this.n;
            if (n <= 0) {
                return this.source.get(index);
            }
            int size = Integer.max(source.size() - n, 0);
            Conditions.checkElementIndex((int)index, (int)size);
            return this.source.get(index);
        }

        public final int size() {
            return Integer.max(0, this.source.size() - this.n);
        }

        public final int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            if (this.n >= sks) {
                return 0;
            }
            return sks - this.n;
        }
    }

    public static class Drop
    extends AbstractLongSeqView {
        @NotNull
        protected final LongSeqView source;
        protected final int n;

        public Drop(@NotNull LongSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final LongIterator iterator() {
            return this.iterator().drop(this.n);
        }

        @NotNull
        public LongStream stream() {
            return this.source.stream().skip(this.n);
        }

        @NotNull
        public LongStream parallelStream() {
            return this.source.stream().skip(this.n).parallel();
        }

        public final int size() {
            return Integer.max(0, this.source.size() - this.n);
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            return sks < 0 ? -1 : Integer.max(0, sks - this.n);
        }

        @Override
        @NotNull
        public LongSeqView drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            return this.source.drop(n + this.n);
        }
    }

    public static class Updated
    extends AbstractLongSeqView {
        @NotNull
        private final LongSeqView source;
        private final int index;
        private final long newValue;

        public Updated(@NotNull LongSeqView source, int index, long newValue) {
            this.source = source;
            this.index = index;
            this.newValue = newValue;
        }

        @NotNull
        public final LongIterator iterator() {
            return new AbstractLongIterator(){
                private final LongIterator it;
                private int i;
                {
                    this.it = source.iterator();
                    this.i = 0;
                }

                public final boolean hasNext() {
                    if (this.it.hasNext()) {
                        return true;
                    }
                    if (index >= this.i) {
                        throw new IndexOutOfBoundsException();
                    }
                    return false;
                }

                public final long nextLong() {
                    long value = this.it.next();
                    if (this.i++ == index) {
                        value = newValue;
                    }
                    return value;
                }
            };
        }

        public final int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public boolean isDefinedAt(int index) {
            return this.source.isDefinedAt(index);
        }

        @Override
        public final long get(int index) {
            if (index == this.index) {
                return this.newValue;
            }
            return this.source.get(index);
        }
    }

    public static class Slice
    extends AbstractLongSeqView {
        @NotNull
        protected final LongSeqView source;
        protected final int beginIndex;
        protected final int endIndex;

        public Slice(@NotNull LongSeqView source, int beginIndex, int endIndex) {
            this.source = source;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @NotNull
        public LongIterator iterator() {
            return new Itr();
        }

        public boolean isEmpty() {
            return this.beginIndex == this.endIndex;
        }

        public int size() {
            return this.endIndex - this.beginIndex;
        }

        public int knownSize() {
            return this.endIndex - this.beginIndex;
        }

        private final class Itr
        extends AbstractLongIterator {
            private int idx;
            private final LongIterator it;

            Itr() {
                LongIterator it = Slice.this.source.iterator();
                for (int i = Slice.this.beginIndex; i > 0; --i) {
                    try {
                        it.next();
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        throw new IndexOutOfBoundsException();
                    }
                }
                this.idx = Slice.this.beginIndex;
                this.it = it;
            }

            public final boolean hasNext() {
                return this.idx < Slice.this.endIndex;
            }

            public final long nextLong() {
                if (this.idx >= Slice.this.endIndex) {
                    throw new NoSuchElementException();
                }
                try {
                    long next = this.it.next();
                    ++this.idx;
                    return next;
                }
                catch (NoSuchElementException e) {
                    throw new IndexOutOfBoundsException();
                }
            }
        }
    }

    public static class WithCachedSize<C extends LongSeq>
    extends Of<C> {
        protected int cachedSize = -1;

        public WithCachedSize(@NotNull C source) {
            super(source);
        }

        public WithCachedSize(@NotNull C source, int size) {
            super(source);
            this.cachedSize = size;
        }

        @Override
        public boolean isEmpty() {
            int cachedSize = this.cachedSize;
            if (cachedSize == 0) {
                return true;
            }
            if (cachedSize > 0) {
                return false;
            }
            return ((LongSeq)this.source).isEmpty();
        }

        @Override
        public final int size() {
            int ss;
            if (this.cachedSize >= 0) {
                return this.cachedSize;
            }
            this.cachedSize = ss = ((LongSeq)this.source).size();
            return ss;
        }

        @Override
        public final int knownSize() {
            if (this.cachedSize >= 0) {
                return this.cachedSize;
            }
            int sks = ((LongSeq)this.source).knownSize();
            if (sks >= 0) {
                this.cachedSize = sks;
                return sks;
            }
            return -1;
        }
    }

    public static class OfArraySlice
    implements LongSeqView,
    IndexedLongSeqLike {
        protected final long[] array;
        protected final int beginIndex;
        protected final int endIndex;

        public OfArraySlice(long[] array, int beginIndex, int endIndex) {
            this.array = array;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public LongIterator iterator() {
            return LongArrays.iterator((long[])this.array, (int)this.beginIndex, (int)this.endIndex);
        }

        public final int size() {
            return this.endIndex - this.beginIndex;
        }

        public final int beginIndex() {
            return this.beginIndex;
        }

        public final int endIndex() {
            return this.endIndex;
        }

        @Override
        public final long get(int index) {
            Conditions.checkElementIndex((int)index, (int)this.size());
            return this.array[index + this.beginIndex];
        }

        @Override
        @NotNull
        public LongSeqView slice(int beginIndex, int endIndex) {
            Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size());
            int ns = endIndex - beginIndex;
            switch (ns) {
                case 0: {
                    return EMPTY;
                }
                case 1: {
                    return new Single(this.array[this.beginIndex + beginIndex]);
                }
            }
            return new OfArraySlice(this.array, this.beginIndex + beginIndex, this.beginIndex + endIndex);
        }

        @Override
        @NotNull
        public LongSeqView drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            int size = this.size();
            if (n >= size) {
                return EMPTY;
            }
            return new OfArraySlice(this.array, this.beginIndex + n, this.endIndex);
        }

        @Override
        @NotNull
        public LongSeqView dropLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            int size = this.size();
            if (n >= size) {
                return EMPTY;
            }
            return new OfArraySlice(this.array, this.beginIndex, this.endIndex - n);
        }

        @Override
        @NotNull
        public LongSeqView take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            int size = this.size();
            if (n >= size) {
                return this;
            }
            if (n == 1) {
                return new Single(this.array[this.beginIndex]);
            }
            return new OfArraySlice(this.array, this.beginIndex, this.beginIndex + n);
        }

        @Override
        @NotNull
        public LongSeqView takeLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            int size = this.size();
            if (n >= size) {
                return this;
            }
            if (n == 1) {
                return new Single(this.array[this.beginIndex]);
            }
            return new OfArraySlice(this.array, this.endIndex - n, this.endIndex);
        }
    }

    public static class Of<C extends LongSeqLike>
    extends LongCollectionViews.Of<C>
    implements LongSeqView {
        public Of(@NotNull C source) {
            super(source);
        }

        public boolean supportsFastRandomAccess() {
            return ((LongSeqLike)this.source).supportsFastRandomAccess();
        }

        @Override
        public long get(int index) {
            return ((LongSeqLike)this.source).get(index);
        }

        @Override
        public boolean isDefinedAt(int index) {
            return ((LongSeqLike)this.source).isDefinedAt(index);
        }

        @Override
        public int indexOf(long value) {
            return ((LongSeqLike)this.source).indexOf(value);
        }

        @Override
        public int indexOf(long value, int from) {
            return ((LongSeqLike)this.source).indexOf(value, from);
        }

        @Override
        public int indexWhere(@NotNull LongPredicate predicate) {
            return ((LongSeqLike)this.source).indexWhere(predicate);
        }

        @Override
        public int indexWhere(@NotNull LongPredicate predicate, int from) {
            return ((LongSeqLike)this.source).indexWhere(predicate, from);
        }

        @Override
        public int lastIndexOf(long value) {
            return ((LongSeqLike)this.source).lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(long value, int end) {
            return ((LongSeqLike)this.source).lastIndexOf(value, end);
        }

        @Override
        public int lastIndexWhere(@NotNull LongPredicate predicate) {
            return ((LongSeqLike)this.source).lastIndexWhere(predicate);
        }

        @Override
        public int lastIndexWhere(@NotNull LongPredicate predicate, int end) {
            return ((LongSeqLike)this.source).lastIndexWhere(predicate, end);
        }

        @Override
        @NotNull
        public LongIterator reverseIterator() {
            return ((LongSeqLike)this.source).reverseIterator();
        }
    }

    public static class Single
    extends LongCollectionViews.Single
    implements LongSeqView {
        public Single(long value) {
            super(value);
        }

        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public LongSeqView reversed() {
            return this;
        }

        @Override
        @NotNull
        public final LongIterator reverseIterator() {
            return LongIterator.of((long)this.value);
        }

        @Override
        public long get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this.value;
        }

        @Override
        @NotNull
        public LongSeqView updated(int index, long newValue) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return new Single(newValue);
        }
    }
}

