/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.util.Objects;
import kala.Conditions;
import kala.collection.base.AnyTraversable;
import kala.collection.base.primitive.BooleanArrays;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.base.primitive.BooleanTraversable;
import kala.collection.factory.primitive.BooleanCollectionFactory;
import kala.collection.immutable.primitive.ImmutableBooleanSeq;
import kala.collection.primitive.AbstractBooleanSeq;
import kala.collection.primitive.BooleanSeqLike;
import kala.function.BooleanPredicate;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractImmutableBooleanSeq
extends AbstractBooleanSeq
implements ImmutableBooleanSeq {
    static <T, Builder> T updated(@NotNull ImmutableBooleanSeq seq, int index, boolean newValue, @NotNull BooleanCollectionFactory<Builder, ? extends T> factory) {
        int s = seq.size();
        if (index < 0 || index >= s) {
            throw new IndexOutOfBoundsException();
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, s);
        BooleanIterator it = seq.iterator();
        while (it.hasNext()) {
            boolean e = it.nextBoolean();
            if (index-- == 0) {
                factory.addToBuilder(builder, newValue);
                continue;
            }
            factory.addToBuilder(builder, e);
        }
        return (T)factory.build(builder);
    }

    static <T extends ImmutableBooleanSeq, Builder> T slice(@NotNull ImmutableBooleanSeq seq, int beginIndex, int endIndex, @NotNull BooleanCollectionFactory<Builder, ? extends T> factory) {
        int size = seq.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int ns = endIndex - beginIndex;
        if (ns == 0) {
            return (T)((ImmutableBooleanSeq)factory.empty());
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, ns);
        if (seq.supportsFastRandomAccess()) {
            for (int i = beginIndex; i < endIndex; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            BooleanIterator it = seq.iterator().drop(beginIndex).take(ns);
            while (it.hasNext()) {
                factory.addToBuilder(builder, it.nextBoolean());
            }
        }
        return (T)((ImmutableBooleanSeq)factory.build(builder));
    }

    static <T extends ImmutableBooleanSeq, Builder> T drop(@NotNull ImmutableBooleanSeq seq, int n, @NotNull BooleanCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        Object builder = factory.newBuilder();
        int s = seq.knownSize();
        if (s >= 0) {
            factory.sizeHint(builder, Integer.max(s - n, 0));
        }
        BooleanIterator it = seq.iterator().drop(n);
        while (it.hasNext()) {
            boolean e = it.nextBoolean();
            factory.addToBuilder(builder, e);
        }
        return (T)((ImmutableBooleanSeq)factory.build(builder));
    }

    static <T extends ImmutableBooleanSeq, Builder> T dropLast(@NotNull ImmutableBooleanSeq seq, int n, @NotNull BooleanCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)seq;
        }
        int ss = seq.size();
        if (n >= ss) {
            return (T)((ImmutableBooleanSeq)factory.empty());
        }
        int ns = ss - n;
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, ns);
        if (seq.supportsFastRandomAccess()) {
            for (int i = 0; i < ns; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            BooleanIterator it = seq.iterator();
            for (int i = 0; i < ns; ++i) {
                factory.addToBuilder(builder, it.nextBoolean());
            }
        }
        return (T)((ImmutableBooleanSeq)factory.build(builder));
    }

    static <T extends ImmutableBooleanSeq, Builder> T dropWhile(@NotNull ImmutableBooleanSeq seq, @NotNull BooleanPredicate predicate, @NotNull BooleanCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        factory.addAllToBuilder(builder, seq.iterator().dropWhile(predicate));
        return (T)((ImmutableBooleanSeq)factory.build(builder));
    }

    static <T extends ImmutableBooleanSeq, Builder> T take(@NotNull ImmutableBooleanSeq seq, int n, @NotNull BooleanCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)((ImmutableBooleanSeq)factory.empty());
        }
        Object builder = factory.newBuilder();
        int s = seq.knownSize();
        if (s != -1) {
            factory.sizeHint(builder, Integer.min(s, n));
        }
        int count = 0;
        BooleanIterator it = seq.iterator();
        while (it.hasNext() && ++count <= n) {
            factory.addToBuilder(builder, it.nextBoolean());
        }
        return (T)((ImmutableBooleanSeq)factory.build(builder));
    }

    static <T extends ImmutableBooleanSeq, Builder> T takeLast(@NotNull ImmutableBooleanSeq seq, int n, @NotNull BooleanCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)((ImmutableBooleanSeq)factory.empty());
        }
        int ss = seq.size();
        if (n >= ss) {
            return (T)seq;
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, n);
        if (seq.supportsFastRandomAccess()) {
            for (int i = ss - n; i < ss; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            BooleanIterator it = seq.iterator();
            for (int i = 0; i < ss - n; ++i) {
                it.nextBoolean();
            }
            while (it.hasNext()) {
                factory.addToBuilder(builder, it.nextBoolean());
            }
        }
        return (T)((ImmutableBooleanSeq)factory.build(builder));
    }

    static <T extends ImmutableBooleanSeq, Builder> T takeWhile(@NotNull ImmutableBooleanSeq seq, @NotNull BooleanPredicate predicate, @NotNull BooleanCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        seq.forEachBreakable(e -> {
            if (!predicate.test(e)) {
                return false;
            }
            factory.addToBuilder(builder, e);
            return true;
        });
        return (T)((ImmutableBooleanSeq)factory.build(builder));
    }

    static <T extends ImmutableBooleanSeq, Builder> T concat(@NotNull ImmutableBooleanSeq seq, @NotNull BooleanSeqLike other, @NotNull BooleanCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(other);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (BooleanTraversable)seq);
        factory.sizeHint(builder, (AnyTraversable)other);
        factory.addAllToBuilder(builder, (BooleanTraversable)other);
        return (T)((ImmutableBooleanSeq)factory.build(builder));
    }

    static <T, Builder> T prepended(@NotNull ImmutableBooleanSeq seq, boolean element, @NotNull BooleanCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, 1);
        factory.addToBuilder(builder, element);
        factory.addAllToBuilder(builder, (BooleanTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T prependedAll(@NotNull ImmutableBooleanSeq seq, boolean @NotNull [] values, @NotNull BooleanCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, values.length);
        for (boolean e : values) {
            factory.addToBuilder(builder, e);
        }
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (BooleanTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T prependedAll(@NotNull ImmutableBooleanSeq seq, @NotNull BooleanTraversable values, @NotNull BooleanCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)values);
        factory.addAllToBuilder(builder, values);
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (BooleanTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T appended(@NotNull ImmutableBooleanSeq seq, boolean element, @NotNull BooleanCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, 1);
        factory.addAllToBuilder(builder, (BooleanTraversable)seq);
        factory.addToBuilder(builder, element);
        return (T)factory.build(builder);
    }

    static <T, Builder> T appendedAll(@NotNull ImmutableBooleanSeq seq, boolean @NotNull [] values, @NotNull BooleanCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, values.length);
        factory.addAllToBuilder(builder, (BooleanTraversable)seq);
        for (boolean e : values) {
            factory.addToBuilder(builder, e);
        }
        return (T)factory.build(builder);
    }

    static <T, Builder> T appendedAll(@NotNull ImmutableBooleanSeq seq, @NotNull BooleanTraversable values, @NotNull BooleanCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (BooleanTraversable)seq);
        factory.sizeHint(builder, (AnyTraversable)values);
        factory.addAllToBuilder(builder, values);
        return (T)factory.build(builder);
    }

    static <T, Builder> T sorted(@NotNull ImmutableBooleanSeq seq, @NotNull BooleanCollectionFactory<Builder, ? extends T> factory) {
        if (seq.isEmpty()) {
            return (T)factory.empty();
        }
        boolean[] arr = seq.toArray();
        BooleanArrays.sort((boolean[])arr);
        return (T)factory.from(arr);
    }

    static <T, Builder> T reversed(@NotNull ImmutableBooleanSeq seq, @NotNull BooleanCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, seq.reverseIterator());
        return (T)factory.build(builder);
    }
}

