/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.util.Objects;
import kala.collection.base.AnyTraversable;
import kala.collection.base.primitive.ByteTraversable;
import kala.collection.factory.primitive.ByteCollectionFactory;
import kala.collection.immutable.primitive.ImmutableByteCollection;
import kala.collection.primitive.AbstractByteCollection;
import kala.function.ByteFunction;
import kala.function.BytePredicate;
import kala.function.ByteUnaryOperator;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractImmutableByteCollection
extends AbstractByteCollection
implements ImmutableByteCollection {
    static <T, Builder> T filter(@NotNull ImmutableByteCollection collection, @NotNull BytePredicate predicate, @NotNull ByteCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        collection.forEach(e -> {
            if (predicate.test(e)) {
                factory.addToBuilder(builder, e);
            }
        });
        return (T)factory.build(builder);
    }

    static <T, Builder> T filterNot(@NotNull ImmutableByteCollection collection, @NotNull BytePredicate predicate, @NotNull ByteCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        collection.forEach(e -> {
            if (!predicate.test(e)) {
                factory.addToBuilder(builder, e);
            }
        });
        return (T)factory.build(builder);
    }

    static <U, T, Builder> T map(@NotNull ImmutableByteCollection collection, @NotNull ByteUnaryOperator mapper, @NotNull ByteCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(mapper);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)collection);
        collection.forEach(e -> factory.addToBuilder(builder, mapper.applyAsByte(e)));
        return (T)factory.build(builder);
    }

    static <T, Builder> T flatMap(@NotNull ImmutableByteCollection collection, @NotNull ByteFunction<? extends ByteTraversable> mapper, @NotNull ByteCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(mapper);
        Object builder = factory.newBuilder();
        collection.forEach(e -> {
            ByteTraversable us = (ByteTraversable)mapper.apply(e);
            factory.sizeHint(builder, (AnyTraversable)us);
            us.forEach(u -> factory.addToBuilder(builder, u));
        });
        return (T)factory.build(builder);
    }
}

