/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.util.Objects;
import java.util.function.IntPredicate;
import kala.Conditions;
import kala.collection.base.AnyTraversable;
import kala.collection.base.primitive.IntArrays;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.factory.primitive.IntCollectionFactory;
import kala.collection.immutable.primitive.ImmutableIntSeq;
import kala.collection.primitive.AbstractIntSeq;
import kala.collection.primitive.IntSeqLike;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractImmutableIntSeq
extends AbstractIntSeq
implements ImmutableIntSeq {
    static <T, Builder> T updated(@NotNull ImmutableIntSeq seq, int index, int newValue, @NotNull IntCollectionFactory<Builder, ? extends T> factory) {
        int s = seq.size();
        if (index < 0 || index >= s) {
            throw new IndexOutOfBoundsException();
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, s);
        IntIterator it = seq.iterator();
        while (it.hasNext()) {
            int e = it.nextInt();
            if (index-- == 0) {
                factory.addToBuilder(builder, newValue);
                continue;
            }
            factory.addToBuilder(builder, e);
        }
        return (T)factory.build(builder);
    }

    static <T extends ImmutableIntSeq, Builder> T slice(@NotNull ImmutableIntSeq seq, int beginIndex, int endIndex, @NotNull IntCollectionFactory<Builder, ? extends T> factory) {
        int size = seq.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int ns = endIndex - beginIndex;
        if (ns == 0) {
            return (T)((ImmutableIntSeq)factory.empty());
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, ns);
        if (seq.supportsFastRandomAccess()) {
            for (int i = beginIndex; i < endIndex; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            IntIterator it = seq.iterator().drop(beginIndex).take(ns);
            while (it.hasNext()) {
                factory.addToBuilder(builder, it.nextInt());
            }
        }
        return (T)((ImmutableIntSeq)factory.build(builder));
    }

    static <T extends ImmutableIntSeq, Builder> T drop(@NotNull ImmutableIntSeq seq, int n, @NotNull IntCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        Object builder = factory.newBuilder();
        int s = seq.knownSize();
        if (s >= 0) {
            factory.sizeHint(builder, Integer.max(s - n, 0));
        }
        IntIterator it = seq.iterator().drop(n);
        while (it.hasNext()) {
            int e = it.nextInt();
            factory.addToBuilder(builder, e);
        }
        return (T)((ImmutableIntSeq)factory.build(builder));
    }

    static <T extends ImmutableIntSeq, Builder> T dropLast(@NotNull ImmutableIntSeq seq, int n, @NotNull IntCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)seq;
        }
        int ss = seq.size();
        if (n >= ss) {
            return (T)((ImmutableIntSeq)factory.empty());
        }
        int ns = ss - n;
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, ns);
        if (seq.supportsFastRandomAccess()) {
            for (int i = 0; i < ns; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            IntIterator it = seq.iterator();
            for (int i = 0; i < ns; ++i) {
                factory.addToBuilder(builder, it.nextInt());
            }
        }
        return (T)((ImmutableIntSeq)factory.build(builder));
    }

    static <T extends ImmutableIntSeq, Builder> T dropWhile(@NotNull ImmutableIntSeq seq, @NotNull IntPredicate predicate, @NotNull IntCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        factory.addAllToBuilder(builder, seq.iterator().dropWhile(predicate));
        return (T)((ImmutableIntSeq)factory.build(builder));
    }

    static <T extends ImmutableIntSeq, Builder> T take(@NotNull ImmutableIntSeq seq, int n, @NotNull IntCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)((ImmutableIntSeq)factory.empty());
        }
        Object builder = factory.newBuilder();
        int s = seq.knownSize();
        if (s != -1) {
            factory.sizeHint(builder, Integer.min(s, n));
        }
        int count = 0;
        IntIterator it = seq.iterator();
        while (it.hasNext() && ++count <= n) {
            factory.addToBuilder(builder, it.nextInt());
        }
        return (T)((ImmutableIntSeq)factory.build(builder));
    }

    static <T extends ImmutableIntSeq, Builder> T takeLast(@NotNull ImmutableIntSeq seq, int n, @NotNull IntCollectionFactory<Builder, ? extends T> factory) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return (T)((ImmutableIntSeq)factory.empty());
        }
        int ss = seq.size();
        if (n >= ss) {
            return (T)seq;
        }
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, n);
        if (seq.supportsFastRandomAccess()) {
            for (int i = ss - n; i < ss; ++i) {
                factory.addToBuilder(builder, seq.get(i));
            }
        } else {
            IntIterator it = seq.iterator();
            for (int i = 0; i < ss - n; ++i) {
                it.nextInt();
            }
            while (it.hasNext()) {
                factory.addToBuilder(builder, it.nextInt());
            }
        }
        return (T)((ImmutableIntSeq)factory.build(builder));
    }

    static <T extends ImmutableIntSeq, Builder> T takeWhile(@NotNull ImmutableIntSeq seq, @NotNull IntPredicate predicate, @NotNull IntCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        seq.forEachBreakable(e -> {
            if (!predicate.test(e)) {
                return false;
            }
            factory.addToBuilder(builder, e);
            return true;
        });
        return (T)((ImmutableIntSeq)factory.build(builder));
    }

    static <T extends ImmutableIntSeq, Builder> T concat(@NotNull ImmutableIntSeq seq, @NotNull IntSeqLike other, @NotNull IntCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(other);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (IntTraversable)seq);
        factory.sizeHint(builder, (AnyTraversable)other);
        factory.addAllToBuilder(builder, (IntTraversable)other);
        return (T)((ImmutableIntSeq)factory.build(builder));
    }

    static <T, Builder> T prepended(@NotNull ImmutableIntSeq seq, int element, @NotNull IntCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, 1);
        factory.addToBuilder(builder, element);
        factory.addAllToBuilder(builder, (IntTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T prependedAll(@NotNull ImmutableIntSeq seq, int @NotNull [] values, @NotNull IntCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, values.length);
        for (int e : values) {
            factory.addToBuilder(builder, e);
        }
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (IntTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T prependedAll(@NotNull ImmutableIntSeq seq, @NotNull IntTraversable values, @NotNull IntCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)values);
        factory.addAllToBuilder(builder, values);
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (IntTraversable)seq);
        return (T)factory.build(builder);
    }

    static <T, Builder> T appended(@NotNull ImmutableIntSeq seq, int element, @NotNull IntCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, 1);
        factory.addAllToBuilder(builder, (IntTraversable)seq);
        factory.addToBuilder(builder, element);
        return (T)factory.build(builder);
    }

    static <T, Builder> T appendedAll(@NotNull ImmutableIntSeq seq, int @NotNull [] values, @NotNull IntCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq, values.length);
        factory.addAllToBuilder(builder, (IntTraversable)seq);
        for (int e : values) {
            factory.addToBuilder(builder, e);
        }
        return (T)factory.build(builder);
    }

    static <T, Builder> T appendedAll(@NotNull ImmutableIntSeq seq, @NotNull IntTraversable values, @NotNull IntCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(values);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, (IntTraversable)seq);
        factory.sizeHint(builder, (AnyTraversable)values);
        factory.addAllToBuilder(builder, values);
        return (T)factory.build(builder);
    }

    static <T, Builder> T sorted(@NotNull ImmutableIntSeq seq, @NotNull IntCollectionFactory<Builder, ? extends T> factory) {
        if (seq.isEmpty()) {
            return (T)factory.empty();
        }
        int[] arr = seq.toArray();
        IntArrays.sort((int[])arr);
        return (T)factory.from(arr);
    }

    static <T, Builder> T reversed(@NotNull ImmutableIntSeq seq, @NotNull IntCollectionFactory<Builder, ? extends T> factory) {
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)seq);
        factory.addAllToBuilder(builder, seq.reverseIterator());
        return (T)factory.build(builder);
    }
}

