/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.io.Serializable;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.base.primitive.BooleanTraversable;
import kala.collection.factory.primitive.BooleanCollectionFactory;
import kala.collection.immutable.primitive.AbstractImmutableBooleanSet;
import kala.collection.immutable.primitive.ImmutableBooleanSet;
import kala.collection.mutable.primitive.MutableBooleanSet;
import org.jetbrains.annotations.NotNull;

final class DefaultImmutableBooleanSet
extends AbstractImmutableBooleanSet
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final Factory FACTORY = new Factory();
    private static final DefaultImmutableBooleanSet EMPTY = new DefaultImmutableBooleanSet(false, false);
    private static final DefaultImmutableBooleanSet FALSE = new DefaultImmutableBooleanSet(true, false);
    private static final DefaultImmutableBooleanSet TRUE = new DefaultImmutableBooleanSet(false, true);
    private static final DefaultImmutableBooleanSet ALL = new DefaultImmutableBooleanSet(true, true);
    private final boolean containsFalse;
    private final boolean containsTrue;

    static DefaultImmutableBooleanSet get(boolean containsFalse, boolean containsTrue) {
        if (containsFalse) {
            return containsTrue ? ALL : FALSE;
        }
        if (containsTrue) {
            return TRUE;
        }
        return EMPTY;
    }

    private DefaultImmutableBooleanSet(boolean containsFalse, boolean containsTrue) {
        this.containsFalse = containsFalse;
        this.containsTrue = containsTrue;
    }

    static BooleanCollectionFactory<?, DefaultImmutableBooleanSet> factory() {
        return FACTORY;
    }

    @NotNull
    static DefaultImmutableBooleanSet empty() {
        return EMPTY;
    }

    @NotNull
    static DefaultImmutableBooleanSet of() {
        return DefaultImmutableBooleanSet.empty();
    }

    @NotNull
    static DefaultImmutableBooleanSet of(boolean value1) {
        return value1 ? TRUE : FALSE;
    }

    @NotNull
    static DefaultImmutableBooleanSet of(boolean value1, boolean value2) {
        return value1 == value2 ? DefaultImmutableBooleanSet.of(value1) : ALL;
    }

    @NotNull
    static DefaultImmutableBooleanSet of(boolean value1, boolean value2, boolean value3) {
        boolean cf = false;
        boolean ct = false;
        if (value1) {
            ct = true;
        } else {
            cf = true;
        }
        if (value2) {
            ct = true;
        } else {
            cf = true;
        }
        if (value3) {
            ct = true;
        } else {
            cf = true;
        }
        return DefaultImmutableBooleanSet.get(cf, ct);
    }

    @NotNull
    static DefaultImmutableBooleanSet of(boolean value1, boolean value2, boolean value3, boolean value4) {
        boolean cf = false;
        boolean ct = false;
        if (value1) {
            ct = true;
        } else {
            cf = true;
        }
        if (value2) {
            ct = true;
        } else {
            cf = true;
        }
        if (value3) {
            ct = true;
        } else {
            cf = true;
        }
        if (value4) {
            ct = true;
        } else {
            cf = true;
        }
        return DefaultImmutableBooleanSet.get(cf, ct);
    }

    @NotNull
    static DefaultImmutableBooleanSet of(boolean value1, boolean value2, boolean value3, boolean value4, boolean value5) {
        boolean cf = false;
        boolean ct = false;
        if (value1) {
            ct = true;
        } else {
            cf = true;
        }
        if (value2) {
            ct = true;
        } else {
            cf = true;
        }
        if (value3) {
            ct = true;
        } else {
            cf = true;
        }
        if (value4) {
            ct = true;
        } else {
            cf = true;
        }
        if (value5) {
            ct = true;
        } else {
            cf = true;
        }
        return DefaultImmutableBooleanSet.get(cf, ct);
    }

    @NotNull
    static DefaultImmutableBooleanSet of(boolean ... values) {
        return DefaultImmutableBooleanSet.from(values);
    }

    @NotNull
    static DefaultImmutableBooleanSet from(boolean @NotNull [] values) {
        if (values.length == 0) {
            return EMPTY;
        }
        boolean cf = false;
        boolean ct = false;
        for (boolean value : values) {
            if (!value) {
                cf = true;
            } else {
                ct = true;
            }
            if (!cf || !ct) continue;
            return ALL;
        }
        return DefaultImmutableBooleanSet.get(cf, ct);
    }

    @NotNull
    static DefaultImmutableBooleanSet from(@NotNull BooleanTraversable values) {
        return DefaultImmutableBooleanSet.from(values.iterator());
    }

    @NotNull
    static DefaultImmutableBooleanSet from(@NotNull BooleanIterator it) {
        boolean cf = false;
        boolean ct = false;
        while (it.hasNext()) {
            if (!it.nextBoolean()) {
                cf = true;
            } else {
                ct = true;
            }
            if (!cf || !ct) continue;
            return ALL;
        }
        return DefaultImmutableBooleanSet.get(cf, ct);
    }

    @Override
    public boolean containsFalse() {
        return this.containsFalse;
    }

    @Override
    public boolean containsTrue() {
        return this.containsTrue;
    }

    @Override
    @NotNull
    public ImmutableBooleanSet added(boolean value) {
        if (!value) {
            return this.containsFalse ? this : DefaultImmutableBooleanSet.get(true, this.containsTrue);
        }
        return this.containsTrue ? this : DefaultImmutableBooleanSet.get(this.containsFalse, true);
    }

    private Object readResolve() {
        if (this.containsFalse) {
            return this.containsTrue ? ALL : FALSE;
        }
        if (this.containsTrue) {
            return TRUE;
        }
        return EMPTY;
    }

    private static final class Factory
    implements BooleanCollectionFactory<MutableBooleanSet, DefaultImmutableBooleanSet> {
        private Factory() {
        }

        public DefaultImmutableBooleanSet empty() {
            return EMPTY;
        }

        public MutableBooleanSet newBuilder() {
            return MutableBooleanSet.create();
        }

        public void addToBuilder(@NotNull MutableBooleanSet builder, boolean value) {
            builder.add(value);
        }

        public DefaultImmutableBooleanSet build(MutableBooleanSet builder) {
            return DefaultImmutableBooleanSet.get(builder.containsFalse(), builder.containsTrue());
        }

        public MutableBooleanSet mergeBuilder(@NotNull MutableBooleanSet builder1, @NotNull MutableBooleanSet builder2) {
            builder1.addAll(builder2);
            return builder1;
        }
    }
}

