/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import kala.collection.base.primitive.FloatArrays;
import kala.collection.base.primitive.FloatIterator;
import kala.collection.base.primitive.FloatTraversable;
import kala.collection.factory.primitive.FloatCollectionFactory;
import kala.collection.immutable.primitive.ImmutableFloatSeq;
import kala.collection.mutable.primitive.MutableFloatArrayList;
import kala.collection.primitive.FloatArraySeq;
import kala.function.FloatSupplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ImmutableFloatArray
extends FloatArraySeq
implements ImmutableFloatSeq,
Serializable {
    private static final long serialVersionUID = 1845940935381169058L;
    public static final ImmutableFloatArray EMPTY = new ImmutableFloatArray(FloatArrays.EMPTY);
    private static final Factory FACTORY = new Factory();

    ImmutableFloatArray(float @NotNull [] elements) {
        super(elements);
    }

    @NotNull
    public static FloatCollectionFactory<?, ? extends ImmutableFloatArray> factory() {
        return FACTORY;
    }

    @NotNull
    public static ImmutableFloatArray empty() {
        return EMPTY;
    }

    @NotNull
    public static ImmutableFloatArray of() {
        return ImmutableFloatArray.empty();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ImmutableFloatArray of(float value1) {
        return new ImmutableFloatArray(new float[]{value1});
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static ImmutableFloatArray of(float value1, float value2) {
        return new ImmutableFloatArray(new float[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableFloatArray of(float value1, float value2, float value3) {
        return new ImmutableFloatArray(new float[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableFloatArray of(float value1, float value2, float value3, float value4) {
        return new ImmutableFloatArray(new float[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableFloatArray of(float value1, float value2, float value3, float value4, float value5) {
        return new ImmutableFloatArray(new float[]{value1, value2, value3, value4, value5});
    }

    @Contract(pure=true)
    @NotNull
    public static ImmutableFloatArray of(float ... values) {
        return ImmutableFloatArray.from(values);
    }

    @Contract(pure=true)
    @NotNull
    public static ImmutableFloatArray from(float @NotNull [] values) {
        return values.length == 0 ? ImmutableFloatArray.empty() : new ImmutableFloatArray((float[])values.clone());
    }

    @NotNull
    public static ImmutableFloatArray from(@NotNull FloatTraversable values) {
        if (values instanceof ImmutableFloatArray) {
            return (ImmutableFloatArray)values;
        }
        if (values.isEmpty()) {
            return ImmutableFloatArray.empty();
        }
        float[] arr = values.toArray();
        return arr.length == 0 ? ImmutableFloatArray.empty() : new ImmutableFloatArray(arr);
    }

    @NotNull
    public static ImmutableFloatArray from(@NotNull FloatIterator it) {
        if (!it.hasNext()) {
            return ImmutableFloatArray.empty();
        }
        return new ImmutableFloatArray(it.toArray());
    }

    @NotNull
    public static ImmutableFloatArray fill(int n, float value) {
        if (n <= 0) {
            return ImmutableFloatArray.empty();
        }
        float[] ans = new float[n];
        if (value != 0.0f) {
            Arrays.fill(ans, value);
        }
        return new ImmutableFloatArray(ans);
    }

    @NotNull
    public static ImmutableFloatArray fill(int n, @NotNull FloatSupplier supplier) {
        if (n <= 0) {
            return ImmutableFloatArray.empty();
        }
        float[] ans = new float[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsFloat();
        }
        return new ImmutableFloatArray(ans);
    }

    float @NotNull [] getArray() {
        return this.elements;
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableFloatArray";
    }

    private static final class Factory
    implements FloatCollectionFactory<MutableFloatArrayList, ImmutableFloatArray> {
        private Factory() {
        }

        public ImmutableFloatArray empty() {
            return ImmutableFloatArray.empty();
        }

        public ImmutableFloatArray from(float @NotNull [] values) {
            return ImmutableFloatArray.from(values);
        }

        public ImmutableFloatArray from(@NotNull FloatTraversable values) {
            return ImmutableFloatArray.from(values);
        }

        public ImmutableFloatArray from(@NotNull FloatIterator it) {
            return ImmutableFloatArray.from(it);
        }

        public ImmutableFloatArray fill(int n, float value) {
            return ImmutableFloatArray.fill(n, value);
        }

        public ImmutableFloatArray fill(int n, @NotNull FloatSupplier supplier) {
            return ImmutableFloatArray.fill(n, supplier);
        }

        public MutableFloatArrayList newBuilder() {
            return new MutableFloatArrayList();
        }

        public void addToBuilder(@NotNull MutableFloatArrayList buffer, float value) {
            buffer.append(value);
        }

        public MutableFloatArrayList mergeBuilder(@NotNull MutableFloatArrayList builder1, @NotNull MutableFloatArrayList builder2) {
            builder1.appendAll(builder2);
            return builder1;
        }

        public void sizeHint(@NotNull MutableFloatArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public ImmutableFloatArray build(@NotNull MutableFloatArrayList buffer) {
            return new ImmutableFloatArray(buffer.toArray());
        }
    }

    public static final class Unsafe {
        private Unsafe() {
        }

        @Contract(value="_ -> new")
        @NotNull
        public static ImmutableFloatArray wrap(float @NotNull [] array) {
            Objects.requireNonNull(array);
            return new ImmutableFloatArray(array);
        }
    }
}

