/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.IntSupplier;
import kala.collection.base.primitive.IntArrays;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.factory.primitive.IntCollectionFactory;
import kala.collection.immutable.primitive.ImmutableIntSeq;
import kala.collection.mutable.primitive.MutableIntArrayList;
import kala.collection.primitive.IntArraySeq;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ImmutableIntArray
extends IntArraySeq
implements ImmutableIntSeq,
Serializable {
    private static final long serialVersionUID = 1845940935381169058L;
    public static final ImmutableIntArray EMPTY = new ImmutableIntArray(IntArrays.EMPTY);
    private static final Factory FACTORY = new Factory();

    ImmutableIntArray(int @NotNull [] elements) {
        super(elements);
    }

    @NotNull
    public static IntCollectionFactory<?, ? extends ImmutableIntArray> factory() {
        return FACTORY;
    }

    @NotNull
    public static ImmutableIntArray empty() {
        return EMPTY;
    }

    @NotNull
    public static ImmutableIntArray of() {
        return ImmutableIntArray.empty();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ImmutableIntArray of(int value1) {
        return new ImmutableIntArray(new int[]{value1});
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static ImmutableIntArray of(int value1, int value2) {
        return new ImmutableIntArray(new int[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableIntArray of(int value1, int value2, int value3) {
        return new ImmutableIntArray(new int[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableIntArray of(int value1, int value2, int value3, int value4) {
        return new ImmutableIntArray(new int[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableIntArray of(int value1, int value2, int value3, int value4, int value5) {
        return new ImmutableIntArray(new int[]{value1, value2, value3, value4, value5});
    }

    @Contract(pure=true)
    @NotNull
    public static ImmutableIntArray of(int ... values) {
        return ImmutableIntArray.from(values);
    }

    @Contract(pure=true)
    @NotNull
    public static ImmutableIntArray from(int @NotNull [] values) {
        return values.length == 0 ? ImmutableIntArray.empty() : new ImmutableIntArray((int[])values.clone());
    }

    @NotNull
    public static ImmutableIntArray from(@NotNull IntTraversable values) {
        if (values instanceof ImmutableIntArray) {
            return (ImmutableIntArray)values;
        }
        if (values.isEmpty()) {
            return ImmutableIntArray.empty();
        }
        int[] arr = values.toArray();
        return arr.length == 0 ? ImmutableIntArray.empty() : new ImmutableIntArray(arr);
    }

    @NotNull
    public static ImmutableIntArray from(@NotNull IntIterator it) {
        if (!it.hasNext()) {
            return ImmutableIntArray.empty();
        }
        return new ImmutableIntArray(it.toArray());
    }

    @NotNull
    public static ImmutableIntArray fill(int n, int value) {
        if (n <= 0) {
            return ImmutableIntArray.empty();
        }
        int[] ans = new int[n];
        if (value != 0) {
            Arrays.fill(ans, value);
        }
        return new ImmutableIntArray(ans);
    }

    @NotNull
    public static ImmutableIntArray fill(int n, @NotNull IntSupplier supplier) {
        if (n <= 0) {
            return ImmutableIntArray.empty();
        }
        int[] ans = new int[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsInt();
        }
        return new ImmutableIntArray(ans);
    }

    int @NotNull [] getArray() {
        return this.elements;
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableIntArray";
    }

    @NotNull
    public Spliterator.OfInt spliterator() {
        return Spliterators.spliterator(this.elements, 1024);
    }

    private static final class Factory
    implements IntCollectionFactory<MutableIntArrayList, ImmutableIntArray> {
        private Factory() {
        }

        public ImmutableIntArray empty() {
            return ImmutableIntArray.empty();
        }

        public ImmutableIntArray from(int @NotNull [] values) {
            return ImmutableIntArray.from(values);
        }

        public ImmutableIntArray from(@NotNull IntTraversable values) {
            return ImmutableIntArray.from(values);
        }

        public ImmutableIntArray from(@NotNull IntIterator it) {
            return ImmutableIntArray.from(it);
        }

        public ImmutableIntArray fill(int n, int value) {
            return ImmutableIntArray.fill(n, value);
        }

        public ImmutableIntArray fill(int n, @NotNull IntSupplier supplier) {
            return ImmutableIntArray.fill(n, supplier);
        }

        public MutableIntArrayList newBuilder() {
            return new MutableIntArrayList();
        }

        public void addToBuilder(@NotNull MutableIntArrayList buffer, int value) {
            buffer.append(value);
        }

        public MutableIntArrayList mergeBuilder(@NotNull MutableIntArrayList builder1, @NotNull MutableIntArrayList builder2) {
            builder1.appendAll(builder2);
            return builder1;
        }

        public void sizeHint(@NotNull MutableIntArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public ImmutableIntArray build(@NotNull MutableIntArrayList buffer) {
            return new ImmutableIntArray(buffer.toArray());
        }
    }

    public static final class Unsafe {
        private Unsafe() {
        }

        @Contract(value="_ -> new")
        @NotNull
        public static ImmutableIntArray wrap(int @NotNull [] array) {
            Objects.requireNonNull(array);
            return new ImmutableIntArray(array);
        }
    }
}

