/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.Objects;
import kala.collection.base.primitive.BooleanGrowable;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.base.primitive.BooleanTraversable;
import kala.collection.factory.primitive.BooleanCollectionFactory;
import kala.collection.mutable.primitive.DefaultMutableBooleanSet;
import kala.collection.mutable.primitive.MutableBooleanCollection;
import kala.collection.mutable.primitive.MutablePrimitiveSet;
import kala.collection.primitive.BooleanArraySeq;
import kala.collection.primitive.BooleanSet;
import kala.function.BooleanPredicate;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface MutableBooleanSet
extends MutablePrimitiveSet<Boolean>,
BooleanSet,
MutableBooleanCollection,
BooleanGrowable {
    @Contract(pure=true)
    @NotNull
    public static BooleanCollectionFactory<?, MutableBooleanSet> factory() {
        return BooleanCollectionFactory.narrow(DefaultMutableBooleanSet.factory());
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableBooleanSet create() {
        return DefaultMutableBooleanSet.create();
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableBooleanSet of() {
        return DefaultMutableBooleanSet.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableBooleanSet of(boolean value1) {
        return DefaultMutableBooleanSet.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableBooleanSet of(boolean value1, boolean value2) {
        return DefaultMutableBooleanSet.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableBooleanSet of(boolean value1, boolean value2, boolean value3) {
        return DefaultMutableBooleanSet.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableBooleanSet of(boolean value1, boolean value2, boolean value3, boolean value4) {
        return DefaultMutableBooleanSet.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableBooleanSet of(boolean value1, boolean value2, boolean value3, boolean value4, boolean value5) {
        return DefaultMutableBooleanSet.of(value1, value2, value3, value4, value5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableBooleanSet of(boolean ... values) {
        return DefaultMutableBooleanSet.of(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableBooleanSet from(boolean @NotNull [] values) {
        return DefaultMutableBooleanSet.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableBooleanSet from(@NotNull BooleanTraversable values) {
        return DefaultMutableBooleanSet.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableBooleanSet from(@NotNull BooleanIterator it) {
        return DefaultMutableBooleanSet.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableBooleanSet";
    }

    @NotNull
    default public BooleanCollectionFactory<?, ? extends MutableBooleanSet> iterableFactory() {
        return MutableBooleanSet.factory();
    }

    @Contract(mutates="this")
    public boolean add(@Flow(targetIsContainer=true) boolean var1);

    @Contract(mutates="this")
    default public boolean addAll(@Flow(sourceIsContainer=true, targetIsContainer=true) boolean @NotNull [] values) {
        Objects.requireNonNull(values);
        return this.addAll(BooleanArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean addAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) BooleanTraversable values) {
        if (values == this) {
            return false;
        }
        boolean m = false;
        BooleanIterator it = values.iterator();
        while (it.hasNext()) {
            if (!this.add(it.nextBoolean())) continue;
            m = true;
        }
        return m;
    }

    default public void plusAssign(boolean value) {
        this.add(value);
    }

    default public void plusAssign(boolean @NotNull [] values) {
        this.addAll(values);
    }

    default public void plusAssign(@NotNull BooleanTraversable values) {
        this.addAll(values);
    }

    @Contract(mutates="this")
    public void clear();

    default public void trimToSize() {
    }

    @Contract(mutates="this")
    public boolean remove(boolean var1);

    @Contract(mutates="this")
    default public boolean removeAll(boolean @NotNull [] values) {
        Objects.requireNonNull(values);
        return this.removeAll(BooleanArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean removeAll(@NotNull BooleanTraversable values) {
        Objects.requireNonNull(values);
        boolean m = false;
        BooleanIterator it = values.iterator();
        while (it.hasNext()) {
            if (!this.remove(it.nextBoolean())) continue;
            m = true;
        }
        return m;
    }

    @Contract(mutates="this")
    default public boolean removeAll(@NotNull BooleanPredicate predicate) {
        Objects.requireNonNull(predicate);
        boolean[] arr = this.toArray();
        int oldSize = arr.length;
        for (boolean e : arr) {
            if (!predicate.test(e)) continue;
            this.remove(e);
        }
        return this.size() != oldSize;
    }

    @Contract(mutates="this")
    default public boolean retainAll(boolean @NotNull [] values) {
        return this.retainAll(BooleanArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean retainAll(@NotNull BooleanTraversable values) {
        Objects.requireNonNull(values);
        if (this.isEmpty() || values.isEmpty()) {
            return false;
        }
        boolean[] arr = this.toArray();
        int oldSize = arr.length;
        BooleanIterator it = this.iterator();
        while (it.hasNext()) {
            boolean v = it.nextBoolean();
            if (values.contains(v)) continue;
            this.remove(v);
        }
        return this.size() != oldSize;
    }

    @Contract(mutates="this")
    default public boolean retainAll(@NotNull BooleanPredicate predicate) {
        Objects.requireNonNull(predicate);
        boolean[] arr = this.toArray();
        int oldSize = arr.length;
        for (boolean e : arr) {
            if (predicate.test(e)) continue;
            this.remove(e);
        }
        return this.size() != oldSize;
    }

    @Contract(mutates="this")
    default public void filterInPlace(@NotNull BooleanPredicate predicate) {
        this.retainAll(predicate);
    }

    @Contract(mutates="this")
    default public void filterNotInPlace(@NotNull BooleanPredicate predicate) {
        this.removeAll(predicate);
    }
}

