/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import kala.Conditions;
import kala.collection.base.primitive.ByteArrays;
import kala.collection.base.primitive.ByteIterator;
import kala.collection.base.primitive.ByteTraversable;
import kala.collection.factory.primitive.ByteCollectionFactory;
import kala.collection.mutable.primitive.MutableByteArray;
import kala.collection.mutable.primitive.MutableByteCollection;
import kala.collection.mutable.primitive.MutableByteSeqIterator;
import kala.collection.mutable.primitive.MutablePrimitiveSeq;
import kala.collection.primitive.ByteSeq;
import kala.collection.primitive.internal.ByteSeqIterators;
import kala.function.ByteUnaryOperator;
import kala.function.IndexedByteUnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface MutableByteSeq
extends MutablePrimitiveSeq<Byte>,
ByteSeq,
MutableByteCollection {
    @NotNull
    public static ByteCollectionFactory<?, MutableByteSeq> factory() {
        return ByteCollectionFactory.narrow(MutableByteArray.factory());
    }

    @NotNull
    public static MutableByteSeq of() {
        return MutableByteArray.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableByteSeq of(byte value1) {
        return MutableByteArray.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableByteSeq of(byte value1, byte value2) {
        return MutableByteArray.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableByteSeq of(byte value1, byte value2, byte value3) {
        return MutableByteArray.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableByteSeq of(byte value1, byte value2, byte value3, byte value4) {
        return MutableByteArray.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableByteSeq of(byte value1, byte value2, byte value3, byte value4, byte value5) {
        return MutableByteArray.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static MutableByteSeq of(byte ... values) {
        return MutableByteArray.of(values);
    }

    @NotNull
    public static MutableByteSeq from(byte @NotNull [] values) {
        return MutableByteArray.from(values);
    }

    @NotNull
    public static MutableByteSeq from(@NotNull ByteTraversable values) {
        return MutableByteArray.from(values);
    }

    @NotNull
    public static MutableByteSeq from(@NotNull ByteIterator it) {
        return MutableByteArray.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableByteSeq";
    }

    @NotNull
    default public ByteCollectionFactory<?, ? extends MutableByteSeq> iterableFactory() {
        return MutableByteSeq.factory();
    }

    @Override
    @NotNull
    default public MutableByteSeqIterator seqIterator() {
        return this.seqIterator(0);
    }

    @Override
    @NotNull
    default public MutableByteSeqIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new ByteSeqIterators.DefaultMutableByteSeqIterator<MutableByteSeq>(this, index);
    }

    @Contract(mutates="this")
    public void set(int var1, byte var2);

    default public void swap(int index1, int index2) {
        byte old1 = this.get(index1);
        byte old2 = this.get(index2);
        this.set(index1, old2);
        this.set(index2, old1);
    }

    @Contract(mutates="this")
    default public void replaceAll(@NotNull ByteUnaryOperator operator) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.set(i, operator.applyAsByte(this.get(i)));
        }
    }

    @Contract(mutates="this")
    default public void replaceAllIndexed(@NotNull IndexedByteUnaryOperator operator) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.set(i, operator.applyAsByte(i, this.get(i)));
        }
    }

    @Contract(mutates="this")
    default public void sort() {
        byte[] values = this.toArray();
        Arrays.sort(values);
        for (int i = 0; i < values.length; ++i) {
            this.set(i, values[i]);
        }
    }

    @Contract(mutates="this")
    default public void reverse() {
        int size = this.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size / 2; ++i) {
            this.swap(i, size - i - 1);
        }
    }

    default public void shuffle() {
        this.shuffle(ThreadLocalRandom.current());
    }

    default public void shuffle(@NotNull Random random) {
        int ks = this.knownSize();
        if (ks == 0 || ks == 1) {
            return;
        }
        if (this.supportsFastRandomAccess() || ks > 0 && ks <= 5) {
            if (!1.$assertionsDisabled && ks <= 0) {
                throw new AssertionError();
            }
            for (int i2 = ks; i2 > 1; --i2) {
                this.swap(i2 - 1, random.nextInt(i2));
            }
        } else {
            byte[] arr = this.toArray();
            ByteArrays.shuffle((byte[])arr, (Random)random);
            this.replaceAllIndexed((i, v) -> arr[i]);
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

