/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import kala.Conditions;
import kala.collection.base.primitive.CharArrays;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.collection.factory.primitive.CharCollectionFactory;
import kala.collection.mutable.primitive.MutableCharArray;
import kala.collection.mutable.primitive.MutableCharCollection;
import kala.collection.mutable.primitive.MutableCharSeqIterator;
import kala.collection.mutable.primitive.MutablePrimitiveSeq;
import kala.collection.primitive.CharSeq;
import kala.collection.primitive.internal.CharSeqIterators;
import kala.function.CharUnaryOperator;
import kala.function.IndexedCharUnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface MutableCharSeq
extends MutablePrimitiveSeq<Character>,
CharSeq,
MutableCharCollection {
    @NotNull
    public static CharCollectionFactory<?, MutableCharSeq> factory() {
        return CharCollectionFactory.narrow(MutableCharArray.factory());
    }

    @NotNull
    public static MutableCharSeq of() {
        return MutableCharArray.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableCharSeq of(char value1) {
        return MutableCharArray.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableCharSeq of(char value1, char value2) {
        return MutableCharArray.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableCharSeq of(char value1, char value2, char value3) {
        return MutableCharArray.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableCharSeq of(char value1, char value2, char value3, char value4) {
        return MutableCharArray.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableCharSeq of(char value1, char value2, char value3, char value4, char value5) {
        return MutableCharArray.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static MutableCharSeq of(char ... values) {
        return MutableCharArray.of(values);
    }

    @NotNull
    public static MutableCharSeq from(char @NotNull [] values) {
        return MutableCharArray.from(values);
    }

    @NotNull
    public static MutableCharSeq from(@NotNull CharTraversable values) {
        return MutableCharArray.from(values);
    }

    @NotNull
    public static MutableCharSeq from(@NotNull CharIterator it) {
        return MutableCharArray.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableCharSeq";
    }

    @NotNull
    default public CharCollectionFactory<?, ? extends MutableCharSeq> iterableFactory() {
        return MutableCharSeq.factory();
    }

    @Override
    @NotNull
    default public MutableCharSeqIterator seqIterator() {
        return this.seqIterator(0);
    }

    @Override
    @NotNull
    default public MutableCharSeqIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new CharSeqIterators.DefaultMutableCharSeqIterator<MutableCharSeq>(this, index);
    }

    @Contract(mutates="this")
    public void set(int var1, char var2);

    default public void swap(int index1, int index2) {
        char old1 = this.get(index1);
        char old2 = this.get(index2);
        this.set(index1, old2);
        this.set(index2, old1);
    }

    @Contract(mutates="this")
    default public void replaceAll(@NotNull CharUnaryOperator operator) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.set(i, operator.applyAsChar(this.get(i)));
        }
    }

    @Contract(mutates="this")
    default public void replaceAllIndexed(@NotNull IndexedCharUnaryOperator operator) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.set(i, operator.applyAsChar(i, this.get(i)));
        }
    }

    @Contract(mutates="this")
    default public void sort() {
        char[] values = this.toArray();
        Arrays.sort(values);
        for (int i = 0; i < values.length; ++i) {
            this.set(i, values[i]);
        }
    }

    @Contract(mutates="this")
    default public void reverse() {
        int size = this.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size / 2; ++i) {
            this.swap(i, size - i - 1);
        }
    }

    default public void shuffle() {
        this.shuffle(ThreadLocalRandom.current());
    }

    default public void shuffle(@NotNull Random random) {
        int ks = this.knownSize();
        if (ks == 0 || ks == 1) {
            return;
        }
        if (this.supportsFastRandomAccess() || ks > 0 && ks <= 5) {
            if (!1.$assertionsDisabled && ks <= 0) {
                throw new AssertionError();
            }
            for (int i2 = ks; i2 > 1; --i2) {
                this.swap(i2 - 1, random.nextInt(i2));
            }
        } else {
            char[] arr = this.toArray();
            CharArrays.shuffle((char[])arr, (Random)random);
            this.replaceAllIndexed((i, v) -> arr[i]);
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

