/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.Objects;
import kala.collection.base.primitive.CharGrowable;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.collection.factory.primitive.CharCollectionFactory;
import kala.collection.mutable.primitive.MutableCharCollection;
import kala.collection.mutable.primitive.MutableCharTreeSet;
import kala.collection.mutable.primitive.MutablePrimitiveSet;
import kala.collection.primitive.CharArraySeq;
import kala.collection.primitive.CharSet;
import kala.function.CharPredicate;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface MutableCharSet
extends MutablePrimitiveSet<Character>,
CharSet,
MutableCharCollection,
CharGrowable {
    @Contract(pure=true)
    @NotNull
    public static CharCollectionFactory<?, MutableCharSet> factory() {
        return CharCollectionFactory.narrow(MutableCharTreeSet.factory());
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableCharSet create() {
        return MutableCharTreeSet.create();
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableCharSet of() {
        return MutableCharTreeSet.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableCharSet of(char value1) {
        return MutableCharTreeSet.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableCharSet of(char value1, char value2) {
        return MutableCharTreeSet.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableCharSet of(char value1, char value2, char value3) {
        return MutableCharTreeSet.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableCharSet of(char value1, char value2, char value3, char value4) {
        return MutableCharTreeSet.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableCharSet of(char value1, char value2, char value3, char value4, char value5) {
        return MutableCharTreeSet.of(value1, value2, value3, value4, value5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableCharSet of(char ... values) {
        return MutableCharTreeSet.of(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableCharSet from(char @NotNull [] values) {
        return MutableCharTreeSet.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableCharSet from(@NotNull CharTraversable values) {
        return MutableCharTreeSet.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableCharSet from(@NotNull CharIterator it) {
        return MutableCharTreeSet.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableCharSet";
    }

    @NotNull
    default public CharCollectionFactory<?, ? extends MutableCharSet> iterableFactory() {
        return MutableCharSet.factory();
    }

    @Contract(mutates="this")
    public boolean add(@Flow(targetIsContainer=true) char var1);

    @Contract(mutates="this")
    default public boolean addAll(@Flow(sourceIsContainer=true, targetIsContainer=true) char @NotNull [] values) {
        Objects.requireNonNull(values);
        return this.addAll(CharArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean addAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) CharTraversable values) {
        if (values == this) {
            return false;
        }
        boolean m = false;
        CharIterator it = values.iterator();
        while (it.hasNext()) {
            if (!this.add(it.nextChar())) continue;
            m = true;
        }
        return m;
    }

    default public void plusAssign(char value) {
        this.add(value);
    }

    default public void plusAssign(char @NotNull [] values) {
        this.addAll(values);
    }

    default public void plusAssign(@NotNull CharTraversable values) {
        this.addAll(values);
    }

    @Contract(mutates="this")
    public void clear();

    default public void trimToSize() {
    }

    @Contract(mutates="this")
    public boolean remove(char var1);

    @Contract(mutates="this")
    default public boolean removeAll(char @NotNull [] values) {
        Objects.requireNonNull(values);
        return this.removeAll(CharArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean removeAll(@NotNull CharTraversable values) {
        Objects.requireNonNull(values);
        boolean m = false;
        CharIterator it = values.iterator();
        while (it.hasNext()) {
            if (!this.remove(it.nextChar())) continue;
            m = true;
        }
        return m;
    }

    @Contract(mutates="this")
    default public boolean removeAll(@NotNull CharPredicate predicate) {
        Objects.requireNonNull(predicate);
        char[] arr = this.toArray();
        int oldSize = arr.length;
        for (char e : arr) {
            if (!predicate.test(e)) continue;
            this.remove(e);
        }
        return this.size() != oldSize;
    }

    @Contract(mutates="this")
    default public boolean retainAll(char @NotNull [] values) {
        return this.retainAll(CharArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean retainAll(@NotNull CharTraversable values) {
        Objects.requireNonNull(values);
        if (this.isEmpty() || values.isEmpty()) {
            return false;
        }
        char[] arr = this.toArray();
        int oldSize = arr.length;
        CharIterator it = this.iterator();
        while (it.hasNext()) {
            char v = it.nextChar();
            if (values.contains(v)) continue;
            this.remove(v);
        }
        return this.size() != oldSize;
    }

    @Contract(mutates="this")
    default public boolean retainAll(@NotNull CharPredicate predicate) {
        Objects.requireNonNull(predicate);
        char[] arr = this.toArray();
        int oldSize = arr.length;
        for (char e : arr) {
            if (predicate.test(e)) continue;
            this.remove(e);
        }
        return this.size() != oldSize;
    }

    @Contract(mutates="this")
    default public void filterInPlace(@NotNull CharPredicate predicate) {
        this.retainAll(predicate);
    }

    @Contract(mutates="this")
    default public void filterNotInPlace(@NotNull CharPredicate predicate) {
        this.removeAll(predicate);
    }
}

