/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.Objects;
import java.util.function.DoublePredicate;
import kala.collection.base.primitive.DoubleGrowable;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.base.primitive.DoubleTraversable;
import kala.collection.factory.primitive.DoubleCollectionFactory;
import kala.collection.mutable.primitive.MutableDoubleCollection;
import kala.collection.mutable.primitive.MutableDoubleTreeSet;
import kala.collection.mutable.primitive.MutablePrimitiveSet;
import kala.collection.primitive.DoubleArraySeq;
import kala.collection.primitive.DoubleSet;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface MutableDoubleSet
extends MutablePrimitiveSet<Double>,
DoubleSet,
MutableDoubleCollection,
DoubleGrowable {
    @Contract(pure=true)
    @NotNull
    public static DoubleCollectionFactory<?, MutableDoubleSet> factory() {
        return DoubleCollectionFactory.narrow(MutableDoubleTreeSet.factory());
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableDoubleSet create() {
        return MutableDoubleTreeSet.create();
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableDoubleSet of() {
        return MutableDoubleTreeSet.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableDoubleSet of(double value1) {
        return MutableDoubleTreeSet.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableDoubleSet of(double value1, double value2) {
        return MutableDoubleTreeSet.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableDoubleSet of(double value1, double value2, double value3) {
        return MutableDoubleTreeSet.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableDoubleSet of(double value1, double value2, double value3, double value4) {
        return MutableDoubleTreeSet.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableDoubleSet of(double value1, double value2, double value3, double value4, double value5) {
        return MutableDoubleTreeSet.of(value1, value2, value3, value4, value5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableDoubleSet of(double ... values) {
        return MutableDoubleTreeSet.of(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableDoubleSet from(double @NotNull [] values) {
        return MutableDoubleTreeSet.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableDoubleSet from(@NotNull DoubleTraversable values) {
        return MutableDoubleTreeSet.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableDoubleSet from(@NotNull DoubleIterator it) {
        return MutableDoubleTreeSet.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableDoubleSet";
    }

    @NotNull
    default public DoubleCollectionFactory<?, ? extends MutableDoubleSet> iterableFactory() {
        return MutableDoubleSet.factory();
    }

    @Contract(mutates="this")
    public boolean add(@Flow(targetIsContainer=true) double var1);

    @Contract(mutates="this")
    default public boolean addAll(@Flow(sourceIsContainer=true, targetIsContainer=true) double @NotNull [] values) {
        Objects.requireNonNull(values);
        return this.addAll(DoubleArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean addAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) DoubleTraversable values) {
        if (values == this) {
            return false;
        }
        boolean m = false;
        DoubleIterator it = values.iterator();
        while (it.hasNext()) {
            if (!this.add(it.nextDouble())) continue;
            m = true;
        }
        return m;
    }

    default public void plusAssign(double value) {
        this.add(value);
    }

    default public void plusAssign(double @NotNull [] values) {
        this.addAll(values);
    }

    default public void plusAssign(@NotNull DoubleTraversable values) {
        this.addAll(values);
    }

    @Contract(mutates="this")
    public void clear();

    default public void trimToSize() {
    }

    @Contract(mutates="this")
    public boolean remove(double var1);

    @Contract(mutates="this")
    default public boolean removeAll(double @NotNull [] values) {
        Objects.requireNonNull(values);
        return this.removeAll(DoubleArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean removeAll(@NotNull DoubleTraversable values) {
        Objects.requireNonNull(values);
        boolean m = false;
        DoubleIterator it = values.iterator();
        while (it.hasNext()) {
            if (!this.remove(it.nextDouble())) continue;
            m = true;
        }
        return m;
    }

    @Contract(mutates="this")
    default public boolean removeAll(@NotNull DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        double[] arr = this.toArray();
        int oldSize = arr.length;
        for (double e : arr) {
            if (!predicate.test(e)) continue;
            this.remove(e);
        }
        return this.size() != oldSize;
    }

    @Contract(mutates="this")
    default public boolean retainAll(double @NotNull [] values) {
        return this.retainAll(DoubleArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean retainAll(@NotNull DoubleTraversable values) {
        Objects.requireNonNull(values);
        if (this.isEmpty() || values.isEmpty()) {
            return false;
        }
        double[] arr = this.toArray();
        int oldSize = arr.length;
        DoubleIterator it = this.iterator();
        while (it.hasNext()) {
            double v = it.nextDouble();
            if (values.contains(v)) continue;
            this.remove(v);
        }
        return this.size() != oldSize;
    }

    @Contract(mutates="this")
    default public boolean retainAll(@NotNull DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        double[] arr = this.toArray();
        int oldSize = arr.length;
        for (double e : arr) {
            if (predicate.test(e)) continue;
            this.remove(e);
        }
        return this.size() != oldSize;
    }

    @Contract(mutates="this")
    default public void filterInPlace(@NotNull DoublePredicate predicate) {
        this.retainAll(predicate);
    }

    @Contract(mutates="this")
    default public void filterNotInPlace(@NotNull DoublePredicate predicate) {
        this.removeAll(predicate);
    }
}

