/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.IntConsumer;
import kala.collection.AnySet;
import kala.collection.base.primitive.AbstractIntIterator;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.factory.primitive.IntCollectionFactory;
import kala.collection.mutable.primitive.AbstractMutableIntSetFactory;
import kala.collection.mutable.primitive.MutableIntSet;
import kala.collection.primitive.IntSet;
import kala.collection.primitive.internal.tree.IntRedBlackTree;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableIntTreeSet
extends IntRedBlackTree<Node>
implements MutableIntSet,
Cloneable,
Serializable {
    private static final long serialVersionUID = 6211626172352429615L;
    private static final Factory FACTORY = new Factory();

    @NotNull
    public static IntCollectionFactory<?, MutableIntTreeSet> factory() {
        return FACTORY;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static MutableIntTreeSet create() {
        return new MutableIntTreeSet();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static MutableIntTreeSet of() {
        return new MutableIntTreeSet();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableIntTreeSet of(int value1) {
        MutableIntTreeSet s = new MutableIntTreeSet();
        s.add(value1);
        return s;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static MutableIntTreeSet of(int value1, int value2) {
        MutableIntTreeSet s = new MutableIntTreeSet();
        s.add(value1);
        s.add(value2);
        return s;
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static MutableIntTreeSet of(int value1, int value2, int value3) {
        MutableIntTreeSet s = new MutableIntTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        return s;
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static MutableIntTreeSet of(int value1, int value2, int value3, int value4) {
        MutableIntTreeSet s = new MutableIntTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        return s;
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static MutableIntTreeSet of(int value1, int value2, int value3, int value4, int value5) {
        MutableIntTreeSet s = new MutableIntTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        s.add(value5);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableIntTreeSet of(int ... values) {
        return MutableIntTreeSet.from(values);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableIntTreeSet from(int @NotNull [] values) {
        Objects.requireNonNull(values);
        MutableIntTreeSet s = new MutableIntTreeSet();
        s.addAll(values);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableIntTreeSet from(@NotNull IntTraversable values) {
        Objects.requireNonNull(values);
        MutableIntTreeSet s = new MutableIntTreeSet();
        s.addAll(values);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableIntTreeSet from(@NotNull IntIterator it) {
        MutableIntTreeSet s = new MutableIntTreeSet();
        while (it.hasNext()) {
            s.add(it.nextInt());
        }
        return s;
    }

    @Override
    @NotNull
    public String className() {
        return "MutableIntTreeSet";
    }

    @NotNull
    public IntCollectionFactory<?, MutableIntTreeSet> iterableFactory() {
        return FACTORY;
    }

    @NotNull
    public IntIterator iterator() {
        Node firstNode = (Node)this.firstNode();
        return firstNode == null ? IntIterator.empty() : new Itr(firstNode);
    }

    @NotNull
    public MutableIntTreeSet clone() {
        return MutableIntTreeSet.from(this);
    }

    @Override
    public boolean add(int value) {
        int c;
        Node parent;
        Node node = (Node)this.root;
        if (node == null) {
            this.root = new Node(value, null);
            this.size = 1;
            return true;
        }
        do {
            parent = node;
            c = Integer.compare(value, node.getValue());
            if (c < 0) {
                node = (Node)node.left;
                continue;
            }
            if (c > 0) {
                node = (Node)node.right;
                continue;
            }
            return false;
        } while (node != null);
        Node n = new Node(value, parent);
        if (c < 0) {
            parent.left = n;
        } else {
            parent.right = n;
        }
        ++this.size;
        this.fixAfterInsert(n);
        return true;
    }

    @Override
    public boolean remove(int value) {
        Node node = (Node)this.getNode(value);
        if (node == null) {
            return false;
        }
        this.remove0(node);
        return true;
    }

    @Override
    public boolean contains(int value) {
        return this.getNode(value) != null;
    }

    public int first() {
        Node node = (Node)this.firstNode();
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.getValue();
    }

    public int last() {
        Node node = (Node)this.lastNode();
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.getValue();
    }

    public int @NotNull [] toArray() {
        int size = this.size;
        int[] res = new int[size];
        if (size == 0) {
            return res;
        }
        IntIterator it = this.iterator();
        for (int i = 0; i < size; ++i) {
            res[i] = it.nextInt();
        }
        return res;
    }

    public int hashCode() {
        return IntSet.hashCode(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof AnySet && IntSet.equals(this, (AnySet)obj);
    }

    public void forEach(@NotNull IntConsumer action) {
        this.forEachKey0(action);
    }

    public String toString() {
        return this.joinToString(", ", "MutableTreeSet[", "]");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            this.add(in.readInt());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.size);
        this.forEachUnchecked(out::writeInt);
    }

    private static final class Factory
    extends AbstractMutableIntSetFactory<MutableIntTreeSet> {
        private Factory() {
        }

        public MutableIntTreeSet newBuilder() {
            return new MutableIntTreeSet();
        }
    }

    static final class Node
    extends IntRedBlackTree.Node<Node> {
        Node(int value, Node parent) {
            super(value, parent);
        }

        void setValue(int newValue) {
            this.key = newValue;
        }

        int getValue() {
            return this.key;
        }

        public String toString() {
            return String.format("MutableIntTreeSet.Node[value=%s, color=%s, parent=%s, left=%s, right=%s]", this.key, this.color ? "RED" : "BLACK", this.parent, this.left, this.right);
        }
    }

    private static final class Itr
    extends AbstractIntIterator {
        private Node node;

        Itr(Node node) {
            this.node = node;
        }

        public boolean hasNext() {
            return this.node != null;
        }

        public int nextInt() {
            Node n;
            Node node = this.node;
            if (node == null) {
                throw new NoSuchElementException();
            }
            if (node.right != null) {
                n = (Node)node.right;
                while (n.left != null) {
                    n = (Node)n.left;
                }
            } else {
                n = (Node)node.parent;
                Node c = node;
                while (n != null && c == n.right) {
                    c = n;
                    n = (Node)n.parent;
                }
            }
            this.node = n;
            return node.getValue();
        }
    }
}

