/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.LongSupplier;
import java.util.function.LongUnaryOperator;
import kala.collection.base.primitive.LongArrays;
import kala.collection.base.primitive.LongIterator;
import kala.collection.base.primitive.LongTraversable;
import kala.collection.factory.primitive.LongCollectionFactory;
import kala.collection.mutable.primitive.MutableLongArrayList;
import kala.collection.mutable.primitive.MutableLongSeq;
import kala.collection.primitive.LongArraySeq;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableLongArray
extends LongArraySeq
implements MutableLongSeq,
Serializable {
    private static final long serialVersionUID = 8060307722127719792L;
    public static final MutableLongArray EMPTY = new MutableLongArray(LongArrays.EMPTY);
    private static final Factory FACTORY = new Factory();

    MutableLongArray(long @NotNull [] array) {
        super(array);
    }

    @NotNull
    public static LongCollectionFactory<?, MutableLongArray> factory() {
        return FACTORY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableLongArray create(int size) {
        return new MutableLongArray(new long[size]);
    }

    @NotNull
    public static MutableLongArray empty() {
        return EMPTY;
    }

    @NotNull
    public static MutableLongArray of() {
        return EMPTY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableLongArray of(long value1) {
        return new MutableLongArray(new long[]{value1});
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableLongArray of(long value1, long value2) {
        return new MutableLongArray(new long[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableLongArray of(long value1, long value2, long value3) {
        return new MutableLongArray(new long[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableLongArray of(long value1, long value2, long value3, long value4) {
        return new MutableLongArray(new long[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableLongArray of(long value1, long value2, long value3, long value4, long value5) {
        return new MutableLongArray(new long[]{value1, value2, value3, value4, value5});
    }

    @NotNull
    public static MutableLongArray of(long ... values) {
        return values.length != 0 ? new MutableLongArray(values) : MutableLongArray.empty();
    }

    @NotNull
    public static MutableLongArray from(long @NotNull [] values) {
        return values.length != 0 ? new MutableLongArray((long[])values.clone()) : MutableLongArray.empty();
    }

    @NotNull
    public static MutableLongArray from(@NotNull LongTraversable values) {
        return values.isNotEmpty() ? new MutableLongArray(values.toArray()) : MutableLongArray.empty();
    }

    @NotNull
    public static MutableLongArray from(@NotNull LongIterator it) {
        if (!it.hasNext()) {
            return MutableLongArray.empty();
        }
        return new MutableLongArray(it.toArray());
    }

    @NotNull
    public static MutableLongArray fill(int n, long value) {
        if (n <= 0) {
            return MutableLongArray.empty();
        }
        long[] ans = new long[n];
        if (value != 0L) {
            Arrays.fill(ans, value);
        }
        return new MutableLongArray(ans);
    }

    @NotNull
    public static MutableLongArray fill(int n, @NotNull LongSupplier supplier) {
        if (n <= 0) {
            return MutableLongArray.empty();
        }
        long[] ans = new long[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsLong();
        }
        return new MutableLongArray(ans);
    }

    @NotNull
    public static MutableLongArray wrap(long @NotNull [] array) {
        Objects.requireNonNull(array);
        return new MutableLongArray(array);
    }

    @Override
    @NotNull
    public final String className() {
        return "MutableArray";
    }

    @NotNull
    public LongCollectionFactory<?, MutableLongArray> iterableFactory() {
        return MutableLongArray.factory();
    }

    @NotNull
    public MutableLongArray clone() {
        return new MutableLongArray((long[])this.elements.clone());
    }

    public long @NotNull [] getArray() {
        return this.elements;
    }

    @Override
    public void set(int index, long newValue) {
        try {
            this.elements[index] = newValue;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public void replaceAll(@NotNull LongUnaryOperator operator) {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = operator.applyAsLong(this.elements[i]);
        }
    }

    @Override
    public void sort() {
        LongArrays.sort((long[])this.elements);
    }

    private static final class Factory
    implements LongCollectionFactory<MutableLongArrayList, MutableLongArray> {
        Factory() {
        }

        public MutableLongArray from(long @NotNull [] values) {
            return MutableLongArray.from(values);
        }

        public MutableLongArray from(@NotNull LongTraversable values) {
            return MutableLongArray.from(values);
        }

        @NotNull
        public MutableLongArray from(@NotNull LongIterator it) {
            return MutableLongArray.from(it);
        }

        public MutableLongArray fill(int n, long value) {
            return MutableLongArray.fill(n, value);
        }

        public MutableLongArray fill(int n, @NotNull LongSupplier supplier) {
            return MutableLongArray.fill(n, supplier);
        }

        public MutableLongArrayList newBuilder() {
            return new MutableLongArrayList();
        }

        public void addToBuilder(@NotNull MutableLongArrayList builder, long value) {
            builder.append(value);
        }

        public void sizeHint(@NotNull MutableLongArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public MutableLongArrayList mergeBuilder(@NotNull MutableLongArrayList builder1, @NotNull MutableLongArrayList builder2) {
            builder1.appendAll(builder2);
            return builder1;
        }

        public MutableLongArray build(@NotNull MutableLongArrayList builder) {
            return new MutableLongArray(builder.toArray());
        }
    }
}

