/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.collection.AnySet;
import kala.collection.base.primitive.AbstractShortIterator;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.base.primitive.ShortTraversable;
import kala.collection.factory.primitive.ShortCollectionFactory;
import kala.collection.mutable.primitive.AbstractMutableShortSetFactory;
import kala.collection.mutable.primitive.MutableShortSet;
import kala.collection.primitive.ShortSet;
import kala.collection.primitive.internal.tree.ShortRedBlackTree;
import kala.function.ShortConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableShortTreeSet
extends ShortRedBlackTree<Node>
implements MutableShortSet,
Cloneable,
Serializable {
    private static final long serialVersionUID = 6211626172352429615L;
    private static final Factory FACTORY = new Factory();

    @NotNull
    public static ShortCollectionFactory<?, MutableShortTreeSet> factory() {
        return FACTORY;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static MutableShortTreeSet create() {
        return new MutableShortTreeSet();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static MutableShortTreeSet of() {
        return new MutableShortTreeSet();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableShortTreeSet of(short value1) {
        MutableShortTreeSet s = new MutableShortTreeSet();
        s.add(value1);
        return s;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static MutableShortTreeSet of(short value1, short value2) {
        MutableShortTreeSet s = new MutableShortTreeSet();
        s.add(value1);
        s.add(value2);
        return s;
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static MutableShortTreeSet of(short value1, short value2, short value3) {
        MutableShortTreeSet s = new MutableShortTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        return s;
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static MutableShortTreeSet of(short value1, short value2, short value3, short value4) {
        MutableShortTreeSet s = new MutableShortTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        return s;
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static MutableShortTreeSet of(short value1, short value2, short value3, short value4, short value5) {
        MutableShortTreeSet s = new MutableShortTreeSet();
        s.add(value1);
        s.add(value2);
        s.add(value3);
        s.add(value4);
        s.add(value5);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableShortTreeSet of(short ... values) {
        return MutableShortTreeSet.from(values);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableShortTreeSet from(short @NotNull [] values) {
        Objects.requireNonNull(values);
        MutableShortTreeSet s = new MutableShortTreeSet();
        s.addAll(values);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableShortTreeSet from(@NotNull ShortTraversable values) {
        Objects.requireNonNull(values);
        MutableShortTreeSet s = new MutableShortTreeSet();
        s.addAll(values);
        return s;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MutableShortTreeSet from(@NotNull ShortIterator it) {
        MutableShortTreeSet s = new MutableShortTreeSet();
        while (it.hasNext()) {
            s.add(it.nextShort());
        }
        return s;
    }

    @Override
    @NotNull
    public String className() {
        return "MutableShortTreeSet";
    }

    @NotNull
    public ShortCollectionFactory<?, MutableShortTreeSet> iterableFactory() {
        return FACTORY;
    }

    @NotNull
    public ShortIterator iterator() {
        Node firstNode = (Node)this.firstNode();
        return firstNode == null ? ShortIterator.empty() : new Itr(firstNode);
    }

    @NotNull
    public MutableShortTreeSet clone() {
        return MutableShortTreeSet.from(this);
    }

    @Override
    public boolean add(short value) {
        int c;
        Node parent;
        Node node = (Node)this.root;
        if (node == null) {
            this.root = new Node(value, null);
            this.size = 1;
            return true;
        }
        do {
            parent = node;
            c = Short.compare(value, node.getValue());
            if (c < 0) {
                node = (Node)node.left;
                continue;
            }
            if (c > 0) {
                node = (Node)node.right;
                continue;
            }
            return false;
        } while (node != null);
        Node n = new Node(value, parent);
        if (c < 0) {
            parent.left = n;
        } else {
            parent.right = n;
        }
        ++this.size;
        this.fixAfterInsert(n);
        return true;
    }

    @Override
    public boolean remove(short value) {
        Node node = (Node)this.getNode(value);
        if (node == null) {
            return false;
        }
        this.remove0(node);
        return true;
    }

    @Override
    public boolean contains(short value) {
        return this.getNode(value) != null;
    }

    public short first() {
        Node node = (Node)this.firstNode();
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.getValue();
    }

    public short last() {
        Node node = (Node)this.lastNode();
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.getValue();
    }

    public short @NotNull [] toArray() {
        int size = this.size;
        short[] res = new short[size];
        if (size == 0) {
            return res;
        }
        ShortIterator it = this.iterator();
        for (int i = 0; i < size; ++i) {
            res[i] = it.nextShort();
        }
        return res;
    }

    public int hashCode() {
        return ShortSet.hashCode(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof AnySet && ShortSet.equals(this, (AnySet)obj);
    }

    public void forEach(@NotNull ShortConsumer action) {
        this.forEachKey0(action);
    }

    public String toString() {
        return this.joinToString(", ", "MutableTreeSet[", "]");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            this.add(in.readShort());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.size);
        this.forEachUnchecked(out::writeShort);
    }

    private static final class Factory
    extends AbstractMutableShortSetFactory<MutableShortTreeSet> {
        private Factory() {
        }

        public MutableShortTreeSet newBuilder() {
            return new MutableShortTreeSet();
        }
    }

    static final class Node
    extends ShortRedBlackTree.Node<Node> {
        Node(short value, Node parent) {
            super(value, parent);
        }

        void setValue(short newValue) {
            this.key = newValue;
        }

        short getValue() {
            return this.key;
        }

        public String toString() {
            return String.format("MutableShortTreeSet.Node[value=%s, color=%s, parent=%s, left=%s, right=%s]", this.key, this.color ? "RED" : "BLACK", this.parent, this.left, this.right);
        }
    }

    private static final class Itr
    extends AbstractShortIterator {
        private Node node;

        Itr(Node node) {
            this.node = node;
        }

        public boolean hasNext() {
            return this.node != null;
        }

        public short nextShort() {
            Node n;
            Node node = this.node;
            if (node == null) {
                throw new NoSuchElementException();
            }
            if (node.right != null) {
                n = (Node)node.right;
                while (n.left != null) {
                    n = (Node)n.left;
                }
            } else {
                n = (Node)node.parent;
                Node c = node;
                while (n != null && c == n.right) {
                    c = n;
                    n = (Node)n.parent;
                }
            }
            this.node = n;
            return node.getValue();
        }
    }
}

