/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.Objects;
import kala.Conditions;
import kala.collection.SeqView;
import kala.collection.base.primitive.BooleanTraversable;
import kala.collection.immutable.primitive.ImmutableBooleanSeq;
import kala.collection.primitive.BooleanArraySeq;
import kala.collection.primitive.BooleanCollectionView;
import kala.collection.primitive.BooleanSeqLike;
import kala.collection.primitive.PrimitiveSeqView;
import kala.collection.primitive.internal.view.BooleanSeqViews;
import kala.function.BooleanFunction;
import kala.function.BooleanPredicate;
import kala.function.BooleanUnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface BooleanSeqView
extends BooleanSeqLike,
BooleanCollectionView,
PrimitiveSeqView<Boolean> {
    @NotNull
    public static BooleanSeqView empty() {
        return BooleanSeqViews.EMPTY;
    }

    @Override
    @NotNull
    default public String className() {
        return "BooleanSeqView";
    }

    @Override
    @NotNull
    default public BooleanSeqView view() {
        return this;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public BooleanSeqView slice(int beginIndex, int endIndex) {
        int ks = this.knownSize();
        if (ks == 0) {
            if (beginIndex != 0) {
                throw new IndexOutOfBoundsException("beginIndex: " + beginIndex);
            }
            if (endIndex != 0) {
                throw new IndexOutOfBoundsException("endIndex: " + endIndex);
            }
            return BooleanSeqView.empty();
        }
        if (ks > 0) {
            Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)ks);
        } else {
            if (beginIndex < 0) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") < 0");
            }
            if (beginIndex > endIndex) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") > endIndex(" + endIndex + ")");
            }
        }
        return new BooleanSeqViews.Slice(this, beginIndex, endIndex);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public BooleanSeqView drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return BooleanSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return BooleanSeqView.empty();
        }
        return new BooleanSeqViews.Drop(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public BooleanSeqView dropLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return BooleanSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return BooleanSeqView.empty();
        }
        return new BooleanSeqViews.DropLast(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public BooleanSeqView dropWhile(@NotNull BooleanPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new BooleanSeqViews.DropWhile(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public BooleanSeqView take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return BooleanSeqView.empty();
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return BooleanSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return this;
        }
        return new BooleanSeqViews.Take(this, n);
    }

    @Override
    @NotNull
    default public BooleanSeqView takeLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return BooleanSeqView.empty();
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return BooleanSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return this;
        }
        return new BooleanSeqViews.TakeLast(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public BooleanSeqView takeWhile(@NotNull BooleanPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new BooleanSeqViews.TakeWhile(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public BooleanSeqView updated(int index, boolean newValue) {
        int ks = this.knownSize();
        if (ks < 0) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
        } else {
            Conditions.checkElementIndex((int)index, (int)ks);
        }
        return new BooleanSeqViews.Updated(this, index, newValue);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public BooleanSeqView concat(@NotNull BooleanSeqLike other) {
        Objects.requireNonNull(other);
        return new BooleanSeqViews.Concat(this, other.view());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public BooleanSeqView prepended(boolean value) {
        return new BooleanSeqViews.Prepended(this, value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public BooleanSeqView prependedAll(boolean @NotNull [] values) {
        Objects.requireNonNull(values);
        return new BooleanSeqViews.Concat(BooleanArraySeq.wrap(values), this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public BooleanSeqView prependedAll(@NotNull BooleanTraversable values) {
        Objects.requireNonNull(values);
        return new BooleanSeqViews.Concat(values instanceof BooleanSeqLike ? (BooleanSeqLike)values : ImmutableBooleanSeq.from(values), this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public BooleanSeqView appended(boolean value) {
        return new BooleanSeqViews.Appended(this, value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public BooleanSeqView appendedAll(boolean @NotNull [] values) {
        Objects.requireNonNull(values);
        return new BooleanSeqViews.Concat(this, BooleanArraySeq.wrap(values));
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public BooleanSeqView appendedAll(@NotNull BooleanTraversable values) {
        Objects.requireNonNull(values);
        return new BooleanSeqViews.Concat(this, values instanceof BooleanSeqLike ? (BooleanSeqLike)values : ImmutableBooleanSeq.from(values));
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public BooleanSeqView sorted() {
        return new BooleanSeqViews.Sorted(this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public BooleanSeqView reversed() {
        return new BooleanSeqViews.Reversed(this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public BooleanSeqView filter(@NotNull BooleanPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new BooleanSeqViews.Filter(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public BooleanSeqView filterNot(@NotNull BooleanPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new BooleanSeqViews.FilterNot(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public BooleanSeqView map(@NotNull BooleanUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return new BooleanSeqViews.Mapped(this, mapper);
    }

    @Contract(pure=true)
    @NotNull
    default public <U> SeqView<U> mapToObj(@NotNull BooleanFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return new BooleanSeqViews.MapToObj<U>(this, mapper);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public BooleanSeqView flatMap(@NotNull BooleanFunction<? extends BooleanTraversable> mapper) {
        Objects.requireNonNull(mapper);
        return new BooleanSeqViews.FlatMapped(this, mapper);
    }
}

