/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.NoSuchElementException;
import java.util.RandomAccess;
import kala.Conditions;
import kala.collection.base.primitive.AbstractCharIterator;
import kala.collection.base.primitive.CharIterator;
import kala.collection.primitive.CharSeqLike;
import kala.control.primitive.CharOption;
import kala.function.CharConsumer;
import kala.function.CharPredicate;
import org.jetbrains.annotations.NotNull;

public interface IndexedCharSeqLike
extends CharSeqLike,
RandomAccess {
    @NotNull
    default public CharIterator iterator() {
        return this.iterator(0);
    }

    @Override
    @NotNull
    default public CharIterator iterator(int beginIndex) {
        final int size = this.size();
        if (size == 0) {
            return CharIterator.empty();
        }
        final class Itr
        extends AbstractCharIterator {
            private int idx;

            Itr(int beginIndex) {
                this.idx = beginIndex;
            }

            public boolean hasNext() {
                return this.idx < size;
            }

            public char nextChar() {
                if (this.idx >= size) {
                    throw new NoSuchElementException();
                }
                return IndexedCharSeqLike.this.get(this.idx++);
            }
        }
        return new Itr(beginIndex);
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public int knownSize() {
        return this.size();
    }

    default public boolean supportsFastRandomAccess() {
        return true;
    }

    @Override
    default public boolean isDefinedAt(int index) {
        return index >= 0 && index < this.size();
    }

    @Override
    public char get(int var1);

    @Override
    @NotNull
    default public CharIterator reverseIterator() {
        if (this.isEmpty()) {
            return CharIterator.empty();
        }
        return new AbstractCharIterator(){
            private int idx;
            {
                this.idx = IndexedCharSeqLike.this.size() - 1;
            }

            public boolean hasNext() {
                return this.idx >= 0;
            }

            public char nextChar() {
                if (this.idx < 0) {
                    throw new NoSuchElementException();
                }
                return IndexedCharSeqLike.this.get(this.idx--);
            }
        };
    }

    default public int binarySearch(char value) {
        return this.binarySearch(0, this.size(), value);
    }

    default public int binarySearch(int beginIndex, int endIndex, char value) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size());
        int low = beginIndex;
        int high = endIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            char midVal = this.get(mid);
            int cmp = Character.compare(midVal, value);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    @NotNull
    default public CharOption findFirst(@NotNull CharPredicate predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            char e = this.get(i);
            if (!predicate.test(e)) continue;
            return CharOption.some((char)e);
        }
        return CharOption.none();
    }

    @Override
    @NotNull
    default public CharOption findLast(@NotNull CharPredicate predicate) {
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            char e = this.get(i);
            if (!predicate.test(e)) continue;
            return CharOption.some((char)e);
        }
        return CharOption.none();
    }

    @Override
    default public char first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(0);
    }

    @Override
    default public char last() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.get(size - 1);
    }

    default public void forEach(@NotNull CharConsumer action) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            action.accept(this.get(i));
        }
    }
}

