/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.NoSuchElementException;
import java.util.RandomAccess;
import kala.Conditions;
import kala.collection.base.primitive.AbstractFloatIterator;
import kala.collection.base.primitive.FloatIterator;
import kala.collection.primitive.FloatSeqLike;
import kala.control.primitive.FloatOption;
import kala.function.FloatConsumer;
import kala.function.FloatPredicate;
import org.jetbrains.annotations.NotNull;

public interface IndexedFloatSeqLike
extends FloatSeqLike,
RandomAccess {
    @NotNull
    default public FloatIterator iterator() {
        return this.iterator(0);
    }

    @Override
    @NotNull
    default public FloatIterator iterator(int beginIndex) {
        final int size = this.size();
        if (size == 0) {
            return FloatIterator.empty();
        }
        final class Itr
        extends AbstractFloatIterator {
            private int idx;

            Itr(int beginIndex) {
                this.idx = beginIndex;
            }

            public boolean hasNext() {
                return this.idx < size;
            }

            public float nextFloat() {
                if (this.idx >= size) {
                    throw new NoSuchElementException();
                }
                return IndexedFloatSeqLike.this.get(this.idx++);
            }
        }
        return new Itr(beginIndex);
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public int knownSize() {
        return this.size();
    }

    default public boolean supportsFastRandomAccess() {
        return true;
    }

    @Override
    default public boolean isDefinedAt(int index) {
        return index >= 0 && index < this.size();
    }

    @Override
    public float get(int var1);

    @Override
    @NotNull
    default public FloatIterator reverseIterator() {
        if (this.isEmpty()) {
            return FloatIterator.empty();
        }
        return new AbstractFloatIterator(){
            private int idx;
            {
                this.idx = IndexedFloatSeqLike.this.size() - 1;
            }

            public boolean hasNext() {
                return this.idx >= 0;
            }

            public float nextFloat() {
                if (this.idx < 0) {
                    throw new NoSuchElementException();
                }
                return IndexedFloatSeqLike.this.get(this.idx--);
            }
        };
    }

    default public int binarySearch(float value) {
        return this.binarySearch(0, this.size(), value);
    }

    default public int binarySearch(int beginIndex, int endIndex, float value) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size());
        int low = beginIndex;
        int high = endIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            float midVal = this.get(mid);
            int cmp = Float.compare(midVal, value);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    @NotNull
    default public FloatOption findFirst(@NotNull FloatPredicate predicate) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            float e = this.get(i);
            if (!predicate.test(e)) continue;
            return FloatOption.some((float)e);
        }
        return FloatOption.none();
    }

    @Override
    @NotNull
    default public FloatOption findLast(@NotNull FloatPredicate predicate) {
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            float e = this.get(i);
            if (!predicate.test(e)) continue;
            return FloatOption.some((float)e);
        }
        return FloatOption.none();
    }

    @Override
    default public float first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(0);
    }

    @Override
    default public float last() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.get(size - 1);
    }

    default public void forEach(@NotNull FloatConsumer action) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            action.accept(this.get(i));
        }
    }
}

