/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.factory.primitive.IntCollectionFactory;
import kala.collection.immutable.ImmutableCollection;
import kala.collection.immutable.primitive.ImmutableIntCollection;
import kala.collection.primitive.IntCollectionLike;
import kala.collection.primitive.IntCollectionView;
import kala.collection.primitive.IntSeq;
import kala.collection.primitive.PrimitiveCollection;
import kala.collection.primitive.internal.view.IntCollectionViews;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface IntCollection
extends PrimitiveCollection<Integer>,
IntCollectionLike {
    @NotNull
    public static <E> IntCollectionFactory<?, IntCollection> factory() {
        return IntCollectionFactory.narrow(IntSeq.factory());
    }

    @NotNull
    public static IntCollection empty() {
        return IntSeq.empty();
    }

    @NotNull
    public static IntCollection of() {
        return IntSeq.of();
    }

    @NotNull
    public static IntCollection of(int value1) {
        return IntSeq.of(value1);
    }

    @NotNull
    public static IntCollection of(int value1, int value2) {
        return IntSeq.of(value1, value2);
    }

    @NotNull
    public static IntCollection of(int value1, int value2, int value3) {
        return IntSeq.of(value1, value2, value3);
    }

    @NotNull
    public static IntCollection of(int value1, int value2, int value3, int value4) {
        return IntSeq.of(value1, value2, value3, value4);
    }

    @NotNull
    public static IntCollection of(int value1, int value2, int value3, int value4, int value5) {
        return IntSeq.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static IntCollection of(int ... values) {
        return IntSeq.of(values);
    }

    @NotNull
    public static IntCollection from(int @NotNull [] values) {
        return IntSeq.from(values);
    }

    @NotNull
    public static IntCollection from(@NotNull IntTraversable values) {
        return IntSeq.from(values);
    }

    @NotNull
    public static IntCollection from(@NotNull IntIterator it) {
        return IntSeq.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "IntCollectionLike";
    }

    @Override
    @NotNull
    default public IntCollectionView view() {
        return this.isEmpty() ? IntCollectionView.empty() : new IntCollectionViews.Of<IntCollection>(this);
    }

    @NotNull
    default public IntCollectionFactory<?, ? extends IntCollection> iterableFactory() {
        return IntCollection.factory();
    }

    @Override
    @NotNull
    default public ImmutableIntCollection filter(@NotNull IntPredicate predicate) {
        return this.view().filter(predicate).toImmutableSeq();
    }

    @Override
    @NotNull
    default public ImmutableIntCollection filterNot(@NotNull IntPredicate predicate) {
        return this.view().filterNot(predicate).toImmutableSeq();
    }

    @Override
    @NotNull
    default public ImmutableIntCollection map(@NotNull IntUnaryOperator mapper) {
        return this.view().map(mapper).toImmutableSeq();
    }

    @NotNull
    default public <U> ImmutableCollection<U> mapToObj(@NotNull IntFunction<? extends U> mapper) {
        return this.view().mapToObj(mapper).toImmutableSeq();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public ImmutableIntCollection flatMap(@NotNull IntFunction<? extends IntTraversable> mapper) {
        return this.view().flatMap((IntFunction)mapper).toImmutableSeq();
    }
}

