/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.function.IntPredicate;
import kala.collection.AnySet;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.factory.primitive.IntCollectionFactory;
import kala.collection.immutable.primitive.ImmutableIntSet;
import kala.collection.primitive.IntCollection;
import kala.collection.primitive.IntSetLike;
import kala.collection.primitive.IntSetView;
import kala.collection.primitive.PrimitiveSet;
import kala.collection.primitive.internal.view.IntSetViews;
import org.jetbrains.annotations.NotNull;

public interface IntSet
extends PrimitiveSet<Integer>,
IntCollection,
IntSetLike {
    public static IntCollectionFactory<?, IntSet> factory() {
        return IntCollectionFactory.narrow(ImmutableIntSet.factory());
    }

    @NotNull
    public static IntSet empty() {
        return ImmutableIntSet.empty();
    }

    @NotNull
    public static IntSet of() {
        return ImmutableIntSet.of();
    }

    @NotNull
    public static IntSet of(int value1) {
        return ImmutableIntSet.of(value1);
    }

    @NotNull
    public static IntSet of(int value1, int value2) {
        return ImmutableIntSet.of(value1, value2);
    }

    @NotNull
    public static IntSet of(int value1, int value2, int value3) {
        return ImmutableIntSet.of(value1, value2, value3);
    }

    @NotNull
    public static IntSet of(int value1, int value2, int value3, int value4) {
        return ImmutableIntSet.of(value1, value2, value3, value4);
    }

    @NotNull
    public static IntSet of(int value1, int value2, int value3, int value4, int value5) {
        return ImmutableIntSet.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static IntSet of(int ... values) {
        return ImmutableIntSet.of(values);
    }

    @NotNull
    public static IntSet from(int @NotNull [] values) {
        return ImmutableIntSet.from(values);
    }

    @NotNull
    public static IntSet from(@NotNull IntTraversable values) {
        return ImmutableIntSet.from(values);
    }

    @NotNull
    public static IntSet from(@NotNull IntIterator it) {
        return ImmutableIntSet.from(it);
    }

    public static int hashCode(@NotNull IntSet set) {
        int h = 1045751549;
        IntIterator it = set.iterator();
        while (it.hasNext()) {
            h += Integer.hashCode(it.nextInt());
        }
        return h;
    }

    public static boolean equals(@NotNull IntSet set1, @NotNull AnySet<?> set2) {
        if (set1 == set2) {
            return true;
        }
        if (!set1.canEqual(set2) || !set2.canEqual((Object)set1)) {
            return false;
        }
        if (set1.size() != set2.size()) {
            return false;
        }
        if (set2 instanceof IntSet) {
            return set1.containsAll((IntSet)set2);
        }
        for (Object v : set2.asGeneric()) {
            if (v instanceof Integer && set1.contains((Integer)v)) continue;
            return false;
        }
        return true;
    }

    default public boolean contains(int value) {
        return this.iterator().contains(value);
    }

    @Override
    @NotNull
    default public String className() {
        return "IntSet";
    }

    @NotNull
    default public IntCollectionFactory<?, ? extends IntSet> iterableFactory() {
        return IntSet.factory();
    }

    @Override
    @NotNull
    default public IntSetView view() {
        return new IntSetViews.Of<IntSet>(this);
    }

    @Override
    @NotNull
    default public ImmutableIntSet filter(@NotNull IntPredicate predicate) {
        return ImmutableIntSet.from(this.view().filter(predicate));
    }

    @Override
    @NotNull
    default public ImmutableIntSet filterNot(@NotNull IntPredicate predicate) {
        return ImmutableIntSet.from(this.view().filterNot(predicate));
    }
}

