/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongUnaryOperator;
import kala.Conditions;
import kala.collection.SeqLike;
import kala.collection.base.primitive.LongIterator;
import kala.collection.base.primitive.LongTraversable;
import kala.collection.mutable.primitive.MutableLongArrayList;
import kala.collection.primitive.LongCollectionLike;
import kala.collection.primitive.LongSeqIterator;
import kala.collection.primitive.LongSeqView;
import kala.collection.primitive.PrimitiveSeqLike;
import kala.collection.primitive.internal.LongSeqIterators;
import kala.control.primitive.LongOption;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public interface LongSeqLike
extends PrimitiveSeqLike<Long>,
LongCollectionLike {
    @Override
    @NotNull
    default public String className() {
        return "LongSeqLike";
    }

    @Override
    @NotNull
    public LongSeqView view();

    @NotNull
    default public LongIterator iterator(int beginIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") < 0");
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0) {
            if (beginIndex > knownSize) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") > size(" + knownSize + ")");
            }
            if (beginIndex == knownSize) {
                return LongIterator.empty();
            }
        }
        LongIterator it = this.iterator();
        for (int i = 0; i < beginIndex; ++i) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException("beginIndex: " + beginIndex);
            }
            it.nextLong();
        }
        return it;
    }

    @NotNull
    default public LongSeqIterator seqIterator() {
        return this.seqIterator(0);
    }

    @NotNull
    default public LongSeqIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new LongSeqIterators.DefaultLongSeqIterator<LongSeqLike>(this, index);
    }

    @Contract(pure=true)
    default public boolean isDefinedAt(int index) {
        return index >= 0 && this.sizeGreaterThan(index);
    }

    default public long elementAt(int index) {
        return this.get(index);
    }

    @Contract(pure=true)
    @Flow(sourceIsContainer=true)
    default public long get(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return this.iterator(index).nextLong();
    }

    @Contract(pure=true)
    @Nullable
    default public Long getOrNull(int index) {
        return this.isDefinedAt(index) ? Long.valueOf(this.get(index)) : null;
    }

    @Contract(pure=true)
    @Flow(sourceIsContainer=true, targetIsContainer=true)
    @NotNull
    default public LongOption getOption(int index) {
        return this.isDefinedAt(index) ? LongOption.some((long)this.get(index)) : LongOption.none();
    }

    @NotNull
    default public LongIterator reverseIterator() {
        LongIterator it = this.iterator();
        if (!it.hasNext()) {
            return it;
        }
        MutableLongArrayList builder = new MutableLongArrayList();
        while (it.hasNext()) {
            builder.append(it.nextLong());
        }
        return builder.reverseIterator();
    }

    @NotNull
    default public LongOption find(@NotNull LongPredicate predicate) {
        return this.findFirst(predicate);
    }

    @NotNull
    default public LongOption findFirst(@NotNull LongPredicate predicate) {
        return this.iterator().find(predicate);
    }

    @NotNull
    default public LongOption findLast(@NotNull LongPredicate predicate) {
        return this.reverseIterator().find(predicate);
    }

    default public long first() {
        return this.iterator().nextLong();
    }

    @Nullable
    default public Long firstOrNull() {
        return this.isNotEmpty() ? Long.valueOf(this.first()) : null;
    }

    @NotNull
    default public LongOption firstOption() {
        return this.isNotEmpty() ? LongOption.some((long)this.first()) : LongOption.none();
    }

    default public long last() {
        return this.reverseIterator().nextLong();
    }

    @Nullable
    default public Long lastOrNull() {
        return this.isNotEmpty() ? Long.valueOf(this.last()) : null;
    }

    @NotNull
    default public LongOption lastOption() {
        return this.isNotEmpty() ? LongOption.some((long)this.last()) : LongOption.none();
    }

    default public long first(@NotNull LongPredicate predicate) {
        return this.findFirst(predicate).get();
    }

    @Nullable
    default public Long firstOrNull(@NotNull LongPredicate predicate) {
        return this.findFirst(predicate).getOrNull();
    }

    @NotNull
    default public LongOption firstOption(@NotNull LongPredicate predicate) {
        return this.findFirst(predicate);
    }

    default public long last(@NotNull LongPredicate predicate) {
        return this.findLast(predicate).get();
    }

    @Nullable
    default public Long lastOrNull(@NotNull LongPredicate predicate) {
        return this.findLast(predicate).getOrNull();
    }

    @NotNull
    default public LongOption lastOption(@NotNull LongPredicate predicate) {
        return this.findLast(predicate);
    }

    @Contract(pure=true)
    default public int indexOf(long value) {
        int idx = 0;
        LongIterator it = this.iterator();
        while (it.hasNext()) {
            if (value == it.nextLong()) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexOf(long value, int from) {
        int idx = 0;
        LongIterator it = this.iterator();
        while (it.hasNext()) {
            if (idx >= from && value == it.nextLong()) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexWhere(@NotNull LongPredicate predicate) {
        int idx = 0;
        LongIterator it = this.iterator();
        while (it.hasNext()) {
            if (predicate.test(it.nextLong())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int indexWhere(@NotNull LongPredicate predicate, int from) {
        int idx = 0;
        LongIterator it = this.iterator();
        while (it.hasNext()) {
            if (idx >= from && predicate.test(it.nextLong())) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexOf(long value) {
        int idx = this.size() - 1;
        LongIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (value == it.nextLong()) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexOf(long value, int end) {
        int idx = this.size() - 1;
        LongIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (idx <= end && value == it.nextLong()) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexWhere(@NotNull LongPredicate predicate) {
        int idx = this.size() - 1;
        LongIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (predicate.test(it.nextLong())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    default public int lastIndexWhere(@NotNull LongPredicate predicate, int end) {
        int idx = this.size() - 1;
        LongIterator it = this.reverseIterator();
        while (it.hasNext()) {
            if (idx <= end && predicate.test(it.nextLong())) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    @Contract(pure=true)
    @NotNull
    public LongSeqLike slice(int var1, int var2);

    @Contract(pure=true)
    @NotNull
    public LongSeqLike drop(int var1);

    @Contract(pure=true)
    @NotNull
    public LongSeqLike dropLast(int var1);

    @Contract(pure=true)
    @NotNull
    public LongSeqLike dropWhile(@NotNull LongPredicate var1);

    @Contract(pure=true)
    @NotNull
    public LongSeqLike take(int var1);

    @NotNull
    public LongSeqLike takeLast(int var1);

    @Contract(pure=true)
    @NotNull
    public LongSeqLike takeWhile(@NotNull LongPredicate var1);

    @Contract(pure=true)
    @NotNull
    public LongSeqLike updated(int var1, long var2);

    @Contract(pure=true)
    @NotNull
    public LongSeqLike concat(@NotNull LongSeqLike var1);

    @Contract(pure=true)
    @NotNull
    public LongSeqLike prepended(long var1);

    @Contract(pure=true)
    @NotNull
    public LongSeqLike prependedAll(long @NotNull [] var1);

    @Contract(pure=true)
    @NotNull
    public LongSeqLike prependedAll(@NotNull LongTraversable var1);

    @Contract(pure=true)
    @NotNull
    public LongSeqLike appended(long var1);

    @Contract(pure=true)
    @NotNull
    public LongSeqLike appendedAll(@NotNull LongTraversable var1);

    @Contract(pure=true)
    @NotNull
    public LongSeqLike appendedAll(long @NotNull [] var1);

    @Contract(pure=true)
    @NotNull
    public LongSeqLike sorted();

    @Contract(pure=true)
    @NotNull
    public LongSeqLike reversed();

    @Override
    @Contract(pure=true)
    @NotNull
    public LongSeqLike filter(@NotNull LongPredicate var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public LongSeqLike filterNot(@NotNull LongPredicate var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public LongSeqLike map(@NotNull LongUnaryOperator var1);

    @Contract(pure=true)
    @NotNull
    public <U> SeqLike<U> mapToObj(@NotNull LongFunction<? extends U> var1);

    @Override
    @Contract(pure=true)
    @NotNull
    public LongSeqLike flatMap(@NotNull LongFunction<? extends LongTraversable> var1);
}

