/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import kala.collection.base.primitive.AbstractDoubleIterator;
import kala.collection.mutable.primitive.MutableDoubleList;
import kala.collection.mutable.primitive.MutableDoubleListIterator;
import kala.collection.mutable.primitive.MutableDoubleSeq;
import kala.collection.mutable.primitive.MutableDoubleSeqIterator;
import kala.collection.primitive.AbstractDoubleSeqIterator;
import kala.collection.primitive.DoubleSeqIterator;
import kala.collection.primitive.DoubleSeqLike;
import org.jetbrains.annotations.NotNull;

public final class DoubleSeqIterators {
    public static final DoubleSeqIterator EMPTY = new EmptyDoubleSeqIterator();
    public static final MutableDoubleSeqIterator EMPTY_MUTABLE = new EmptyMutableDoubleSeqIterator();

    private DoubleSeqIterators() {
    }

    private static class EmptyDoubleSeqIterator
    extends AbstractDoubleIterator
    implements DoubleSeqIterator {
        private EmptyDoubleSeqIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public double nextDouble() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public double previousDouble() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }
    }

    private static class EmptyMutableDoubleSeqIterator
    extends EmptyDoubleSeqIterator
    implements MutableDoubleSeqIterator {
        private EmptyMutableDoubleSeqIterator() {
        }

        @Override
        public void set(double e) {
            throw new IllegalStateException();
        }
    }

    public static final class FrozenDoubleSeqIterator
    implements DoubleSeqIterator {
        @NotNull
        private final DoubleSeqIterator source;

        public FrozenDoubleSeqIterator(@NotNull DoubleSeqIterator source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public double nextDouble() {
            return this.source.nextDouble();
        }

        @Override
        public boolean hasPrevious() {
            return this.source.hasPrevious();
        }

        @Override
        public double previousDouble() {
            return this.source.previousDouble();
        }

        @Override
        public int nextIndex() {
            return this.source.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.source.previousIndex();
        }

        public String toString() {
            return "FrozenDoubleSeqIterator[" + this.source + ']';
        }
    }

    public static class DefaultMutableDoubleListIterator<S extends MutableDoubleList>
    extends DefaultMutableDoubleSeqIterator<S>
    implements MutableDoubleListIterator {
        public DefaultMutableDoubleListIterator(@NotNull S seq, int index) {
            super(seq, index);
        }

        @Override
        public void add(double e) {
            try {
                int i = this.cursor;
                ((MutableDoubleList)this.seq).insert(i, e);
                this.lastRet = -1;
                this.cursor = i + 1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                ((MutableDoubleList)this.seq).removeAt(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public static class DefaultMutableDoubleSeqIterator<S extends MutableDoubleSeq>
    extends DefaultDoubleSeqIterator<S>
    implements MutableDoubleSeqIterator {
        public DefaultMutableDoubleSeqIterator(@NotNull S seq, int index) {
            super(seq, index);
        }

        @Override
        public void set(double e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                ((MutableDoubleSeq)this.seq).set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public static class DefaultDoubleSeqIterator<S extends DoubleSeqLike>
    extends AbstractDoubleSeqIterator {
        @NotNull
        protected final S seq;
        protected int lastRet = -1;

        public DefaultDoubleSeqIterator(@NotNull S seq, int index) {
            super(index);
            this.seq = seq;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.seq.size();
        }

        @Override
        public double nextDouble() {
            try {
                int i = this.cursor;
                double next = this.seq.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public double previousDouble() {
            try {
                int i = this.cursor - 1;
                double previous = this.seq.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }
    }
}

