/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal.tree;

import java.io.Serializable;
import kala.function.ShortConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ShortRedBlackTree<N extends Node<N>>
implements Serializable {
    private static final long serialVersionUID = 3036340578028981301L;
    protected static final boolean RED = true;
    protected static final boolean BLACK = false;
    protected transient N root;
    protected transient int size;

    protected ShortRedBlackTree() {
    }

    @Nullable
    protected final N getNode(short key) {
        N n = this.root;
        while (n != null) {
            int c = Short.compare(key, ((Node)n).key);
            if (c < 0) {
                n = ((Node)n).left;
                continue;
            }
            if (c > 0) {
                n = ((Node)n).right;
                continue;
            }
            return n;
        }
        return null;
    }

    @Nullable
    protected final N firstNode() {
        N node = this.root;
        if (node == null) {
            return null;
        }
        while (((Node)node).left != null) {
            node = ((Node)node).left;
        }
        return node;
    }

    @Nullable
    protected final N lastNode() {
        N node = this.root;
        if (node == null) {
            return null;
        }
        while (((Node)node).right != null) {
            node = ((Node)node).right;
        }
        return node;
    }

    protected static boolean colorOf(Node<?> p) {
        return p == null ? false : p.color;
    }

    protected static <N extends Node<N>> N parentOrNull(N p) {
        return p == null ? null : (N)p.parent;
    }

    protected static void setColor(Node<?> p, boolean c) {
        if (p != null) {
            p.color = c;
        }
    }

    protected static <N extends Node<N>> N leftOrNull(@Nullable N p) {
        return p == null ? null : (N)p.left;
    }

    protected static <N extends Node<N>> N rightOrNull(@Nullable N p) {
        return p == null ? null : (N)p.right;
    }

    protected static <N extends Node<N>> N minNode(@NotNull N node) {
        Object left;
        while ((left = node.left) != null) {
            node = left;
        }
        return node;
    }

    protected static <N extends Node<N>> N maxNode(@NotNull N node) {
        Object right;
        while ((right = node.right) != null) {
            node = right;
        }
        return node;
    }

    protected static <N extends Node<N>> N successor(@NotNull N node) {
        if (node.right != null) {
            return ShortRedBlackTree.minNode(node.right);
        }
        Object n = node.parent;
        N ch = node;
        while (n != null && ch == ((Node)n).right) {
            ch = n;
            n = ((Node)n).parent;
        }
        return n;
    }

    protected static <N extends Node<N>> N predecessor(@NotNull N node) {
        if (node.left != null) {
            return ShortRedBlackTree.maxNode(node.left);
        }
        Object p = node.parent;
        N ch = node;
        while (p != null && ch == ((Node)p).left) {
            ch = p;
            p = ((Node)p).parent;
        }
        return p;
    }

    protected final void rotateLeft(N node) {
        if (node == null) {
            return;
        }
        Object r = ((Node)node).right;
        ((Node)node).right = ((Node)r).left;
        if (((Node)r).left != null) {
            ((Node)((Node)r).left).parent = node;
        }
        ((Node)r).parent = ((Node)node).parent;
        if (((Node)node).parent == null) {
            this.root = r;
        } else if (((Node)((Node)node).parent).left == node) {
            ((Node)((Node)node).parent).left = r;
        } else {
            ((Node)((Node)node).parent).right = r;
        }
        ((Node)r).left = node;
        ((Node)node).parent = r;
    }

    protected final void rotateRight(N node) {
        if (node == null) {
            return;
        }
        Object l = ((Node)node).left;
        ((Node)node).left = ((Node)l).right;
        if (((Node)l).right != null) {
            ((Node)((Node)l).right).parent = node;
        }
        ((Node)l).parent = ((Node)node).parent;
        if (((Node)node).parent == null) {
            this.root = l;
        } else if (((Node)((Node)node).parent).right == node) {
            ((Node)((Node)node).parent).right = l;
        } else {
            ((Node)((Node)node).parent).left = l;
        }
        ((Node)l).right = node;
        ((Node)node).parent = l;
    }

    protected final void fixAfterInsert(N x) {
        ((Node)x).color = true;
        while (x != null && x != this.root && ((Node)((Node)x).parent).color) {
            N y;
            if (ShortRedBlackTree.parentOrNull(x) == ShortRedBlackTree.leftOrNull(ShortRedBlackTree.parentOrNull(ShortRedBlackTree.parentOrNull(x)))) {
                y = ShortRedBlackTree.rightOrNull(ShortRedBlackTree.parentOrNull(ShortRedBlackTree.parentOrNull(x)));
                if (ShortRedBlackTree.colorOf(y)) {
                    ShortRedBlackTree.setColor(ShortRedBlackTree.parentOrNull(x), false);
                    ShortRedBlackTree.setColor(y, false);
                    ShortRedBlackTree.setColor(ShortRedBlackTree.parentOrNull(ShortRedBlackTree.parentOrNull(x)), true);
                    x = ShortRedBlackTree.parentOrNull(ShortRedBlackTree.parentOrNull(x));
                    continue;
                }
                if (x == ShortRedBlackTree.rightOrNull(ShortRedBlackTree.parentOrNull(x))) {
                    x = ShortRedBlackTree.parentOrNull(x);
                    this.rotateLeft(x);
                }
                ShortRedBlackTree.setColor(ShortRedBlackTree.parentOrNull(x), false);
                ShortRedBlackTree.setColor(ShortRedBlackTree.parentOrNull(ShortRedBlackTree.parentOrNull(x)), true);
                this.rotateRight(ShortRedBlackTree.parentOrNull(ShortRedBlackTree.parentOrNull(x)));
                continue;
            }
            y = ShortRedBlackTree.leftOrNull(ShortRedBlackTree.parentOrNull(ShortRedBlackTree.parentOrNull(x)));
            if (ShortRedBlackTree.colorOf(y)) {
                ShortRedBlackTree.setColor(ShortRedBlackTree.parentOrNull(x), false);
                ShortRedBlackTree.setColor(y, false);
                ShortRedBlackTree.setColor(ShortRedBlackTree.parentOrNull(ShortRedBlackTree.parentOrNull(x)), true);
                x = ShortRedBlackTree.parentOrNull(ShortRedBlackTree.parentOrNull(x));
                continue;
            }
            if (x == ShortRedBlackTree.leftOrNull(ShortRedBlackTree.parentOrNull(x))) {
                x = ShortRedBlackTree.parentOrNull(x);
                this.rotateRight(x);
            }
            ShortRedBlackTree.setColor(ShortRedBlackTree.parentOrNull(x), false);
            ShortRedBlackTree.setColor(ShortRedBlackTree.parentOrNull(ShortRedBlackTree.parentOrNull(x)), true);
            this.rotateLeft(ShortRedBlackTree.parentOrNull(ShortRedBlackTree.parentOrNull(x)));
        }
        ((Node)this.root).color = false;
    }

    protected final void fixAfterDelete(N x) {
        while (x != this.root && !ShortRedBlackTree.colorOf(x)) {
            N sib;
            if (x == ShortRedBlackTree.leftOrNull(ShortRedBlackTree.parentOrNull(x))) {
                sib = ShortRedBlackTree.rightOrNull(ShortRedBlackTree.parentOrNull(x));
                if (ShortRedBlackTree.colorOf(sib)) {
                    ShortRedBlackTree.setColor(sib, false);
                    ShortRedBlackTree.setColor(ShortRedBlackTree.parentOrNull(x), true);
                    this.rotateLeft(ShortRedBlackTree.parentOrNull(x));
                    sib = ShortRedBlackTree.rightOrNull(ShortRedBlackTree.parentOrNull(x));
                }
                if (!ShortRedBlackTree.colorOf(ShortRedBlackTree.leftOrNull(sib)) && !ShortRedBlackTree.colorOf(ShortRedBlackTree.rightOrNull(sib))) {
                    ShortRedBlackTree.setColor(sib, true);
                    x = ShortRedBlackTree.parentOrNull(x);
                    continue;
                }
                if (!ShortRedBlackTree.colorOf(ShortRedBlackTree.rightOrNull(sib))) {
                    ShortRedBlackTree.setColor(ShortRedBlackTree.leftOrNull(sib), false);
                    ShortRedBlackTree.setColor(sib, true);
                    this.rotateRight(sib);
                    sib = ShortRedBlackTree.rightOrNull(ShortRedBlackTree.parentOrNull(x));
                }
                ShortRedBlackTree.setColor(sib, ShortRedBlackTree.colorOf(ShortRedBlackTree.parentOrNull(x)));
                ShortRedBlackTree.setColor(ShortRedBlackTree.parentOrNull(x), false);
                ShortRedBlackTree.setColor(ShortRedBlackTree.rightOrNull(sib), false);
                this.rotateLeft(ShortRedBlackTree.parentOrNull(x));
                x = this.root;
                continue;
            }
            sib = ShortRedBlackTree.leftOrNull(ShortRedBlackTree.parentOrNull(x));
            if (ShortRedBlackTree.colorOf(sib)) {
                ShortRedBlackTree.setColor(sib, false);
                ShortRedBlackTree.setColor(ShortRedBlackTree.parentOrNull(x), true);
                this.rotateRight(ShortRedBlackTree.parentOrNull(x));
                sib = ShortRedBlackTree.leftOrNull(ShortRedBlackTree.parentOrNull(x));
            }
            if (!ShortRedBlackTree.colorOf(ShortRedBlackTree.rightOrNull(sib)) && !ShortRedBlackTree.colorOf(ShortRedBlackTree.leftOrNull(sib))) {
                ShortRedBlackTree.setColor(sib, true);
                x = ShortRedBlackTree.parentOrNull(x);
                continue;
            }
            if (!ShortRedBlackTree.colorOf(ShortRedBlackTree.leftOrNull(sib))) {
                ShortRedBlackTree.setColor(ShortRedBlackTree.rightOrNull(sib), false);
                ShortRedBlackTree.setColor(sib, true);
                this.rotateLeft(sib);
                sib = ShortRedBlackTree.leftOrNull(ShortRedBlackTree.parentOrNull(x));
            }
            ShortRedBlackTree.setColor(sib, ShortRedBlackTree.colorOf(ShortRedBlackTree.parentOrNull(x)));
            ShortRedBlackTree.setColor(ShortRedBlackTree.parentOrNull(x), false);
            ShortRedBlackTree.setColor(ShortRedBlackTree.leftOrNull(sib), false);
            this.rotateRight(ShortRedBlackTree.parentOrNull(x));
            x = this.root;
        }
        ShortRedBlackTree.setColor(x, false);
    }

    protected final void remove0(N node) {
        Object replacement;
        if (((Node)node).left != null && ((Node)node).right != null) {
            N s = ShortRedBlackTree.successor(node);
            ((Node)node).copyValuesFrom(s);
            node = s;
        }
        Object n = replacement = ((Node)node).left != null ? ((Node)node).left : ((Node)node).right;
        if (replacement != null) {
            ((Node)replacement).parent = ((Node)node).parent;
            if (((Node)node).parent == null) {
                this.root = replacement;
            } else if (node == ((Node)((Node)node).parent).left) {
                ((Node)((Node)node).parent).left = replacement;
            } else {
                ((Node)((Node)node).parent).right = replacement;
            }
            ((Node)node).parent = null;
            ((Node)node).right = null;
            ((Node)node).left = null;
            if (!((Node)node).color) {
                this.fixAfterDelete(replacement);
            }
        } else if (((Node)node).parent == null) {
            this.root = null;
        } else {
            if (!((Node)node).color) {
                this.fixAfterDelete(node);
            }
            if (((Node)node).parent != null) {
                if (node == ((Node)((Node)node).parent).left) {
                    ((Node)((Node)node).parent).left = null;
                } else if (node == ((Node)((Node)node).parent).right) {
                    ((Node)((Node)node).parent).right = null;
                }
                ((Node)node).parent = null;
            }
        }
        --this.size;
    }

    protected final void forEachKey0(@NotNull ShortConsumer consumer) {
        N node = this.firstNode();
        while (node != null) {
            Object n;
            consumer.accept(((Node)node).key);
            if (((Node)node).right != null) {
                n = ((Node)node).right;
                while (((Node)n).left != null) {
                    n = ((Node)n).left;
                }
            } else {
                n = ((Node)node).parent;
                N c = node;
                while (n != null && c == ((Node)n).right) {
                    c = n;
                    n = ((Node)n).parent;
                }
            }
            node = n;
        }
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final int size() {
        return this.size;
    }

    public int knownSize() {
        return this.size;
    }

    public final void clear() {
        this.root = null;
        this.size = 0;
    }

    protected static class Node<N extends Node<N>> {
        public boolean color = false;
        public short key;
        public N left;
        public N right;
        public N parent;

        public Node(short key, N parent) {
            this.key = key;
            this.parent = parent;
        }

        public void copyValuesFrom(N other) {
            this.key = ((Node)other).key;
        }
    }
}

