/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal.view;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.DoubleStream;
import kala.Conditions;
import kala.collection.AbstractSeqView;
import kala.collection.SeqView;
import kala.collection.base.primitive.AbstractDoubleIterator;
import kala.collection.base.primitive.DoubleArrays;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.base.primitive.DoubleTraversable;
import kala.collection.mutable.primitive.MutableDoubleArrayList;
import kala.collection.primitive.AbstractDoubleSeqView;
import kala.collection.primitive.DoubleSeq;
import kala.collection.primitive.DoubleSeqLike;
import kala.collection.primitive.DoubleSeqView;
import kala.collection.primitive.IndexedDoubleSeqLike;
import kala.collection.primitive.internal.view.DoubleCollectionViews;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class DoubleSeqViews {
    public static final DoubleSeqView EMPTY = new Empty();

    public static class Empty
    extends DoubleCollectionViews.Empty
    implements DoubleSeqView {
        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public DoubleSeqView reversed() {
            return this;
        }

        @Override
        @NotNull
        public DoubleIterator reverseIterator() {
            return DoubleIterator.empty();
        }

        @Override
        public double get(int index) {
            throw new IndexOutOfBoundsException("index: " + index);
        }

        @Override
        @NotNull
        public DoubleSeqView concat(@NotNull DoubleSeqLike other) {
            return other.view();
        }

        @Override
        @NotNull
        public DoubleSeqView filter(@NotNull DoublePredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public DoubleSeqView filterNot(@NotNull DoublePredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public DoubleSeqView map(@NotNull DoubleUnaryOperator mapper) {
            return this;
        }

        @Override
        @NotNull
        public <U> SeqView<U> mapToObj(@NotNull DoubleFunction<? extends U> mapper) {
            return SeqView.empty();
        }

        @Override
        @NotNull
        public DoubleSeqView flatMap(@NotNull DoubleFunction<? extends DoubleTraversable> mapper) {
            return this;
        }

        @Override
        @NotNull
        public DoubleSeqView sorted() {
            return this;
        }
    }

    public static final class Sorted
    extends AbstractDoubleSeqView {
        private final DoubleSeqView source;
        private double[] sorted;

        public Sorted(@NotNull DoubleSeqView source) {
            this.source = source;
        }

        private void initSorted() {
            if (this.sorted == null) {
                double[] arr = this.source.toArray();
                DoubleArrays.sort((double[])arr);
                this.sorted = arr;
            }
        }

        @NotNull
        public final DoubleIterator iterator() {
            this.initSorted();
            return DoubleArrays.iterator((double[])this.sorted);
        }

        public final int size() {
            return this.sorted == null ? this.source.size() : this.sorted.length;
        }

        public final int knownSize() {
            return this.sorted == null ? this.source.knownSize() : this.sorted.length;
        }

        @Override
        public final double get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
            this.initSorted();
            try {
                return this.sorted[index];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException(e.getMessage());
            }
        }

        @Override
        @NotNull
        public final DoubleSeqView sorted() {
            return this;
        }
    }

    public static class MapToObj<E>
    extends AbstractSeqView<E> {
        @NotNull
        private final DoubleSeqView source;
        @NotNull
        private final DoubleFunction<? extends E> mapper;

        public MapToObj(@NotNull DoubleSeqView source, @NotNull DoubleFunction<? extends E> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return this.source.iterator().mapToObj(this.mapper);
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        public boolean isDefinedAt(int index) {
            return this.source.isDefinedAt(index);
        }

        public final E get(int index) {
            return this.mapper.apply(this.source.get(index));
        }
    }

    public static class Mapped
    extends AbstractDoubleSeqView {
        @NotNull
        private final DoubleSeqView source;
        @NotNull
        private final DoubleUnaryOperator mapper;

        public Mapped(@NotNull DoubleSeqView source, @NotNull DoubleUnaryOperator mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final DoubleIterator iterator() {
            return this.source.iterator().map(this.mapper);
        }

        @NotNull
        public final DoubleStream stream() {
            return this.source.stream().map(this.mapper);
        }

        @NotNull
        public final DoubleStream parallelStream() {
            return this.source.parallelStream().map(this.mapper);
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public final double get(int index) {
            return this.mapper.applyAsDouble(this.source.get(index));
        }
    }

    public static final class FlatMapped
    extends AbstractDoubleSeqView {
        @NotNull
        private final DoubleSeqLike source;
        @NotNull
        private final DoubleFunction<? extends DoubleTraversable> mapper;

        public FlatMapped(@NotNull DoubleSeqLike source, @NotNull DoubleFunction<? extends DoubleTraversable> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final DoubleIterator iterator() {
            return DoubleIterator.concat(this.source.mapToObj((double it) -> this.mapper.apply(it).iterator()));
        }
    }

    public static final class FilterNot
    extends AbstractDoubleSeqView {
        @NotNull
        private final DoubleSeqView source;
        @NotNull
        private final DoublePredicate predicate;

        public FilterNot(@NotNull DoubleSeqView source, @NotNull DoublePredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final DoubleIterator iterator() {
            return this.source.iterator().filterNot(this.predicate);
        }

        @NotNull
        public DoubleStream stream() {
            return this.source.stream().filter(this.predicate.negate());
        }

        @NotNull
        public DoubleStream parallelStream() {
            return this.source.parallelStream().filter(this.predicate.negate());
        }
    }

    public static final class Filter
    extends AbstractDoubleSeqView {
        @NotNull
        private final DoubleSeqView source;
        @NotNull
        private final DoublePredicate predicate;

        public Filter(@NotNull DoubleSeqView source, @NotNull DoublePredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public DoubleIterator iterator() {
            return this.source.iterator().filter(this.predicate);
        }

        @NotNull
        public DoubleStream stream() {
            return this.source.stream().filter(this.predicate);
        }

        @NotNull
        public DoubleStream parallelStream() {
            return this.source.parallelStream().filter(this.predicate);
        }
    }

    public static class Reversed
    extends AbstractDoubleSeqView {
        @NotNull
        protected final DoubleSeqView source;

        public Reversed(@NotNull DoubleSeqView source) {
            this.source = source;
        }

        @NotNull
        public final DoubleIterator iterator() {
            return this.source.reverseIterator();
        }

        public final boolean isEmpty() {
            return this.source.isEmpty();
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public final double get(int index) {
            return this.source.get(this.size() - 1 - index);
        }

        @Override
        @NotNull
        public final DoubleSeqView reversed() {
            return this.source;
        }

        @Override
        @NotNull
        public final DoubleIterator reverseIterator() {
            return this.source.iterator();
        }
    }

    public static class Appended
    extends AbstractDoubleSeqView {
        @NotNull
        protected final DoubleSeqView source;
        protected final double value;

        public Appended(@NotNull DoubleSeqView source, double value) {
            this.source = source;
            this.value = value;
        }

        public final int size() {
            return this.source.size() + 1;
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return sks + 1;
        }

        @NotNull
        public final DoubleIterator iterator() {
            return this.source.iterator().appended(this.value);
        }
    }

    public static class Prepended
    extends AbstractDoubleSeqView {
        @NotNull
        private final DoubleSeqView source;
        private final double value;

        public Prepended(@NotNull DoubleSeqView source, double value) {
            this.source = source;
            this.value = value;
        }

        @NotNull
        public final DoubleIterator iterator() {
            return this.source.iterator().prepended(this.value);
        }

        @Override
        public final double get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
            return index == 0 ? this.value : this.source.get(index - 1);
        }

        public final int size() {
            return this.source.size() + 1;
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return sks + 1;
        }
    }

    public static class Concat
    extends AbstractDoubleSeqView {
        @NotNull
        protected final DoubleSeqLike seq1;
        @NotNull
        protected final DoubleSeqLike seq2;

        public Concat(@NotNull DoubleSeqLike seq1, @NotNull DoubleSeqLike seq2) {
            this.seq1 = seq1;
            this.seq2 = seq2;
        }

        @NotNull
        public final DoubleIterator iterator() {
            return DoubleIterator.concat((DoubleIterator)this.seq1.iterator(), (DoubleIterator)this.seq2.iterator());
        }

        public final int size() {
            return this.seq1.size() + this.seq2.size();
        }

        public int knownSize() {
            int ks1 = this.seq1.knownSize();
            if (ks1 < 0) {
                return -1;
            }
            int ks2 = this.seq2.knownSize();
            if (ks2 < 0) {
                return -1;
            }
            return ks1 + ks2;
        }
    }

    public static class TakeWhile
    extends AbstractDoubleSeqView {
        @NotNull
        private final DoubleSeqView source;
        @NotNull
        private final DoublePredicate predicate;

        public TakeWhile(@NotNull DoubleSeqView source, @NotNull DoublePredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final DoubleIterator iterator() {
            return this.source.iterator().takeWhile(this.predicate);
        }
    }

    public static class TakeLast
    extends AbstractDoubleSeqView {
        @NotNull
        protected final DoubleSeqView source;
        private final int n;
        private final int delta;

        public TakeLast(@NotNull DoubleSeqView source, int n) {
            this.source = source;
            this.n = Integer.max(n, 0);
            this.delta = Integer.max(0, source.size() - Integer.max(0, n));
        }

        @Override
        public final double get(int index) {
            return this.source.get(index + this.delta);
        }

        public final int size() {
            return this.source.size() - this.delta;
        }

        public final int knownSize() {
            int kn = this.source.knownSize();
            return kn >= 0 ? Integer.min(kn, this.n) : -1;
        }

        @NotNull
        public final DoubleIterator iterator() {
            int k = this.source.knownSize();
            if (k == 0 || this.n <= 0) {
                return DoubleIterator.empty();
            }
            if (this.n == Integer.MAX_VALUE) {
                return this.source.iterator();
            }
            if (k > 0) {
                return this.source.iterator().drop(Integer.max(k - this.n, 0));
            }
            return new AbstractDoubleIterator(){
                DoubleIterator it;
                int len;
                int pos;
                MutableDoubleArrayList buf;
                {
                    this.it = source.iterator();
                    this.len = -1;
                    this.pos = 0;
                    this.buf = null;
                }

                private void init() {
                    if (this.buf != null) {
                        return;
                    }
                    this.buf = new MutableDoubleArrayList();
                    this.len = 0;
                    while (this.it.hasNext()) {
                        double next = this.it.nextDouble();
                        if (this.pos >= this.buf.size()) {
                            this.buf.append(next);
                        } else {
                            this.buf.set(this.pos, next);
                        }
                        if (++this.pos == n) {
                            this.pos = 0;
                        }
                        ++this.len;
                    }
                    this.it = null;
                    if (this.len > n) {
                        this.len = n;
                    }
                    this.pos -= this.len;
                    if (this.pos < 0) {
                        this.pos += n;
                    }
                }

                public final boolean hasNext() {
                    this.init();
                    return this.len > 0;
                }

                public final double nextDouble() {
                    this.init();
                    if (this.len == 0) {
                        throw new NoSuchElementException();
                    }
                    double v = this.buf.get(this.pos);
                    ++this.pos;
                    if (this.pos == n) {
                        this.pos = 0;
                    }
                    --this.len;
                    return v;
                }
            };
        }
    }

    public static class Take
    extends AbstractDoubleSeqView {
        @NotNull
        protected final DoubleSeqView source;
        protected final @Range(from=1L, to=0x7FFFFFFFL) int n;

        public Take(@NotNull DoubleSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final DoubleIterator iterator() {
            return this.source.iterator().take(this.n);
        }

        @NotNull
        public DoubleStream stream() {
            return this.source.stream().limit(this.n);
        }

        @NotNull
        public DoubleStream parallelStream() {
            return this.source.stream().limit(this.n).parallel();
        }

        public int size() {
            if (this.n <= 0) {
                return 0;
            }
            return Integer.min(this.n, this.source.size());
        }

        public int knownSize() {
            if (this.n <= 0) {
                return 0;
            }
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return Integer.min(sks, this.n);
        }

        @Override
        @NotNull
        public DoubleSeqView take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            if (this.n <= n) {
                return this;
            }
            return new Take(this.source, n);
        }
    }

    public static class DropWhile
    extends AbstractDoubleSeqView {
        @NotNull
        private final DoubleSeqView source;
        @NotNull
        private final DoublePredicate predicate;

        public DropWhile(@NotNull DoubleSeqView source, @NotNull DoublePredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final DoubleIterator iterator() {
            return this.source.iterator().dropWhile(this.predicate);
        }
    }

    public static class DropLast
    extends AbstractDoubleSeqView {
        @NotNull
        protected final DoubleSeqView source;
        private final @Range(from=1L, to=0x7FFFFFFFL) int n;

        public DropLast(@NotNull DoubleSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final DoubleIterator iterator() {
            int ss = this.source.size();
            if (this.n >= ss) {
                return DoubleIterator.empty();
            }
            return this.source.iterator().take(ss - this.n);
        }

        @Override
        public final double get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index(" + index + ") < 0");
            }
            DoubleSeqView source = this.source;
            int n = this.n;
            if (n <= 0) {
                return this.source.get(index);
            }
            int size = Integer.max(source.size() - n, 0);
            Conditions.checkElementIndex((int)index, (int)size);
            return this.source.get(index);
        }

        public final int size() {
            return Integer.max(0, this.source.size() - this.n);
        }

        public final int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            if (this.n >= sks) {
                return 0;
            }
            return sks - this.n;
        }
    }

    public static class Drop
    extends AbstractDoubleSeqView {
        @NotNull
        protected final DoubleSeqView source;
        protected final int n;

        public Drop(@NotNull DoubleSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final DoubleIterator iterator() {
            return this.iterator().drop(this.n);
        }

        @NotNull
        public DoubleStream stream() {
            return this.source.stream().skip(this.n);
        }

        @NotNull
        public DoubleStream parallelStream() {
            return this.source.stream().skip(this.n).parallel();
        }

        public final int size() {
            return Integer.max(0, this.source.size() - this.n);
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            return sks < 0 ? -1 : Integer.max(0, sks - this.n);
        }

        @Override
        @NotNull
        public DoubleSeqView drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            return this.source.drop(n + this.n);
        }
    }

    public static class Updated
    extends AbstractDoubleSeqView {
        @NotNull
        private final DoubleSeqView source;
        private final int index;
        private final double newValue;

        public Updated(@NotNull DoubleSeqView source, int index, double newValue) {
            this.source = source;
            this.index = index;
            this.newValue = newValue;
        }

        @NotNull
        public final DoubleIterator iterator() {
            return new AbstractDoubleIterator(){
                private final DoubleIterator it;
                private int i;
                {
                    this.it = source.iterator();
                    this.i = 0;
                }

                public final boolean hasNext() {
                    if (this.it.hasNext()) {
                        return true;
                    }
                    if (index >= this.i) {
                        throw new IndexOutOfBoundsException();
                    }
                    return false;
                }

                public final double nextDouble() {
                    double value = this.it.next();
                    if (this.i++ == index) {
                        value = newValue;
                    }
                    return value;
                }
            };
        }

        public final int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public boolean isDefinedAt(int index) {
            return this.source.isDefinedAt(index);
        }

        @Override
        public final double get(int index) {
            if (index == this.index) {
                return this.newValue;
            }
            return this.source.get(index);
        }
    }

    public static class Slice
    extends AbstractDoubleSeqView {
        @NotNull
        protected final DoubleSeqView source;
        protected final int beginIndex;
        protected final int endIndex;

        public Slice(@NotNull DoubleSeqView source, int beginIndex, int endIndex) {
            this.source = source;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @NotNull
        public DoubleIterator iterator() {
            return new Itr();
        }

        public boolean isEmpty() {
            return this.beginIndex == this.endIndex;
        }

        public int size() {
            return this.endIndex - this.beginIndex;
        }

        public int knownSize() {
            return this.endIndex - this.beginIndex;
        }

        private final class Itr
        extends AbstractDoubleIterator {
            private int idx;
            private final DoubleIterator it;

            Itr() {
                DoubleIterator it = Slice.this.source.iterator();
                for (int i = Slice.this.beginIndex; i > 0; --i) {
                    try {
                        it.next();
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        throw new IndexOutOfBoundsException();
                    }
                }
                this.idx = Slice.this.beginIndex;
                this.it = it;
            }

            public final boolean hasNext() {
                return this.idx < Slice.this.endIndex;
            }

            public final double nextDouble() {
                if (this.idx >= Slice.this.endIndex) {
                    throw new NoSuchElementException();
                }
                try {
                    double next = this.it.next();
                    ++this.idx;
                    return next;
                }
                catch (NoSuchElementException e) {
                    throw new IndexOutOfBoundsException();
                }
            }
        }
    }

    public static class WithCachedSize<C extends DoubleSeq>
    extends Of<C> {
        protected int cachedSize = -1;

        public WithCachedSize(@NotNull C source) {
            super(source);
        }

        public WithCachedSize(@NotNull C source, int size) {
            super(source);
            this.cachedSize = size;
        }

        @Override
        public boolean isEmpty() {
            int cachedSize = this.cachedSize;
            if (cachedSize == 0) {
                return true;
            }
            if (cachedSize > 0) {
                return false;
            }
            return ((DoubleSeq)this.source).isEmpty();
        }

        @Override
        public final int size() {
            int ss;
            if (this.cachedSize >= 0) {
                return this.cachedSize;
            }
            this.cachedSize = ss = ((DoubleSeq)this.source).size();
            return ss;
        }

        @Override
        public final int knownSize() {
            if (this.cachedSize >= 0) {
                return this.cachedSize;
            }
            int sks = ((DoubleSeq)this.source).knownSize();
            if (sks >= 0) {
                this.cachedSize = sks;
                return sks;
            }
            return -1;
        }
    }

    public static class OfArraySlice
    implements DoubleSeqView,
    IndexedDoubleSeqLike {
        protected final double[] array;
        protected final int beginIndex;
        protected final int endIndex;

        public OfArraySlice(double[] array, int beginIndex, int endIndex) {
            this.array = array;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public DoubleIterator iterator() {
            return DoubleArrays.iterator((double[])this.array, (int)this.beginIndex, (int)this.endIndex);
        }

        public final int size() {
            return this.endIndex - this.beginIndex;
        }

        public final int beginIndex() {
            return this.beginIndex;
        }

        public final int endIndex() {
            return this.endIndex;
        }

        @Override
        public final double get(int index) {
            Conditions.checkElementIndex((int)index, (int)this.size());
            return this.array[index + this.beginIndex];
        }

        @Override
        @NotNull
        public DoubleSeqView slice(int beginIndex, int endIndex) {
            Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size());
            int ns = endIndex - beginIndex;
            switch (ns) {
                case 0: {
                    return EMPTY;
                }
                case 1: {
                    return new Single(this.array[this.beginIndex + beginIndex]);
                }
            }
            return new OfArraySlice(this.array, this.beginIndex + beginIndex, this.beginIndex + endIndex);
        }

        @Override
        @NotNull
        public DoubleSeqView drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            int size = this.size();
            if (n >= size) {
                return EMPTY;
            }
            return new OfArraySlice(this.array, this.beginIndex + n, this.endIndex);
        }

        @Override
        @NotNull
        public DoubleSeqView dropLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            int size = this.size();
            if (n >= size) {
                return EMPTY;
            }
            return new OfArraySlice(this.array, this.beginIndex, this.endIndex - n);
        }

        @Override
        @NotNull
        public DoubleSeqView take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            int size = this.size();
            if (n >= size) {
                return this;
            }
            if (n == 1) {
                return new Single(this.array[this.beginIndex]);
            }
            return new OfArraySlice(this.array, this.beginIndex, this.beginIndex + n);
        }

        @Override
        @NotNull
        public DoubleSeqView takeLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            int size = this.size();
            if (n >= size) {
                return this;
            }
            if (n == 1) {
                return new Single(this.array[this.beginIndex]);
            }
            return new OfArraySlice(this.array, this.endIndex - n, this.endIndex);
        }
    }

    public static class Of<C extends DoubleSeqLike>
    extends DoubleCollectionViews.Of<C>
    implements DoubleSeqView {
        public Of(@NotNull C source) {
            super(source);
        }

        public boolean supportsFastRandomAccess() {
            return ((DoubleSeqLike)this.source).supportsFastRandomAccess();
        }

        @Override
        public double get(int index) {
            return ((DoubleSeqLike)this.source).get(index);
        }

        @Override
        public boolean isDefinedAt(int index) {
            return ((DoubleSeqLike)this.source).isDefinedAt(index);
        }

        @Override
        public int indexOf(double value) {
            return ((DoubleSeqLike)this.source).indexOf(value);
        }

        @Override
        public int indexOf(double value, int from) {
            return ((DoubleSeqLike)this.source).indexOf(value, from);
        }

        @Override
        public int indexWhere(@NotNull DoublePredicate predicate) {
            return ((DoubleSeqLike)this.source).indexWhere(predicate);
        }

        @Override
        public int indexWhere(@NotNull DoublePredicate predicate, int from) {
            return ((DoubleSeqLike)this.source).indexWhere(predicate, from);
        }

        @Override
        public int lastIndexOf(double value) {
            return ((DoubleSeqLike)this.source).lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(double value, int end) {
            return ((DoubleSeqLike)this.source).lastIndexOf(value, end);
        }

        @Override
        public int lastIndexWhere(@NotNull DoublePredicate predicate) {
            return ((DoubleSeqLike)this.source).lastIndexWhere(predicate);
        }

        @Override
        public int lastIndexWhere(@NotNull DoublePredicate predicate, int end) {
            return ((DoubleSeqLike)this.source).lastIndexWhere(predicate, end);
        }

        @Override
        @NotNull
        public DoubleIterator reverseIterator() {
            return ((DoubleSeqLike)this.source).reverseIterator();
        }
    }

    public static class Single
    extends DoubleCollectionViews.Single
    implements DoubleSeqView {
        public Single(double value) {
            super(value);
        }

        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public DoubleSeqView reversed() {
            return this;
        }

        @Override
        @NotNull
        public final DoubleIterator reverseIterator() {
            return DoubleIterator.of((double)this.value);
        }

        @Override
        public double get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this.value;
        }

        @Override
        @NotNull
        public DoubleSeqView updated(int index, double newValue) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return new Single(newValue);
        }
    }
}

