/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal.view;

import java.util.Iterator;
import kala.collection.AbstractCollectionView;
import kala.collection.CollectionView;
import kala.collection.base.primitive.FloatArrays;
import kala.collection.base.primitive.FloatIterator;
import kala.collection.base.primitive.FloatTraversable;
import kala.collection.primitive.AbstractFloatCollectionView;
import kala.collection.primitive.FloatCollectionLike;
import kala.collection.primitive.FloatCollectionView;
import kala.control.primitive.FloatOption;
import kala.function.FloatConsumer;
import kala.function.FloatFunction;
import kala.function.FloatPredicate;
import kala.function.FloatUnaryOperator;
import org.jetbrains.annotations.NotNull;

public final class FloatCollectionViews {
    public static final FloatCollectionView EMPTY = new Empty();

    private FloatCollectionViews() {
    }

    public static class Empty
    extends AbstractFloatCollectionView {
        @NotNull
        public final FloatIterator iterator() {
            return FloatIterator.empty();
        }

        public final boolean isEmpty() {
            return true;
        }

        public final int size() {
            return 0;
        }

        public final int knownSize() {
            return 0;
        }

        @Override
        @NotNull
        public FloatCollectionView filter(@NotNull FloatPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public FloatCollectionView filterNot(@NotNull FloatPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public FloatCollectionView map(@NotNull FloatUnaryOperator mapper) {
            return this;
        }

        @Override
        @NotNull
        public <U> CollectionView<U> mapToObj(@NotNull FloatFunction<? extends U> mapper) {
            return CollectionView.empty();
        }

        @Override
        @NotNull
        public FloatCollectionView flatMap(@NotNull FloatFunction<? extends FloatTraversable> mapper) {
            return this;
        }

        public final float @NotNull [] toArray() {
            return FloatArrays.EMPTY;
        }

        @Override
        public final String toString() {
            return this.className() + "[]";
        }
    }

    public static final class FlatMapped
    extends AbstractFloatCollectionView {
        @NotNull
        private final FloatCollectionView source;
        @NotNull
        private final FloatFunction<? extends FloatTraversable> mapper;

        public FlatMapped(@NotNull FloatCollectionView source, @NotNull FloatFunction<? extends FloatTraversable> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public FloatIterator iterator() {
            return FloatIterator.concat(this.source.mapToObj(it -> ((FloatTraversable)this.mapper.apply(it)).iterator()));
        }
    }

    public static final class FilterNot
    extends AbstractFloatCollectionView {
        @NotNull
        private final FloatCollectionView source;
        @NotNull
        private final FloatPredicate predicate;

        public FilterNot(@NotNull FloatCollectionView source, @NotNull FloatPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public FloatIterator iterator() {
            return this.source.iterator().filterNot(this.predicate);
        }
    }

    public static final class Filter
    extends AbstractFloatCollectionView {
        @NotNull
        private final FloatCollectionView source;
        @NotNull
        private final FloatPredicate predicate;

        public Filter(@NotNull FloatCollectionView source, @NotNull FloatPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public FloatIterator iterator() {
            return this.source.iterator().filter(this.predicate);
        }
    }

    public static final class MapToObj<T>
    extends AbstractCollectionView<T> {
        @NotNull
        private final FloatCollectionView source;
        @NotNull
        private final FloatFunction<? extends T> mapper;

        public MapToObj(@NotNull FloatCollectionView source, @NotNull FloatFunction<? extends T> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public Iterator<T> iterator() {
            return this.source.iterator().mapToObj(this.mapper);
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }
    }

    public static final class Mapped
    extends AbstractFloatCollectionView {
        @NotNull
        private final FloatCollectionView source;
        @NotNull
        private final FloatUnaryOperator mapper;

        public Mapped(@NotNull FloatCollectionView source, @NotNull FloatUnaryOperator mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public FloatIterator iterator() {
            return this.iterator().map(this.mapper);
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }
    }

    public static class Of<C extends FloatCollectionLike>
    extends AbstractFloatCollectionView {
        @NotNull
        protected final C source;

        public Of(@NotNull C source) {
            this.source = source;
        }

        @NotNull
        public final FloatIterator iterator() {
            return this.source.iterator();
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }

        @NotNull
        public FloatOption find(@NotNull FloatPredicate predicate) {
            return this.source.find(predicate);
        }

        public final boolean contains(float value) {
            return this.source.contains(value);
        }

        public final boolean containsAll(float @NotNull [] values) {
            return this.source.containsAll(values);
        }

        public final boolean containsAll(@NotNull FloatTraversable values) {
            return this.source.containsAll(values);
        }

        public final boolean sameElements(@NotNull Iterable<?> other) {
            return this.source.sameElements(other);
        }

        public final boolean anyMatch(@NotNull FloatPredicate predicate) {
            return this.source.anyMatch(predicate);
        }

        public final boolean allMatch(@NotNull FloatPredicate predicate) {
            return this.source.allMatch(predicate);
        }

        public final boolean noneMatch(@NotNull FloatPredicate predicate) {
            return this.source.noneMatch(predicate);
        }

        public final int count(@NotNull FloatPredicate predicate) {
            return this.source.count(predicate);
        }

        public final float max() {
            return this.source.max();
        }

        public final float min() {
            return this.source.min();
        }

        public final float @NotNull [] toArray() {
            return this.source.toArray();
        }

        public final void forEach(@NotNull FloatConsumer action) {
            this.source.forEach(action);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer) {
            return (A)this.source.joinTo(buffer);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull CharSequence separator) {
            return (A)this.source.joinTo(buffer, separator);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix) {
            return (A)this.source.joinTo(buffer, separator, prefix, postfix);
        }

        @NotNull
        public final String joinToString() {
            return this.source.joinToString();
        }

        @NotNull
        public final String joinToString(@NotNull CharSequence separator) {
            return this.source.joinToString(separator);
        }

        @NotNull
        public final String joinToString(@NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix) {
            return this.source.joinToString(separator, prefix, postfix);
        }

        @Override
        public final String toString() {
            return this.joinToString(", ", this.className() + "[", "]");
        }
    }

    public static class Single
    extends AbstractFloatCollectionView {
        protected final float value;

        public Single(float value) {
            this.value = value;
        }

        @NotNull
        public final FloatIterator iterator() {
            return FloatIterator.of((float)this.value);
        }

        public final boolean isEmpty() {
            return false;
        }

        public final int size() {
            return 1;
        }

        public final int knownSize() {
            return 1;
        }

        public void forEach(@NotNull FloatConsumer action) {
            action.accept(this.value);
        }
    }
}

