/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal.view;

import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongUnaryOperator;
import java.util.stream.LongStream;
import kala.collection.AbstractCollectionView;
import kala.collection.CollectionView;
import kala.collection.base.primitive.LongArrays;
import kala.collection.base.primitive.LongIterator;
import kala.collection.base.primitive.LongTraversable;
import kala.collection.primitive.AbstractLongCollectionView;
import kala.collection.primitive.LongCollectionLike;
import kala.collection.primitive.LongCollectionView;
import kala.control.primitive.LongOption;
import org.jetbrains.annotations.NotNull;

public final class LongCollectionViews {
    public static final LongCollectionView EMPTY = new Empty();

    private LongCollectionViews() {
    }

    public static class Empty
    extends AbstractLongCollectionView {
        @NotNull
        public final LongIterator iterator() {
            return LongIterator.empty();
        }

        @NotNull
        public LongStream stream() {
            return LongStream.empty();
        }

        @NotNull
        public LongStream parallelStream() {
            return LongStream.empty().parallel();
        }

        public final boolean isEmpty() {
            return true;
        }

        public final int size() {
            return 0;
        }

        public final int knownSize() {
            return 0;
        }

        @Override
        @NotNull
        public LongCollectionView filter(@NotNull LongPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public LongCollectionView filterNot(@NotNull LongPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public LongCollectionView map(@NotNull LongUnaryOperator mapper) {
            return this;
        }

        @Override
        @NotNull
        public <U> CollectionView<U> mapToObj(@NotNull LongFunction<? extends U> mapper) {
            return CollectionView.empty();
        }

        @Override
        @NotNull
        public LongCollectionView flatMap(@NotNull LongFunction<? extends LongTraversable> mapper) {
            return this;
        }

        public final long @NotNull [] toArray() {
            return LongArrays.EMPTY;
        }

        @Override
        public final String toString() {
            return this.className() + "[]";
        }
    }

    static final class MappedSpliterator
    implements Spliterator.OfLong {
        @NotNull
        private final Spliterator.OfLong source;
        @NotNull
        private final LongUnaryOperator mapper;

        MappedSpliterator(@NotNull Spliterator.OfLong source, @NotNull LongUnaryOperator mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            Objects.requireNonNull(action);
            return this.source.tryAdvance((long t) -> action.accept(this.mapper.applyAsLong(t)));
        }

        @Override
        public Spliterator.OfLong trySplit() {
            Spliterator.OfLong ss = this.source.trySplit();
            return ss != null ? new MappedSpliterator(ss, this.mapper) : null;
        }

        @Override
        public long estimateSize() {
            return this.source.estimateSize();
        }

        @Override
        public int characteristics() {
            return this.source.characteristics();
        }
    }

    public static final class FlatMapped
    extends AbstractLongCollectionView {
        @NotNull
        private final LongCollectionView source;
        @NotNull
        private final LongFunction<? extends LongTraversable> mapper;

        public FlatMapped(@NotNull LongCollectionView source, @NotNull LongFunction<? extends LongTraversable> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public LongIterator iterator() {
            return LongIterator.concat(this.source.mapToObj((long it) -> this.mapper.apply(it).iterator()));
        }
    }

    public static final class FilterNot
    extends AbstractLongCollectionView {
        @NotNull
        private final LongCollectionView source;
        @NotNull
        private final LongPredicate predicate;

        public FilterNot(@NotNull LongCollectionView source, @NotNull LongPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public LongIterator iterator() {
            return this.source.iterator().filterNot(this.predicate);
        }

        @NotNull
        public LongStream stream() {
            return this.source.stream().filter(this.predicate.negate());
        }

        @NotNull
        public LongStream parallelStream() {
            return this.source.stream().filter(this.predicate.negate()).parallel();
        }
    }

    public static final class Filter
    extends AbstractLongCollectionView {
        @NotNull
        private final LongCollectionView source;
        @NotNull
        private final LongPredicate predicate;

        public Filter(@NotNull LongCollectionView source, @NotNull LongPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public LongIterator iterator() {
            return this.source.iterator().filter(this.predicate);
        }

        @NotNull
        public LongStream stream() {
            return this.source.stream().filter(this.predicate);
        }

        @NotNull
        public LongStream parallelStream() {
            return this.source.stream().filter(this.predicate).parallel();
        }
    }

    public static final class MapToObj<T>
    extends AbstractCollectionView<T> {
        @NotNull
        private final LongCollectionView source;
        @NotNull
        private final LongFunction<? extends T> mapper;

        public MapToObj(@NotNull LongCollectionView source, @NotNull LongFunction<? extends T> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public Iterator<T> iterator() {
            return this.source.iterator().mapToObj(this.mapper);
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }
    }

    public static final class Mapped
    extends AbstractLongCollectionView {
        @NotNull
        private final LongCollectionView source;
        @NotNull
        private final LongUnaryOperator mapper;

        public Mapped(@NotNull LongCollectionView source, @NotNull LongUnaryOperator mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public LongIterator iterator() {
            return this.iterator().map(this.mapper);
        }

        @NotNull
        public Spliterator.OfLong spliterator() {
            return new MappedSpliterator(this.source.spliterator(), this.mapper);
        }

        @NotNull
        public LongStream stream() {
            return this.source.stream().map(this.mapper);
        }

        @NotNull
        public LongStream parallelStream() {
            return this.source.parallelStream().map(this.mapper);
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }
    }

    public static class Of<C extends LongCollectionLike>
    extends AbstractLongCollectionView {
        @NotNull
        protected final C source;

        public Of(@NotNull C source) {
            this.source = source;
        }

        @NotNull
        public final LongIterator iterator() {
            return this.source.iterator();
        }

        @NotNull
        public final Spliterator.OfLong spliterator() {
            return this.source.spliterator();
        }

        @NotNull
        public final LongStream stream() {
            return this.source.stream();
        }

        @NotNull
        public final LongStream parallelStream() {
            return this.source.parallelStream();
        }

        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        public int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }

        @NotNull
        public LongOption find(@NotNull LongPredicate predicate) {
            return this.source.find(predicate);
        }

        public final boolean contains(long value) {
            return this.source.contains(value);
        }

        public final boolean containsAll(long @NotNull [] values) {
            return this.source.containsAll(values);
        }

        public final boolean containsAll(@NotNull LongTraversable values) {
            return this.source.containsAll(values);
        }

        public final boolean sameElements(@NotNull Iterable<?> other) {
            return this.source.sameElements(other);
        }

        public final boolean anyMatch(@NotNull LongPredicate predicate) {
            return this.source.anyMatch(predicate);
        }

        public final boolean allMatch(@NotNull LongPredicate predicate) {
            return this.source.allMatch(predicate);
        }

        public final boolean noneMatch(@NotNull LongPredicate predicate) {
            return this.source.noneMatch(predicate);
        }

        public final int count(@NotNull LongPredicate predicate) {
            return this.source.count(predicate);
        }

        public final long max() {
            return this.source.max();
        }

        public final long min() {
            return this.source.min();
        }

        public final long @NotNull [] toArray() {
            return this.source.toArray();
        }

        public final void forEach(@NotNull LongConsumer action) {
            this.source.forEach(action);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer) {
            return (A)this.source.joinTo(buffer);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull CharSequence separator) {
            return (A)this.source.joinTo(buffer, separator);
        }

        @NotNull
        public final <A extends Appendable> A joinTo(@NotNull A buffer, @NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix) {
            return (A)this.source.joinTo(buffer, separator, prefix, postfix);
        }

        @NotNull
        public final String joinToString() {
            return this.source.joinToString();
        }

        @NotNull
        public final String joinToString(@NotNull CharSequence separator) {
            return this.source.joinToString(separator);
        }

        @NotNull
        public final String joinToString(@NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix) {
            return this.source.joinToString(separator, prefix, postfix);
        }

        @Override
        public final String toString() {
            return this.joinToString(", ", this.className() + "[", "]");
        }
    }

    public static class Single
    extends AbstractLongCollectionView {
        protected final long value;

        public Single(long value) {
            this.value = value;
        }

        @NotNull
        public final LongIterator iterator() {
            return LongIterator.of((long)this.value);
        }

        public final boolean isEmpty() {
            return false;
        }

        public final int size() {
            return 1;
        }

        public final int knownSize() {
            return 1;
        }

        public void forEach(@NotNull LongConsumer action) {
            action.accept(this.value);
        }
    }
}

