/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive.internal.view;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kala.Conditions;
import kala.collection.AbstractSeqView;
import kala.collection.SeqView;
import kala.collection.base.primitive.AbstractShortIterator;
import kala.collection.base.primitive.ShortArrays;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.base.primitive.ShortTraversable;
import kala.collection.mutable.primitive.MutableShortArrayList;
import kala.collection.primitive.AbstractShortSeqView;
import kala.collection.primitive.IndexedShortSeqLike;
import kala.collection.primitive.ShortSeq;
import kala.collection.primitive.ShortSeqLike;
import kala.collection.primitive.ShortSeqView;
import kala.collection.primitive.internal.view.ShortCollectionViews;
import kala.function.ShortFunction;
import kala.function.ShortPredicate;
import kala.function.ShortUnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class ShortSeqViews {
    public static final ShortSeqView EMPTY = new Empty();

    public static class Empty
    extends ShortCollectionViews.Empty
    implements ShortSeqView {
        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public ShortSeqView reversed() {
            return this;
        }

        @Override
        @NotNull
        public ShortIterator reverseIterator() {
            return ShortIterator.empty();
        }

        @Override
        public short get(int index) {
            throw new IndexOutOfBoundsException("index: " + index);
        }

        @Override
        @NotNull
        public ShortSeqView concat(@NotNull ShortSeqLike other) {
            return other.view();
        }

        @Override
        @NotNull
        public ShortSeqView filter(@NotNull ShortPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public ShortSeqView filterNot(@NotNull ShortPredicate predicate) {
            return this;
        }

        @Override
        @NotNull
        public ShortSeqView map(@NotNull ShortUnaryOperator mapper) {
            return this;
        }

        @Override
        @NotNull
        public <U> SeqView<U> mapToObj(@NotNull ShortFunction<? extends U> mapper) {
            return SeqView.empty();
        }

        @Override
        @NotNull
        public ShortSeqView flatMap(@NotNull ShortFunction<? extends ShortTraversable> mapper) {
            return this;
        }

        @Override
        @NotNull
        public ShortSeqView sorted() {
            return this;
        }
    }

    public static final class Sorted
    extends AbstractShortSeqView {
        private final ShortSeqView source;
        private short[] sorted;

        public Sorted(@NotNull ShortSeqView source) {
            this.source = source;
        }

        private void initSorted() {
            if (this.sorted == null) {
                short[] arr = this.source.toArray();
                ShortArrays.sort((short[])arr);
                this.sorted = arr;
            }
        }

        @NotNull
        public final ShortIterator iterator() {
            this.initSorted();
            return ShortArrays.iterator((short[])this.sorted);
        }

        public final int size() {
            return this.sorted == null ? this.source.size() : this.sorted.length;
        }

        public final int knownSize() {
            return this.sorted == null ? this.source.knownSize() : this.sorted.length;
        }

        @Override
        public final short get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
            this.initSorted();
            try {
                return this.sorted[index];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException(e.getMessage());
            }
        }

        @Override
        @NotNull
        public final ShortSeqView sorted() {
            return this;
        }
    }

    public static class MapToObj<E>
    extends AbstractSeqView<E> {
        @NotNull
        private final ShortSeqView source;
        @NotNull
        private final ShortFunction<? extends E> mapper;

        public MapToObj(@NotNull ShortSeqView source, @NotNull ShortFunction<? extends E> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final Iterator<E> iterator() {
            return this.source.iterator().mapToObj(this.mapper);
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        public boolean isDefinedAt(int index) {
            return this.source.isDefinedAt(index);
        }

        public final E get(int index) {
            return (E)this.mapper.apply(this.source.get(index));
        }
    }

    public static class Mapped
    extends AbstractShortSeqView {
        @NotNull
        private final ShortSeqView source;
        @NotNull
        private final ShortUnaryOperator mapper;

        public Mapped(@NotNull ShortSeqView source, @NotNull ShortUnaryOperator mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final ShortIterator iterator() {
            return this.source.iterator().map(this.mapper);
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public final short get(int index) {
            return this.mapper.applyAsShort(this.source.get(index));
        }
    }

    public static final class FlatMapped
    extends AbstractShortSeqView {
        @NotNull
        private final ShortSeqLike source;
        @NotNull
        private final ShortFunction<? extends ShortTraversable> mapper;

        public FlatMapped(@NotNull ShortSeqLike source, @NotNull ShortFunction<? extends ShortTraversable> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @NotNull
        public final ShortIterator iterator() {
            return ShortIterator.concat(this.source.mapToObj(it -> ((ShortTraversable)this.mapper.apply(it)).iterator()));
        }
    }

    public static final class FilterNot
    extends AbstractShortSeqView {
        @NotNull
        private final ShortSeqView source;
        @NotNull
        private final ShortPredicate predicate;

        public FilterNot(@NotNull ShortSeqView source, @NotNull ShortPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final ShortIterator iterator() {
            return this.source.iterator().filterNot(this.predicate);
        }
    }

    public static final class Filter
    extends AbstractShortSeqView {
        @NotNull
        private final ShortSeqView source;
        @NotNull
        private final ShortPredicate predicate;

        public Filter(@NotNull ShortSeqView source, @NotNull ShortPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public ShortIterator iterator() {
            return this.source.iterator().filter(this.predicate);
        }
    }

    public static class Reversed
    extends AbstractShortSeqView {
        @NotNull
        protected final ShortSeqView source;

        public Reversed(@NotNull ShortSeqView source) {
            this.source = source;
        }

        @NotNull
        public final ShortIterator iterator() {
            return this.source.reverseIterator();
        }

        public final boolean isEmpty() {
            return this.source.isEmpty();
        }

        public final int size() {
            return this.source.size();
        }

        public final int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public final short get(int index) {
            return this.source.get(this.size() - 1 - index);
        }

        @Override
        @NotNull
        public final ShortSeqView reversed() {
            return this.source;
        }

        @Override
        @NotNull
        public final ShortIterator reverseIterator() {
            return this.source.iterator();
        }
    }

    public static class Appended
    extends AbstractShortSeqView {
        @NotNull
        protected final ShortSeqView source;
        protected final short value;

        public Appended(@NotNull ShortSeqView source, short value) {
            this.source = source;
            this.value = value;
        }

        public final int size() {
            return this.source.size() + 1;
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return sks + 1;
        }

        @NotNull
        public final ShortIterator iterator() {
            return this.source.iterator().appended(this.value);
        }
    }

    public static class Prepended
    extends AbstractShortSeqView {
        @NotNull
        private final ShortSeqView source;
        private final short value;

        public Prepended(@NotNull ShortSeqView source, short value) {
            this.source = source;
            this.value = value;
        }

        @NotNull
        public final ShortIterator iterator() {
            return this.source.iterator().prepended(this.value);
        }

        @Override
        public final short get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
            return index == 0 ? this.value : this.source.get(index - 1);
        }

        public final int size() {
            return this.source.size() + 1;
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return sks + 1;
        }
    }

    public static class Concat
    extends AbstractShortSeqView {
        @NotNull
        protected final ShortSeqLike seq1;
        @NotNull
        protected final ShortSeqLike seq2;

        public Concat(@NotNull ShortSeqLike seq1, @NotNull ShortSeqLike seq2) {
            this.seq1 = seq1;
            this.seq2 = seq2;
        }

        @NotNull
        public final ShortIterator iterator() {
            return ShortIterator.concat((ShortIterator)this.seq1.iterator(), (ShortIterator)this.seq2.iterator());
        }

        public final int size() {
            return this.seq1.size() + this.seq2.size();
        }

        public int knownSize() {
            int ks1 = this.seq1.knownSize();
            if (ks1 < 0) {
                return -1;
            }
            int ks2 = this.seq2.knownSize();
            if (ks2 < 0) {
                return -1;
            }
            return ks1 + ks2;
        }
    }

    public static class TakeWhile
    extends AbstractShortSeqView {
        @NotNull
        private final ShortSeqView source;
        @NotNull
        private final ShortPredicate predicate;

        public TakeWhile(@NotNull ShortSeqView source, @NotNull ShortPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final ShortIterator iterator() {
            return this.source.iterator().takeWhile(this.predicate);
        }
    }

    public static class TakeLast
    extends AbstractShortSeqView {
        @NotNull
        protected final ShortSeqView source;
        private final int n;
        private final int delta;

        public TakeLast(@NotNull ShortSeqView source, int n) {
            this.source = source;
            this.n = Integer.max(n, 0);
            this.delta = Integer.max(0, source.size() - Integer.max(0, n));
        }

        @Override
        public final short get(int index) {
            return this.source.get(index + this.delta);
        }

        public final int size() {
            return this.source.size() - this.delta;
        }

        public final int knownSize() {
            int kn = this.source.knownSize();
            return kn >= 0 ? Integer.min(kn, this.n) : -1;
        }

        @NotNull
        public final ShortIterator iterator() {
            int k = this.source.knownSize();
            if (k == 0 || this.n <= 0) {
                return ShortIterator.empty();
            }
            if (this.n == Integer.MAX_VALUE) {
                return this.source.iterator();
            }
            if (k > 0) {
                return this.source.iterator().drop(Integer.max(k - this.n, 0));
            }
            return new AbstractShortIterator(){
                ShortIterator it;
                int len;
                int pos;
                MutableShortArrayList buf;
                {
                    this.it = source.iterator();
                    this.len = -1;
                    this.pos = 0;
                    this.buf = null;
                }

                private void init() {
                    if (this.buf != null) {
                        return;
                    }
                    this.buf = new MutableShortArrayList();
                    this.len = 0;
                    while (this.it.hasNext()) {
                        short next = this.it.nextShort();
                        if (this.pos >= this.buf.size()) {
                            this.buf.append(next);
                        } else {
                            this.buf.set(this.pos, next);
                        }
                        if (++this.pos == n) {
                            this.pos = 0;
                        }
                        ++this.len;
                    }
                    this.it = null;
                    if (this.len > n) {
                        this.len = n;
                    }
                    this.pos -= this.len;
                    if (this.pos < 0) {
                        this.pos += n;
                    }
                }

                public final boolean hasNext() {
                    this.init();
                    return this.len > 0;
                }

                public final short nextShort() {
                    this.init();
                    if (this.len == 0) {
                        throw new NoSuchElementException();
                    }
                    short v = this.buf.get(this.pos);
                    ++this.pos;
                    if (this.pos == n) {
                        this.pos = 0;
                    }
                    --this.len;
                    return v;
                }
            };
        }
    }

    public static class Take
    extends AbstractShortSeqView {
        @NotNull
        protected final ShortSeqView source;
        protected final @Range(from=1L, to=0x7FFFFFFFL) int n;

        public Take(@NotNull ShortSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final ShortIterator iterator() {
            return this.source.iterator().take(this.n);
        }

        public int size() {
            if (this.n <= 0) {
                return 0;
            }
            return Integer.min(this.n, this.source.size());
        }

        public int knownSize() {
            if (this.n <= 0) {
                return 0;
            }
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            return Integer.min(sks, this.n);
        }

        @Override
        @NotNull
        public ShortSeqView take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            if (this.n <= n) {
                return this;
            }
            return new Take(this.source, n);
        }
    }

    public static class DropWhile
    extends AbstractShortSeqView {
        @NotNull
        private final ShortSeqView source;
        @NotNull
        private final ShortPredicate predicate;

        public DropWhile(@NotNull ShortSeqView source, @NotNull ShortPredicate predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @NotNull
        public final ShortIterator iterator() {
            return this.source.iterator().dropWhile(this.predicate);
        }
    }

    public static class DropLast
    extends AbstractShortSeqView {
        @NotNull
        protected final ShortSeqView source;
        private final @Range(from=1L, to=0x7FFFFFFFL) int n;

        public DropLast(@NotNull ShortSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final ShortIterator iterator() {
            int ss = this.source.size();
            if (this.n >= ss) {
                return ShortIterator.empty();
            }
            return this.source.iterator().take(ss - this.n);
        }

        @Override
        public final short get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index(" + index + ") < 0");
            }
            ShortSeqView source = this.source;
            int n = this.n;
            if (n <= 0) {
                return this.source.get(index);
            }
            int size = Integer.max(source.size() - n, 0);
            Conditions.checkElementIndex((int)index, (int)size);
            return this.source.get(index);
        }

        public final int size() {
            return Integer.max(0, this.source.size() - this.n);
        }

        public final int knownSize() {
            int sks = this.source.knownSize();
            if (sks < 0) {
                return -1;
            }
            if (this.n >= sks) {
                return 0;
            }
            return sks - this.n;
        }
    }

    public static class Drop
    extends AbstractShortSeqView {
        @NotNull
        protected final ShortSeqView source;
        protected final int n;

        public Drop(@NotNull ShortSeqView source, @Range(from=1L, to=0x7FFFFFFFL) int n) {
            this.source = source;
            this.n = n;
        }

        @NotNull
        public final ShortIterator iterator() {
            return this.iterator().drop(this.n);
        }

        public final int size() {
            return Integer.max(0, this.source.size() - this.n);
        }

        public int knownSize() {
            int sks = this.source.knownSize();
            return sks < 0 ? -1 : Integer.max(0, sks - this.n);
        }

        @Override
        @NotNull
        public ShortSeqView drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            return this.source.drop(n + this.n);
        }
    }

    public static class Updated
    extends AbstractShortSeqView {
        @NotNull
        private final ShortSeqView source;
        private final int index;
        private final short newValue;

        public Updated(@NotNull ShortSeqView source, int index, short newValue) {
            this.source = source;
            this.index = index;
            this.newValue = newValue;
        }

        @NotNull
        public final ShortIterator iterator() {
            return new AbstractShortIterator(){
                private final ShortIterator it;
                private int i;
                {
                    this.it = source.iterator();
                    this.i = 0;
                }

                public final boolean hasNext() {
                    if (this.it.hasNext()) {
                        return true;
                    }
                    if (index >= this.i) {
                        throw new IndexOutOfBoundsException();
                    }
                    return false;
                }

                public final short nextShort() {
                    short value = this.it.next();
                    if (this.i++ == index) {
                        value = newValue;
                    }
                    return value;
                }
            };
        }

        public final int size() {
            return this.source.size();
        }

        public int knownSize() {
            return this.source.knownSize();
        }

        @Override
        public boolean isDefinedAt(int index) {
            return this.source.isDefinedAt(index);
        }

        @Override
        public final short get(int index) {
            if (index == this.index) {
                return this.newValue;
            }
            return this.source.get(index);
        }
    }

    public static class Slice
    extends AbstractShortSeqView {
        @NotNull
        protected final ShortSeqView source;
        protected final int beginIndex;
        protected final int endIndex;

        public Slice(@NotNull ShortSeqView source, int beginIndex, int endIndex) {
            this.source = source;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @NotNull
        public ShortIterator iterator() {
            return new Itr();
        }

        public boolean isEmpty() {
            return this.beginIndex == this.endIndex;
        }

        public int size() {
            return this.endIndex - this.beginIndex;
        }

        public int knownSize() {
            return this.endIndex - this.beginIndex;
        }

        private final class Itr
        extends AbstractShortIterator {
            private int idx;
            private final ShortIterator it;

            Itr() {
                ShortIterator it = Slice.this.source.iterator();
                for (int i = Slice.this.beginIndex; i > 0; --i) {
                    try {
                        it.next();
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        throw new IndexOutOfBoundsException();
                    }
                }
                this.idx = Slice.this.beginIndex;
                this.it = it;
            }

            public final boolean hasNext() {
                return this.idx < Slice.this.endIndex;
            }

            public final short nextShort() {
                if (this.idx >= Slice.this.endIndex) {
                    throw new NoSuchElementException();
                }
                try {
                    short next = this.it.next();
                    ++this.idx;
                    return next;
                }
                catch (NoSuchElementException e) {
                    throw new IndexOutOfBoundsException();
                }
            }
        }
    }

    public static class WithCachedSize<C extends ShortSeq>
    extends Of<C> {
        protected int cachedSize = -1;

        public WithCachedSize(@NotNull C source) {
            super(source);
        }

        public WithCachedSize(@NotNull C source, int size) {
            super(source);
            this.cachedSize = size;
        }

        @Override
        public boolean isEmpty() {
            int cachedSize = this.cachedSize;
            if (cachedSize == 0) {
                return true;
            }
            if (cachedSize > 0) {
                return false;
            }
            return ((ShortSeq)this.source).isEmpty();
        }

        @Override
        public final int size() {
            int ss;
            if (this.cachedSize >= 0) {
                return this.cachedSize;
            }
            this.cachedSize = ss = ((ShortSeq)this.source).size();
            return ss;
        }

        @Override
        public final int knownSize() {
            if (this.cachedSize >= 0) {
                return this.cachedSize;
            }
            int sks = ((ShortSeq)this.source).knownSize();
            if (sks >= 0) {
                this.cachedSize = sks;
                return sks;
            }
            return -1;
        }
    }

    public static class OfArraySlice
    implements ShortSeqView,
    IndexedShortSeqLike {
        protected final short[] array;
        protected final int beginIndex;
        protected final int endIndex;

        public OfArraySlice(short[] array, int beginIndex, int endIndex) {
            this.array = array;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public ShortIterator iterator() {
            return ShortArrays.iterator((short[])this.array, (int)this.beginIndex, (int)this.endIndex);
        }

        public final int size() {
            return this.endIndex - this.beginIndex;
        }

        public final int beginIndex() {
            return this.beginIndex;
        }

        public final int endIndex() {
            return this.endIndex;
        }

        @Override
        public final short get(int index) {
            Conditions.checkElementIndex((int)index, (int)this.size());
            return this.array[index + this.beginIndex];
        }

        @Override
        @NotNull
        public ShortSeqView slice(int beginIndex, int endIndex) {
            Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size());
            int ns = endIndex - beginIndex;
            switch (ns) {
                case 0: {
                    return EMPTY;
                }
                case 1: {
                    return new Single(this.array[this.beginIndex + beginIndex]);
                }
            }
            return new OfArraySlice(this.array, this.beginIndex + beginIndex, this.beginIndex + endIndex);
        }

        @Override
        @NotNull
        public ShortSeqView drop(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            int size = this.size();
            if (n >= size) {
                return EMPTY;
            }
            return new OfArraySlice(this.array, this.beginIndex + n, this.endIndex);
        }

        @Override
        @NotNull
        public ShortSeqView dropLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return this;
            }
            int size = this.size();
            if (n >= size) {
                return EMPTY;
            }
            return new OfArraySlice(this.array, this.beginIndex, this.endIndex - n);
        }

        @Override
        @NotNull
        public ShortSeqView take(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            int size = this.size();
            if (n >= size) {
                return this;
            }
            if (n == 1) {
                return new Single(this.array[this.beginIndex]);
            }
            return new OfArraySlice(this.array, this.beginIndex, this.beginIndex + n);
        }

        @Override
        @NotNull
        public ShortSeqView takeLast(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == 0) {
                return EMPTY;
            }
            int size = this.size();
            if (n >= size) {
                return this;
            }
            if (n == 1) {
                return new Single(this.array[this.beginIndex]);
            }
            return new OfArraySlice(this.array, this.endIndex - n, this.endIndex);
        }
    }

    public static class Of<C extends ShortSeqLike>
    extends ShortCollectionViews.Of<C>
    implements ShortSeqView {
        public Of(@NotNull C source) {
            super(source);
        }

        public boolean supportsFastRandomAccess() {
            return ((ShortSeqLike)this.source).supportsFastRandomAccess();
        }

        @Override
        public short get(int index) {
            return ((ShortSeqLike)this.source).get(index);
        }

        @Override
        public boolean isDefinedAt(int index) {
            return ((ShortSeqLike)this.source).isDefinedAt(index);
        }

        @Override
        public int indexOf(short value) {
            return ((ShortSeqLike)this.source).indexOf(value);
        }

        @Override
        public int indexOf(short value, int from) {
            return ((ShortSeqLike)this.source).indexOf(value, from);
        }

        @Override
        public int indexWhere(@NotNull ShortPredicate predicate) {
            return ((ShortSeqLike)this.source).indexWhere(predicate);
        }

        @Override
        public int indexWhere(@NotNull ShortPredicate predicate, int from) {
            return ((ShortSeqLike)this.source).indexWhere(predicate, from);
        }

        @Override
        public int lastIndexOf(short value) {
            return ((ShortSeqLike)this.source).lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(short value, int end) {
            return ((ShortSeqLike)this.source).lastIndexOf(value, end);
        }

        @Override
        public int lastIndexWhere(@NotNull ShortPredicate predicate) {
            return ((ShortSeqLike)this.source).lastIndexWhere(predicate);
        }

        @Override
        public int lastIndexWhere(@NotNull ShortPredicate predicate, int end) {
            return ((ShortSeqLike)this.source).lastIndexWhere(predicate, end);
        }

        @Override
        @NotNull
        public ShortIterator reverseIterator() {
            return ((ShortSeqLike)this.source).reverseIterator();
        }
    }

    public static class Single
    extends ShortCollectionViews.Single
    implements ShortSeqView {
        public Single(short value) {
            super(value);
        }

        public boolean supportsFastRandomAccess() {
            return true;
        }

        @Override
        @NotNull
        public ShortSeqView reversed() {
            return this;
        }

        @Override
        @NotNull
        public final ShortIterator reverseIterator() {
            return ShortIterator.of((short)this.value);
        }

        @Override
        public short get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this.value;
        }

        @Override
        @NotNull
        public ShortSeqView updated(int index, short newValue) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return new Single(newValue);
        }
    }
}

