/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.util.Objects;
import kala.collection.base.AnyTraversable;
import kala.collection.base.primitive.ShortTraversable;
import kala.collection.factory.primitive.ShortCollectionFactory;
import kala.collection.immutable.primitive.ImmutableShortCollection;
import kala.collection.primitive.AbstractShortCollection;
import kala.function.ShortFunction;
import kala.function.ShortPredicate;
import kala.function.ShortUnaryOperator;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractImmutableShortCollection
extends AbstractShortCollection
implements ImmutableShortCollection {
    static <T, Builder> T filter(@NotNull ImmutableShortCollection collection, @NotNull ShortPredicate predicate, @NotNull ShortCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        collection.forEach(e -> {
            if (predicate.test(e)) {
                factory.addToBuilder(builder, e);
            }
        });
        return (T)factory.build(builder);
    }

    static <T, Builder> T filterNot(@NotNull ImmutableShortCollection collection, @NotNull ShortPredicate predicate, @NotNull ShortCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(predicate);
        Object builder = factory.newBuilder();
        collection.forEach(e -> {
            if (!predicate.test(e)) {
                factory.addToBuilder(builder, e);
            }
        });
        return (T)factory.build(builder);
    }

    static <U, T, Builder> T map(@NotNull ImmutableShortCollection collection, @NotNull ShortUnaryOperator mapper, @NotNull ShortCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(mapper);
        Object builder = factory.newBuilder();
        factory.sizeHint(builder, (AnyTraversable)collection);
        collection.forEach(e -> factory.addToBuilder(builder, mapper.applyAsShort(e)));
        return (T)factory.build(builder);
    }

    static <T, Builder> T flatMap(@NotNull ImmutableShortCollection collection, @NotNull ShortFunction<? extends ShortTraversable> mapper, @NotNull ShortCollectionFactory<Builder, ? extends T> factory) {
        Objects.requireNonNull(mapper);
        Object builder = factory.newBuilder();
        collection.forEach(e -> {
            ShortTraversable us = (ShortTraversable)mapper.apply(e);
            factory.sizeHint(builder, (AnyTraversable)us);
            us.forEach(u -> factory.addToBuilder(builder, u));
        });
        return (T)factory.build(builder);
    }
}

