/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import kala.collection.base.primitive.ByteArrays;
import kala.collection.base.primitive.ByteIterator;
import kala.collection.base.primitive.ByteTraversable;
import kala.collection.factory.primitive.ByteCollectionFactory;
import kala.collection.immutable.primitive.ImmutableByteSeq;
import kala.collection.mutable.primitive.MutableByteArrayList;
import kala.collection.primitive.ByteArraySeq;
import kala.function.ByteSupplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ImmutableByteArray
extends ByteArraySeq
implements ImmutableByteSeq,
Serializable {
    private static final long serialVersionUID = 1845940935381169058L;
    public static final ImmutableByteArray EMPTY = new ImmutableByteArray(ByteArrays.EMPTY);
    private static final Factory FACTORY = new Factory();

    ImmutableByteArray(byte @NotNull [] elements) {
        super(elements);
    }

    @NotNull
    public static ByteCollectionFactory<?, ? extends ImmutableByteArray> factory() {
        return FACTORY;
    }

    @NotNull
    public static ImmutableByteArray empty() {
        return EMPTY;
    }

    @NotNull
    public static ImmutableByteArray of() {
        return ImmutableByteArray.empty();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ImmutableByteArray of(byte value1) {
        return new ImmutableByteArray(new byte[]{value1});
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static ImmutableByteArray of(byte value1, byte value2) {
        return new ImmutableByteArray(new byte[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableByteArray of(byte value1, byte value2, byte value3) {
        return new ImmutableByteArray(new byte[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableByteArray of(byte value1, byte value2, byte value3, byte value4) {
        return new ImmutableByteArray(new byte[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableByteArray of(byte value1, byte value2, byte value3, byte value4, byte value5) {
        return new ImmutableByteArray(new byte[]{value1, value2, value3, value4, value5});
    }

    @Contract(pure=true)
    @NotNull
    public static ImmutableByteArray of(byte ... values) {
        return ImmutableByteArray.from(values);
    }

    @Contract(pure=true)
    @NotNull
    public static ImmutableByteArray from(byte @NotNull [] values) {
        return values.length == 0 ? ImmutableByteArray.empty() : new ImmutableByteArray((byte[])values.clone());
    }

    @NotNull
    public static ImmutableByteArray from(@NotNull ByteTraversable values) {
        if (values instanceof ImmutableByteArray) {
            return (ImmutableByteArray)values;
        }
        if (values.isEmpty()) {
            return ImmutableByteArray.empty();
        }
        byte[] arr = values.toArray();
        return arr.length == 0 ? ImmutableByteArray.empty() : new ImmutableByteArray(arr);
    }

    @NotNull
    public static ImmutableByteArray from(@NotNull ByteIterator it) {
        if (!it.hasNext()) {
            return ImmutableByteArray.empty();
        }
        return new ImmutableByteArray(it.toArray());
    }

    @NotNull
    public static ImmutableByteArray fill(int n, byte value) {
        if (n <= 0) {
            return ImmutableByteArray.empty();
        }
        byte[] ans = new byte[n];
        if (value != 0) {
            Arrays.fill(ans, value);
        }
        return new ImmutableByteArray(ans);
    }

    @NotNull
    public static ImmutableByteArray fill(int n, @NotNull ByteSupplier supplier) {
        if (n <= 0) {
            return ImmutableByteArray.empty();
        }
        byte[] ans = new byte[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsByte();
        }
        return new ImmutableByteArray(ans);
    }

    byte @NotNull [] getArray() {
        return this.elements;
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableByteArray";
    }

    private static final class Factory
    implements ByteCollectionFactory<MutableByteArrayList, ImmutableByteArray> {
        private Factory() {
        }

        public ImmutableByteArray empty() {
            return ImmutableByteArray.empty();
        }

        public ImmutableByteArray from(byte @NotNull [] values) {
            return ImmutableByteArray.from(values);
        }

        public ImmutableByteArray from(@NotNull ByteTraversable values) {
            return ImmutableByteArray.from(values);
        }

        public ImmutableByteArray from(@NotNull ByteIterator it) {
            return ImmutableByteArray.from(it);
        }

        public ImmutableByteArray fill(int n, byte value) {
            return ImmutableByteArray.fill(n, value);
        }

        public ImmutableByteArray fill(int n, @NotNull ByteSupplier supplier) {
            return ImmutableByteArray.fill(n, supplier);
        }

        public MutableByteArrayList newBuilder() {
            return new MutableByteArrayList();
        }

        public void addToBuilder(@NotNull MutableByteArrayList buffer, byte value) {
            buffer.append(value);
        }

        public MutableByteArrayList mergeBuilder(@NotNull MutableByteArrayList builder1, @NotNull MutableByteArrayList builder2) {
            builder1.appendAll(builder2);
            return builder1;
        }

        public void sizeHint(@NotNull MutableByteArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public ImmutableByteArray build(@NotNull MutableByteArrayList buffer) {
            return new ImmutableByteArray(buffer.toArray());
        }
    }

    public static final class Unsafe {
        private Unsafe() {
        }

        @Contract(value="_ -> new")
        @NotNull
        public static ImmutableByteArray wrap(byte @NotNull [] array) {
            Objects.requireNonNull(array);
            return new ImmutableByteArray(array);
        }
    }
}

