/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.DoubleSupplier;
import kala.collection.base.primitive.DoubleArrays;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.base.primitive.DoubleTraversable;
import kala.collection.factory.primitive.DoubleCollectionFactory;
import kala.collection.immutable.primitive.ImmutableDoubleSeq;
import kala.collection.mutable.primitive.MutableDoubleArrayList;
import kala.collection.primitive.DoubleArraySeq;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ImmutableDoubleArray
extends DoubleArraySeq
implements ImmutableDoubleSeq,
Serializable {
    private static final long serialVersionUID = 1845940935381169058L;
    public static final ImmutableDoubleArray EMPTY = new ImmutableDoubleArray(DoubleArrays.EMPTY);
    private static final Factory FACTORY = new Factory();

    ImmutableDoubleArray(double @NotNull [] elements) {
        super(elements);
    }

    @NotNull
    public static DoubleCollectionFactory<?, ? extends ImmutableDoubleArray> factory() {
        return FACTORY;
    }

    @NotNull
    public static ImmutableDoubleArray empty() {
        return EMPTY;
    }

    @NotNull
    public static ImmutableDoubleArray of() {
        return ImmutableDoubleArray.empty();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ImmutableDoubleArray of(double value1) {
        return new ImmutableDoubleArray(new double[]{value1});
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static ImmutableDoubleArray of(double value1, double value2) {
        return new ImmutableDoubleArray(new double[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableDoubleArray of(double value1, double value2, double value3) {
        return new ImmutableDoubleArray(new double[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableDoubleArray of(double value1, double value2, double value3, double value4) {
        return new ImmutableDoubleArray(new double[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static ImmutableDoubleArray of(double value1, double value2, double value3, double value4, double value5) {
        return new ImmutableDoubleArray(new double[]{value1, value2, value3, value4, value5});
    }

    @Contract(pure=true)
    @NotNull
    public static ImmutableDoubleArray of(double ... values) {
        return ImmutableDoubleArray.from(values);
    }

    @Contract(pure=true)
    @NotNull
    public static ImmutableDoubleArray from(double @NotNull [] values) {
        return values.length == 0 ? ImmutableDoubleArray.empty() : new ImmutableDoubleArray((double[])values.clone());
    }

    @NotNull
    public static ImmutableDoubleArray from(@NotNull DoubleTraversable values) {
        if (values instanceof ImmutableDoubleArray) {
            return (ImmutableDoubleArray)values;
        }
        if (values.isEmpty()) {
            return ImmutableDoubleArray.empty();
        }
        double[] arr = values.toArray();
        return arr.length == 0 ? ImmutableDoubleArray.empty() : new ImmutableDoubleArray(arr);
    }

    @NotNull
    public static ImmutableDoubleArray from(@NotNull DoubleIterator it) {
        if (!it.hasNext()) {
            return ImmutableDoubleArray.empty();
        }
        return new ImmutableDoubleArray(it.toArray());
    }

    @NotNull
    public static ImmutableDoubleArray fill(int n, double value) {
        if (n <= 0) {
            return ImmutableDoubleArray.empty();
        }
        double[] ans = new double[n];
        if (value != 0.0) {
            Arrays.fill(ans, value);
        }
        return new ImmutableDoubleArray(ans);
    }

    @NotNull
    public static ImmutableDoubleArray fill(int n, @NotNull DoubleSupplier supplier) {
        if (n <= 0) {
            return ImmutableDoubleArray.empty();
        }
        double[] ans = new double[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsDouble();
        }
        return new ImmutableDoubleArray(ans);
    }

    double @NotNull [] getArray() {
        return this.elements;
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableDoubleArray";
    }

    @NotNull
    public Spliterator.OfDouble spliterator() {
        return Spliterators.spliterator(this.elements, 1024);
    }

    private static final class Factory
    implements DoubleCollectionFactory<MutableDoubleArrayList, ImmutableDoubleArray> {
        private Factory() {
        }

        public ImmutableDoubleArray empty() {
            return ImmutableDoubleArray.empty();
        }

        public ImmutableDoubleArray from(double @NotNull [] values) {
            return ImmutableDoubleArray.from(values);
        }

        public ImmutableDoubleArray from(@NotNull DoubleTraversable values) {
            return ImmutableDoubleArray.from(values);
        }

        public ImmutableDoubleArray from(@NotNull DoubleIterator it) {
            return ImmutableDoubleArray.from(it);
        }

        public ImmutableDoubleArray fill(int n, double value) {
            return ImmutableDoubleArray.fill(n, value);
        }

        public ImmutableDoubleArray fill(int n, @NotNull DoubleSupplier supplier) {
            return ImmutableDoubleArray.fill(n, supplier);
        }

        public MutableDoubleArrayList newBuilder() {
            return new MutableDoubleArrayList();
        }

        public void addToBuilder(@NotNull MutableDoubleArrayList buffer, double value) {
            buffer.append(value);
        }

        public MutableDoubleArrayList mergeBuilder(@NotNull MutableDoubleArrayList builder1, @NotNull MutableDoubleArrayList builder2) {
            builder1.appendAll(builder2);
            return builder1;
        }

        public void sizeHint(@NotNull MutableDoubleArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public ImmutableDoubleArray build(@NotNull MutableDoubleArrayList buffer) {
            return new ImmutableDoubleArray(buffer.toArray());
        }
    }

    public static final class Unsafe {
        private Unsafe() {
        }

        @Contract(value="_ -> new")
        @NotNull
        public static ImmutableDoubleArray wrap(double @NotNull [] array) {
            Objects.requireNonNull(array);
            return new ImmutableDoubleArray(array);
        }
    }
}

