/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.io.Serializable;
import kala.collection.base.primitive.BooleanIterator;
import kala.collection.base.primitive.BooleanTraversable;
import kala.collection.factory.primitive.BooleanCollectionFactory;
import kala.collection.mutable.primitive.AbstractMutableBooleanSet;
import kala.collection.mutable.primitive.AbstractMutableBooleanSetFactory;
import kala.collection.mutable.primitive.MutableBooleanSet;
import kala.function.BooleanConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

final class DefaultMutableBooleanSet
extends AbstractMutableBooleanSet
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final Factory FACTORY = new Factory();
    private boolean containsFalse = false;
    private boolean containsTrue = false;

    DefaultMutableBooleanSet() {
    }

    @Contract(pure=true)
    @NotNull
    static BooleanCollectionFactory<?, DefaultMutableBooleanSet> factory() {
        return FACTORY;
    }

    @Contract(value="-> new")
    @NotNull
    static MutableBooleanSet create() {
        return new DefaultMutableBooleanSet();
    }

    @Contract(value="-> new")
    @NotNull
    static MutableBooleanSet of() {
        return new DefaultMutableBooleanSet();
    }

    @Contract(value="_ -> new")
    @NotNull
    static MutableBooleanSet of(boolean value1) {
        DefaultMutableBooleanSet res = new DefaultMutableBooleanSet();
        res.add(value1);
        return res;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    static MutableBooleanSet of(boolean value1, boolean value2) {
        DefaultMutableBooleanSet res = new DefaultMutableBooleanSet();
        res.add(value1);
        res.add(value2);
        return res;
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    static MutableBooleanSet of(boolean value1, boolean value2, boolean value3) {
        DefaultMutableBooleanSet res = new DefaultMutableBooleanSet();
        res.add(value1);
        res.add(value2);
        res.add(value3);
        return res;
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    static MutableBooleanSet of(boolean value1, boolean value2, boolean value3, boolean value4) {
        DefaultMutableBooleanSet res = new DefaultMutableBooleanSet();
        res.add(value1);
        res.add(value2);
        res.add(value3);
        res.add(value4);
        return res;
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    static MutableBooleanSet of(boolean value1, boolean value2, boolean value3, boolean value4, boolean value5) {
        DefaultMutableBooleanSet res = new DefaultMutableBooleanSet();
        res.add(value1);
        res.add(value2);
        res.add(value3);
        res.add(value4);
        res.add(value5);
        return res;
    }

    @Contract(value="_ -> new")
    @NotNull
    static MutableBooleanSet of(boolean ... values) {
        return DefaultMutableBooleanSet.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    static MutableBooleanSet from(boolean @NotNull [] values) {
        DefaultMutableBooleanSet res = new DefaultMutableBooleanSet();
        res.addAll(values);
        return res;
    }

    @Contract(value="_ -> new")
    @NotNull
    static MutableBooleanSet from(@NotNull BooleanTraversable values) {
        DefaultMutableBooleanSet res = new DefaultMutableBooleanSet();
        res.addAll(values);
        return res;
    }

    @Contract(value="_ -> new")
    @NotNull
    static MutableBooleanSet from(@NotNull BooleanIterator it) {
        DefaultMutableBooleanSet res = new DefaultMutableBooleanSet();
        while (it.hasNext()) {
            res.add(it.nextBoolean());
        }
        return res;
    }

    @Override
    public boolean containsFalse() {
        return this.containsFalse;
    }

    @Override
    public boolean containsTrue() {
        return this.containsTrue;
    }

    @Override
    public boolean add(boolean value) {
        if (!value) {
            if (this.containsFalse) {
                return false;
            }
            this.containsFalse = true;
        } else {
            if (this.containsTrue) {
                return false;
            }
            this.containsTrue = true;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull BooleanTraversable values) {
        boolean ht = this.containsTrue;
        boolean hf = this.containsFalse;
        if (ht && hf) {
            return false;
        }
        BooleanIterator it = values.iterator();
        while (it.hasNext()) {
            if (it.nextBoolean()) {
                ht = true;
            } else {
                hf = true;
            }
            if (!ht || !hf) continue;
            return true;
        }
        boolean res = false;
        if (ht != this.containsTrue) {
            this.containsTrue = ht;
            res = true;
        }
        if (hf != this.containsFalse) {
            this.containsFalse = hf;
            res = true;
        }
        return res;
    }

    @Override
    public boolean remove(boolean value) {
        if (!value) {
            if (!this.containsFalse) {
                return false;
            }
            this.containsFalse = false;
        } else {
            if (!this.containsTrue) {
                return false;
            }
            this.containsTrue = false;
        }
        return true;
    }

    @Override
    public boolean removeAll(@NotNull BooleanTraversable values) {
        boolean ht = this.containsTrue;
        boolean hf = this.containsFalse;
        if (!ht && !hf) {
            return false;
        }
        BooleanIterator it = values.iterator();
        while (it.hasNext()) {
            if (it.nextBoolean()) {
                ht = false;
            } else {
                hf = false;
            }
            if (ht || hf) continue;
            this.clear();
            return true;
        }
        boolean res = false;
        if (ht != this.containsTrue) {
            this.containsTrue = ht;
            res = true;
        }
        if (hf != this.containsFalse) {
            this.containsFalse = hf;
            res = true;
        }
        return res;
    }

    @Override
    public void clear() {
        this.containsFalse = false;
        this.containsTrue = false;
    }

    public void forEach(@NotNull BooleanConsumer action) {
        if (this.containsFalse) {
            action.accept(false);
        }
        if (this.containsTrue) {
            action.accept(true);
        }
    }

    private static final class Factory
    extends AbstractMutableBooleanSetFactory<DefaultMutableBooleanSet> {
        private Factory() {
        }

        public DefaultMutableBooleanSet newBuilder() {
            return new DefaultMutableBooleanSet();
        }
    }
}

