/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import kala.collection.base.primitive.ByteIterator;
import kala.collection.base.primitive.ByteTraversable;
import kala.collection.factory.primitive.ByteCollectionFactory;
import kala.collection.mutable.primitive.AbstractMutableByteSetFactory;
import kala.collection.mutable.primitive.MutableByteSet;
import kala.collection.primitive.AbstractDefaultByteSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

final class DefaultMutableByteSet
extends AbstractDefaultByteSet
implements MutableByteSet {
    private static final long serialVersionUID = 6028841354144450491L;
    private static final Factory FACTORY = new Factory();

    DefaultMutableByteSet() {
    }

    @Contract(pure=true)
    @NotNull
    static ByteCollectionFactory<?, DefaultMutableByteSet> factory() {
        return FACTORY;
    }

    @Contract(value="-> new")
    @NotNull
    static DefaultMutableByteSet create() {
        return new DefaultMutableByteSet();
    }

    @Contract(value="-> new")
    @NotNull
    static DefaultMutableByteSet of() {
        return new DefaultMutableByteSet();
    }

    @Contract(value="_ -> new")
    @NotNull
    static DefaultMutableByteSet of(byte value1) {
        DefaultMutableByteSet res = new DefaultMutableByteSet();
        res.add(value1);
        return res;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    static DefaultMutableByteSet of(byte value1, byte value2) {
        DefaultMutableByteSet res = new DefaultMutableByteSet();
        res.add(value1);
        res.add(value2);
        return res;
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    static DefaultMutableByteSet of(byte value1, byte value2, byte value3) {
        DefaultMutableByteSet res = new DefaultMutableByteSet();
        res.add(value1);
        res.add(value2);
        res.add(value3);
        return res;
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    static DefaultMutableByteSet of(byte value1, byte value2, byte value3, byte value4) {
        DefaultMutableByteSet res = new DefaultMutableByteSet();
        res.add(value1);
        res.add(value2);
        res.add(value3);
        res.add(value4);
        return res;
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    static DefaultMutableByteSet of(byte value1, byte value2, byte value3, byte value4, byte value5) {
        DefaultMutableByteSet res = new DefaultMutableByteSet();
        res.add(value1);
        res.add(value2);
        res.add(value3);
        res.add(value4);
        res.add(value5);
        return res;
    }

    @Contract(value="_ -> new")
    @NotNull
    static DefaultMutableByteSet of(byte ... values) {
        return DefaultMutableByteSet.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    static DefaultMutableByteSet from(byte @NotNull [] values) {
        DefaultMutableByteSet res = new DefaultMutableByteSet();
        for (byte value : values) {
            res.add(value);
        }
        return res;
    }

    @Contract(value="_ -> new")
    @NotNull
    static DefaultMutableByteSet from(@NotNull ByteTraversable values) {
        return DefaultMutableByteSet.from(values.iterator());
    }

    @Contract(value="_ -> new")
    @NotNull
    static DefaultMutableByteSet from(@NotNull ByteIterator it) {
        DefaultMutableByteSet res = new DefaultMutableByteSet();
        while (it.hasNext()) {
            res.add(it.nextByte());
        }
        return res;
    }

    @Override
    public boolean add(byte value) {
        long bits;
        int v = value + 128;
        int bitsNumber = v / 64;
        int bitOffset = v % 64;
        switch (bitsNumber) {
            case 0: {
                bits = this.bits0;
                break;
            }
            case 1: {
                bits = this.bits1;
                break;
            }
            case 2: {
                bits = this.bits2;
                break;
            }
            case 3: {
                bits = this.bits3;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        long newBits = bits | 1L << bitOffset;
        if (newBits == bits) {
            return false;
        }
        switch (bitsNumber) {
            case 0: {
                this.bits0 = newBits;
                break;
            }
            case 1: {
                this.bits1 = newBits;
                break;
            }
            case 2: {
                this.bits2 = newBits;
                break;
            }
            case 3: {
                this.bits3 = newBits;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(byte value) {
        long bits;
        int v = value + 128;
        int bitsNumber = v / 64;
        int bitOffset = v % 64;
        switch (bitsNumber) {
            case 0: {
                bits = this.bits0;
                break;
            }
            case 1: {
                bits = this.bits1;
                break;
            }
            case 2: {
                bits = this.bits2;
                break;
            }
            case 3: {
                bits = this.bits3;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        long newBits = bits & (1L << bitOffset ^ 0xFFFFFFFFFFFFFFFFL);
        if (newBits == bits) {
            return false;
        }
        switch (bitsNumber) {
            case 0: {
                this.bits0 = newBits;
                break;
            }
            case 1: {
                this.bits1 = newBits;
                break;
            }
            case 2: {
                this.bits2 = newBits;
                break;
            }
            case 3: {
                this.bits3 = newBits;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        --this.size;
        return true;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.bits0 = 0L;
        this.bits1 = 0L;
        this.bits2 = 0L;
        this.bits3 = 0L;
    }

    private static final class Factory
    extends AbstractMutableByteSetFactory<DefaultMutableByteSet> {
        private Factory() {
        }

        public DefaultMutableByteSet newBuilder() {
            return new DefaultMutableByteSet();
        }
    }
}

