/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.NoSuchElementException;
import java.util.Objects;
import kala.Conditions;
import kala.collection.base.primitive.CharGrowable;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.collection.factory.primitive.CharCollectionFactory;
import kala.collection.mutable.primitive.MutableCharArrayList;
import kala.collection.mutable.primitive.MutableCharListIterator;
import kala.collection.mutable.primitive.MutableCharSeq;
import kala.collection.mutable.primitive.MutablePrimitiveList;
import kala.collection.primitive.CharArraySeq;
import kala.collection.primitive.CharSeq;
import kala.collection.primitive.internal.CharSeqIterators;
import kala.control.primitive.CharOption;
import kala.function.CharPredicate;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MutableCharList
extends MutablePrimitiveList<Character>,
MutableCharSeq,
CharGrowable {
    @NotNull
    public static CharCollectionFactory<?, MutableCharList> factory() {
        return CharCollectionFactory.narrow(MutableCharArrayList.factory());
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableCharList create() {
        return MutableCharArrayList.create();
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableCharList of() {
        return MutableCharArrayList.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableCharList of(char value1) {
        return MutableCharArrayList.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableCharList of(char value1, char value2) {
        return MutableCharArrayList.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableCharList of(char value1, char value2, char value3) {
        return MutableCharArrayList.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableCharList of(char value1, char value2, char value3, char value4) {
        return MutableCharArrayList.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableCharList of(char value1, char value2, char value3, char value4, char value5) {
        return MutableCharArrayList.of(value1, value2, value3, value4, value5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableCharList of(char ... values) {
        return MutableCharArrayList.of(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableCharList from(char @NotNull [] values) {
        return MutableCharArrayList.from(values);
    }

    @NotNull
    public static MutableCharList from(@NotNull CharTraversable values) {
        return MutableCharArrayList.from(values);
    }

    @NotNull
    public static MutableCharList from(@NotNull CharIterator it) {
        return MutableCharArrayList.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableCharList";
    }

    @NotNull
    default public CharCollectionFactory<?, ? extends MutableCharList> iterableFactory() {
        return MutableCharList.factory();
    }

    @Override
    @NotNull
    default public MutableCharListIterator seqIterator() {
        return this.seqIterator(0);
    }

    @Override
    @NotNull
    default public MutableCharListIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new CharSeqIterators.DefaultMutableCharListIterator<MutableCharList>(this, index);
    }

    @Contract(mutates="this")
    public void append(@Flow(targetIsContainer=true) char var1);

    @Contract(mutates="this")
    default public void appendAll(@Flow(sourceIsContainer=true, targetIsContainer=true) char @NotNull [] values) {
        int length = values.length;
        if (length != 0) {
            if (length == 1) {
                this.append(values[0]);
            } else {
                this.appendAll(CharArraySeq.wrap(values));
            }
        }
    }

    @Contract(mutates="this")
    default public void appendAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) CharTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            for (char e : this.toArray()) {
                this.append(e);
            }
        } else {
            values.forEach(this::append);
        }
    }

    default public void plusAssign(char value) {
        this.append(value);
    }

    default public void plusAssign(char @NotNull [] values) {
        this.appendAll(values);
    }

    default public void plusAssign(@NotNull CharTraversable values) {
        this.appendAll(values);
    }

    @Contract(mutates="this")
    public void prepend(char var1);

    @Contract(mutates="this")
    default public void prependAll(@Flow(sourceIsContainer=true, targetIsContainer=true) char @NotNull [] values) {
        this.prependAll(CharArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public void prependAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) CharTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            char[] arr = values.toArray();
            for (int i = arr.length - 1; i >= 0; --i) {
                this.prepend(arr[i]);
            }
            return;
        }
        if (values instanceof CharSeq && ((CharSeq)values).supportsFastRandomAccess()) {
            CharSeq seq = (CharSeq)values;
            int s = seq.size();
            for (int i = s - 1; i >= 0; --i) {
                this.prepend(seq.get(i));
            }
            return;
        }
        char[] cv = values.toArray();
        for (int i = cv.length - 1; i >= 0; --i) {
            this.prepend(cv[i]);
        }
    }

    @Contract(mutates="this")
    public void insert(int var1, @Flow(targetIsContainer=true) char var2);

    @Contract(mutates="this")
    default public void insertAll(int index, @Flow(sourceIsContainer=true, targetIsContainer=true) char @NotNull [] values) {
        this.insertAll(index, CharArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public void insertAll(int index, @NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) CharTraversable values) {
        char[] valuesArray;
        Objects.requireNonNull(values);
        if (this.isEmpty() && index != 0) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        for (char e : valuesArray = values.toArray()) {
            this.insert(index++, e);
        }
    }

    @Contract(mutates="this")
    @Flow(sourceIsContainer=true)
    public char removeAt(int var1);

    default public void removeInRange(int beginIndex, int endIndex) {
        int size = this.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int rangeLength = endIndex - beginIndex;
        if (rangeLength == 0) {
            return;
        }
        if (rangeLength == size) {
            this.clear();
            return;
        }
        for (int i = 0; i < rangeLength; ++i) {
            this.removeAt(beginIndex);
        }
    }

    @Contract(mutates="this")
    default public char removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Seq is empty");
        }
        return this.removeAt(0);
    }

    @Contract(mutates="this")
    @Nullable
    default public Character removeFirstOrNull() {
        return this.isEmpty() ? null : Character.valueOf(this.removeAt(0));
    }

    @Contract(mutates="this")
    @NotNull
    default public CharOption removeFirstOption() {
        return this.isEmpty() ? CharOption.none() : CharOption.some((char)this.removeAt(0));
    }

    @Contract(mutates="this")
    default public char removeLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException("Seq is empty");
        }
        return this.removeAt(size - 1);
    }

    @Contract(mutates="this")
    @Nullable
    default public char removeLastOrNull() {
        int size = this.size();
        return (size == 0 ? null : Character.valueOf(this.removeAt(size - 1))).charValue();
    }

    @Contract(mutates="this")
    @NotNull
    default public CharOption removeLastOption() {
        int size = this.size();
        return size == 0 ? CharOption.none() : CharOption.some((char)this.removeAt(size - 1));
    }

    @Contract(mutates="this")
    default public boolean removeIf(@NotNull CharPredicate predicate) {
        MutableCharListIterator it = this.seqIterator();
        boolean changed = false;
        while (it.hasNext()) {
            char value = it.nextChar();
            if (!predicate.test(value)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Deprecated
    default public boolean removeAll(@NotNull CharPredicate predicate) {
        return this.removeIf(predicate);
    }

    @Contract(mutates="this")
    default public boolean retainIf(@NotNull CharPredicate predicate) {
        MutableCharListIterator it = this.seqIterator();
        boolean changed = false;
        while (it.hasNext()) {
            char value = it.nextChar();
            if (predicate.test(value)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Deprecated
    @Contract(mutates="this")
    default public boolean retainAll(@NotNull CharPredicate predicate) {
        return this.retainIf(predicate);
    }

    @Contract(mutates="this")
    public void clear();

    @Contract(mutates="this")
    default public void dropInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return;
        }
        MutableCharListIterator it = this.seqIterator();
        for (int i = 0; i < n && it.hasNext(); ++i) {
            it.nextChar();
            it.remove();
        }
    }

    @Contract(mutates="this")
    default public void takeInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            this.clear();
            return;
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0 && n >= knownSize) {
            return;
        }
        MutableCharListIterator it = this.seqIterator(n);
        while (it.hasNext()) {
            it.nextChar();
            it.remove();
        }
    }

    @Contract(mutates="this")
    default public void filterInPlace(@NotNull CharPredicate predicate) {
        this.retainAll(predicate);
    }

    @Contract(mutates="this")
    default public void filterNotInPlace(@NotNull CharPredicate predicate) {
        this.removeAll(predicate);
    }
}

