/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import kala.collection.base.primitive.DoubleArrays;
import kala.collection.base.primitive.DoubleIterator;
import kala.collection.base.primitive.DoubleTraversable;
import kala.collection.factory.primitive.DoubleCollectionFactory;
import kala.collection.mutable.primitive.MutableDoubleArrayList;
import kala.collection.mutable.primitive.MutableDoubleSeq;
import kala.collection.primitive.DoubleArraySeq;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableDoubleArray
extends DoubleArraySeq
implements MutableDoubleSeq,
Serializable {
    private static final long serialVersionUID = 8060307722127719792L;
    public static final MutableDoubleArray EMPTY = new MutableDoubleArray(DoubleArrays.EMPTY);
    private static final Factory FACTORY = new Factory();

    MutableDoubleArray(double @NotNull [] array) {
        super(array);
    }

    @NotNull
    public static DoubleCollectionFactory<?, MutableDoubleArray> factory() {
        return FACTORY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableDoubleArray create(int size) {
        return new MutableDoubleArray(new double[size]);
    }

    @NotNull
    public static MutableDoubleArray empty() {
        return EMPTY;
    }

    @NotNull
    public static MutableDoubleArray of() {
        return EMPTY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableDoubleArray of(double value1) {
        return new MutableDoubleArray(new double[]{value1});
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableDoubleArray of(double value1, double value2) {
        return new MutableDoubleArray(new double[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableDoubleArray of(double value1, double value2, double value3) {
        return new MutableDoubleArray(new double[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableDoubleArray of(double value1, double value2, double value3, double value4) {
        return new MutableDoubleArray(new double[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableDoubleArray of(double value1, double value2, double value3, double value4, double value5) {
        return new MutableDoubleArray(new double[]{value1, value2, value3, value4, value5});
    }

    @NotNull
    public static MutableDoubleArray of(double ... values) {
        return values.length != 0 ? new MutableDoubleArray(values) : MutableDoubleArray.empty();
    }

    @NotNull
    public static MutableDoubleArray from(double @NotNull [] values) {
        return values.length != 0 ? new MutableDoubleArray((double[])values.clone()) : MutableDoubleArray.empty();
    }

    @NotNull
    public static MutableDoubleArray from(@NotNull DoubleTraversable values) {
        return values.isNotEmpty() ? new MutableDoubleArray(values.toArray()) : MutableDoubleArray.empty();
    }

    @NotNull
    public static MutableDoubleArray from(@NotNull DoubleIterator it) {
        if (!it.hasNext()) {
            return MutableDoubleArray.empty();
        }
        return new MutableDoubleArray(it.toArray());
    }

    @NotNull
    public static MutableDoubleArray fill(int n, double value) {
        if (n <= 0) {
            return MutableDoubleArray.empty();
        }
        double[] ans = new double[n];
        if (value != 0.0) {
            Arrays.fill(ans, value);
        }
        return new MutableDoubleArray(ans);
    }

    @NotNull
    public static MutableDoubleArray fill(int n, @NotNull DoubleSupplier supplier) {
        if (n <= 0) {
            return MutableDoubleArray.empty();
        }
        double[] ans = new double[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsDouble();
        }
        return new MutableDoubleArray(ans);
    }

    @NotNull
    public static MutableDoubleArray wrap(double @NotNull [] array) {
        Objects.requireNonNull(array);
        return new MutableDoubleArray(array);
    }

    @Override
    @NotNull
    public final String className() {
        return "MutableArray";
    }

    @NotNull
    public DoubleCollectionFactory<?, MutableDoubleArray> iterableFactory() {
        return MutableDoubleArray.factory();
    }

    @NotNull
    public MutableDoubleArray clone() {
        return new MutableDoubleArray((double[])this.elements.clone());
    }

    public double @NotNull [] getArray() {
        return this.elements;
    }

    @Override
    public void set(int index, double newValue) {
        try {
            this.elements[index] = newValue;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public void replaceAll(@NotNull DoubleUnaryOperator operator) {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = operator.applyAsDouble(this.elements[i]);
        }
    }

    @Override
    public void sort() {
        DoubleArrays.sort((double[])this.elements);
    }

    private static final class Factory
    implements DoubleCollectionFactory<MutableDoubleArrayList, MutableDoubleArray> {
        Factory() {
        }

        public MutableDoubleArray from(double @NotNull [] values) {
            return MutableDoubleArray.from(values);
        }

        public MutableDoubleArray from(@NotNull DoubleTraversable values) {
            return MutableDoubleArray.from(values);
        }

        @NotNull
        public MutableDoubleArray from(@NotNull DoubleIterator it) {
            return MutableDoubleArray.from(it);
        }

        public MutableDoubleArray fill(int n, double value) {
            return MutableDoubleArray.fill(n, value);
        }

        public MutableDoubleArray fill(int n, @NotNull DoubleSupplier supplier) {
            return MutableDoubleArray.fill(n, supplier);
        }

        public MutableDoubleArrayList newBuilder() {
            return new MutableDoubleArrayList();
        }

        public void addToBuilder(@NotNull MutableDoubleArrayList builder, double value) {
            builder.append(value);
        }

        public void sizeHint(@NotNull MutableDoubleArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public MutableDoubleArrayList mergeBuilder(@NotNull MutableDoubleArrayList builder1, @NotNull MutableDoubleArrayList builder2) {
            builder1.appendAll(builder2);
            return builder1;
        }

        public MutableDoubleArray build(@NotNull MutableDoubleArrayList builder) {
            return new MutableDoubleArray(builder.toArray());
        }
    }
}

