/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.IntPredicate;
import kala.Conditions;
import kala.collection.base.primitive.IntGrowable;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.factory.primitive.IntCollectionFactory;
import kala.collection.mutable.primitive.MutableIntArrayList;
import kala.collection.mutable.primitive.MutableIntListIterator;
import kala.collection.mutable.primitive.MutableIntSeq;
import kala.collection.mutable.primitive.MutablePrimitiveList;
import kala.collection.primitive.IntArraySeq;
import kala.collection.primitive.IntSeq;
import kala.collection.primitive.internal.IntSeqIterators;
import kala.control.primitive.IntOption;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MutableIntList
extends MutablePrimitiveList<Integer>,
MutableIntSeq,
IntGrowable {
    @NotNull
    public static IntCollectionFactory<?, MutableIntList> factory() {
        return IntCollectionFactory.narrow(MutableIntArrayList.factory());
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableIntList create() {
        return MutableIntArrayList.create();
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableIntList of() {
        return MutableIntArrayList.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableIntList of(int value1) {
        return MutableIntArrayList.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableIntList of(int value1, int value2) {
        return MutableIntArrayList.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableIntList of(int value1, int value2, int value3) {
        return MutableIntArrayList.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableIntList of(int value1, int value2, int value3, int value4) {
        return MutableIntArrayList.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableIntList of(int value1, int value2, int value3, int value4, int value5) {
        return MutableIntArrayList.of(value1, value2, value3, value4, value5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableIntList of(int ... values) {
        return MutableIntArrayList.of(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableIntList from(int @NotNull [] values) {
        return MutableIntArrayList.from(values);
    }

    @NotNull
    public static MutableIntList from(@NotNull IntTraversable values) {
        return MutableIntArrayList.from(values);
    }

    @NotNull
    public static MutableIntList from(@NotNull IntIterator it) {
        return MutableIntArrayList.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableIntList";
    }

    @NotNull
    default public IntCollectionFactory<?, ? extends MutableIntList> iterableFactory() {
        return MutableIntList.factory();
    }

    @Override
    @NotNull
    default public MutableIntListIterator seqIterator() {
        return this.seqIterator(0);
    }

    @Override
    @NotNull
    default public MutableIntListIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new IntSeqIterators.DefaultMutableIntListIterator<MutableIntList>(this, index);
    }

    @Contract(mutates="this")
    public void append(@Flow(targetIsContainer=true) int var1);

    @Contract(mutates="this")
    default public void appendAll(@Flow(sourceIsContainer=true, targetIsContainer=true) int @NotNull [] values) {
        int length = values.length;
        if (length != 0) {
            if (length == 1) {
                this.append(values[0]);
            } else {
                this.appendAll(IntArraySeq.wrap(values));
            }
        }
    }

    @Contract(mutates="this")
    default public void appendAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) IntTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            for (int e : this.toArray()) {
                this.append(e);
            }
        } else {
            values.forEach(this::append);
        }
    }

    default public void plusAssign(int value) {
        this.append(value);
    }

    default public void plusAssign(int @NotNull [] values) {
        this.appendAll(values);
    }

    default public void plusAssign(@NotNull IntTraversable values) {
        this.appendAll(values);
    }

    @Contract(mutates="this")
    public void prepend(int var1);

    @Contract(mutates="this")
    default public void prependAll(@Flow(sourceIsContainer=true, targetIsContainer=true) int @NotNull [] values) {
        this.prependAll(IntArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public void prependAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) IntTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            int[] arr = values.toArray();
            for (int i = arr.length - 1; i >= 0; --i) {
                this.prepend(arr[i]);
            }
            return;
        }
        if (values instanceof IntSeq && ((IntSeq)values).supportsFastRandomAccess()) {
            IntSeq seq = (IntSeq)values;
            int s = seq.size();
            for (int i = s - 1; i >= 0; --i) {
                this.prepend(seq.get(i));
            }
            return;
        }
        int[] cv = values.toArray();
        for (int i = cv.length - 1; i >= 0; --i) {
            this.prepend(cv[i]);
        }
    }

    @Contract(mutates="this")
    public void insert(int var1, @Flow(targetIsContainer=true) int var2);

    @Contract(mutates="this")
    default public void insertAll(int index, @Flow(sourceIsContainer=true, targetIsContainer=true) int @NotNull [] values) {
        this.insertAll(index, IntArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public void insertAll(int index, @NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) IntTraversable values) {
        int[] valuesArray;
        Objects.requireNonNull(values);
        if (this.isEmpty() && index != 0) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        for (int e : valuesArray = values.toArray()) {
            this.insert(index++, e);
        }
    }

    @Contract(mutates="this")
    @Flow(sourceIsContainer=true)
    public int removeAt(int var1);

    default public void removeInRange(int beginIndex, int endIndex) {
        int size = this.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int rangeLength = endIndex - beginIndex;
        if (rangeLength == 0) {
            return;
        }
        if (rangeLength == size) {
            this.clear();
            return;
        }
        for (int i = 0; i < rangeLength; ++i) {
            this.removeAt(beginIndex);
        }
    }

    @Contract(mutates="this")
    default public int removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Seq is empty");
        }
        return this.removeAt(0);
    }

    @Contract(mutates="this")
    @Nullable
    default public Integer removeFirstOrNull() {
        return this.isEmpty() ? null : Integer.valueOf(this.removeAt(0));
    }

    @Contract(mutates="this")
    @NotNull
    default public IntOption removeFirstOption() {
        return this.isEmpty() ? IntOption.none() : IntOption.some((int)this.removeAt(0));
    }

    @Contract(mutates="this")
    default public int removeLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException("Seq is empty");
        }
        return this.removeAt(size - 1);
    }

    @Contract(mutates="this")
    @Nullable
    default public int removeLastOrNull() {
        int size = this.size();
        return size == 0 ? null : Integer.valueOf(this.removeAt(size - 1));
    }

    @Contract(mutates="this")
    @NotNull
    default public IntOption removeLastOption() {
        int size = this.size();
        return size == 0 ? IntOption.none() : IntOption.some((int)this.removeAt(size - 1));
    }

    @Contract(mutates="this")
    default public boolean removeIf(@NotNull IntPredicate predicate) {
        MutableIntListIterator it = this.seqIterator();
        boolean changed = false;
        while (it.hasNext()) {
            int value = it.nextInt();
            if (!predicate.test(value)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Deprecated
    default public boolean removeAll(@NotNull IntPredicate predicate) {
        return this.removeIf(predicate);
    }

    @Contract(mutates="this")
    default public boolean retainIf(@NotNull IntPredicate predicate) {
        MutableIntListIterator it = this.seqIterator();
        boolean changed = false;
        while (it.hasNext()) {
            int value = it.nextInt();
            if (predicate.test(value)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Deprecated
    @Contract(mutates="this")
    default public boolean retainAll(@NotNull IntPredicate predicate) {
        return this.retainIf(predicate);
    }

    @Contract(mutates="this")
    public void clear();

    @Contract(mutates="this")
    default public void dropInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return;
        }
        MutableIntListIterator it = this.seqIterator();
        for (int i = 0; i < n && it.hasNext(); ++i) {
            it.nextInt();
            it.remove();
        }
    }

    @Contract(mutates="this")
    default public void takeInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            this.clear();
            return;
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0 && n >= knownSize) {
            return;
        }
        MutableIntListIterator it = this.seqIterator(n);
        while (it.hasNext()) {
            it.nextInt();
            it.remove();
        }
    }

    @Contract(mutates="this")
    default public void filterInPlace(@NotNull IntPredicate predicate) {
        this.retainAll(predicate);
    }

    @Contract(mutates="this")
    default public void filterNotInPlace(@NotNull IntPredicate predicate) {
        this.removeAll(predicate);
    }
}

