/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntUnaryOperator;
import kala.Conditions;
import kala.collection.base.primitive.IntArrays;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.factory.primitive.IntCollectionFactory;
import kala.collection.mutable.primitive.MutableIntArray;
import kala.collection.mutable.primitive.MutableIntCollection;
import kala.collection.mutable.primitive.MutableIntSeqIterator;
import kala.collection.mutable.primitive.MutablePrimitiveSeq;
import kala.collection.primitive.IntSeq;
import kala.collection.primitive.internal.IntSeqIterators;
import kala.function.IndexedIntUnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface MutableIntSeq
extends MutablePrimitiveSeq<Integer>,
IntSeq,
MutableIntCollection {
    @NotNull
    public static IntCollectionFactory<?, MutableIntSeq> factory() {
        return IntCollectionFactory.narrow(MutableIntArray.factory());
    }

    @NotNull
    public static MutableIntSeq of() {
        return MutableIntArray.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableIntSeq of(int value1) {
        return MutableIntArray.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableIntSeq of(int value1, int value2) {
        return MutableIntArray.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableIntSeq of(int value1, int value2, int value3) {
        return MutableIntArray.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableIntSeq of(int value1, int value2, int value3, int value4) {
        return MutableIntArray.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableIntSeq of(int value1, int value2, int value3, int value4, int value5) {
        return MutableIntArray.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static MutableIntSeq of(int ... values) {
        return MutableIntArray.of(values);
    }

    @NotNull
    public static MutableIntSeq from(int @NotNull [] values) {
        return MutableIntArray.from(values);
    }

    @NotNull
    public static MutableIntSeq from(@NotNull IntTraversable values) {
        return MutableIntArray.from(values);
    }

    @NotNull
    public static MutableIntSeq from(@NotNull IntIterator it) {
        return MutableIntArray.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableIntSeq";
    }

    @NotNull
    default public IntCollectionFactory<?, ? extends MutableIntSeq> iterableFactory() {
        return MutableIntSeq.factory();
    }

    @Override
    @NotNull
    default public MutableIntSeqIterator seqIterator() {
        return this.seqIterator(0);
    }

    @Override
    @NotNull
    default public MutableIntSeqIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new IntSeqIterators.DefaultMutableIntSeqIterator<MutableIntSeq>(this, index);
    }

    @Contract(mutates="this")
    public void set(int var1, int var2);

    default public void swap(int index1, int index2) {
        int old1 = this.get(index1);
        int old2 = this.get(index2);
        this.set(index1, old2);
        this.set(index2, old1);
    }

    @Contract(mutates="this")
    default public void replaceAll(@NotNull IntUnaryOperator operator) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.set(i, operator.applyAsInt(this.get(i)));
        }
    }

    @Contract(mutates="this")
    default public void replaceAllIndexed(@NotNull IndexedIntUnaryOperator operator) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.set(i, operator.applyAsInt(i, this.get(i)));
        }
    }

    @Contract(mutates="this")
    default public void sort() {
        int[] values = this.toArray();
        Arrays.sort(values);
        for (int i = 0; i < values.length; ++i) {
            this.set(i, values[i]);
        }
    }

    @Contract(mutates="this")
    default public void reverse() {
        int size = this.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size / 2; ++i) {
            this.swap(i, size - i - 1);
        }
    }

    default public void shuffle() {
        this.shuffle(ThreadLocalRandom.current());
    }

    default public void shuffle(@NotNull Random random) {
        int ks = this.knownSize();
        if (ks == 0 || ks == 1) {
            return;
        }
        if (this.supportsFastRandomAccess() || ks > 0 && ks <= 5) {
            if (!1.$assertionsDisabled && ks <= 0) {
                throw new AssertionError();
            }
            for (int i2 = ks; i2 > 1; --i2) {
                this.swap(i2 - 1, random.nextInt(i2));
            }
        } else {
            int[] arr = this.toArray();
            IntArrays.shuffle((int[])arr, (Random)random);
            this.replaceAllIndexed((i, v) -> arr[i]);
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

