/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.Objects;
import java.util.function.IntPredicate;
import kala.collection.base.primitive.IntGrowable;
import kala.collection.base.primitive.IntIterator;
import kala.collection.base.primitive.IntTraversable;
import kala.collection.factory.primitive.IntCollectionFactory;
import kala.collection.mutable.primitive.MutableIntCollection;
import kala.collection.mutable.primitive.MutableIntTreeSet;
import kala.collection.mutable.primitive.MutablePrimitiveSet;
import kala.collection.primitive.IntArraySeq;
import kala.collection.primitive.IntSet;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface MutableIntSet
extends MutablePrimitiveSet<Integer>,
IntSet,
MutableIntCollection,
IntGrowable {
    @Contract(pure=true)
    @NotNull
    public static IntCollectionFactory<?, MutableIntSet> factory() {
        return IntCollectionFactory.narrow(MutableIntTreeSet.factory());
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableIntSet create() {
        return MutableIntTreeSet.create();
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableIntSet of() {
        return MutableIntTreeSet.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableIntSet of(int value1) {
        return MutableIntTreeSet.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableIntSet of(int value1, int value2) {
        return MutableIntTreeSet.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableIntSet of(int value1, int value2, int value3) {
        return MutableIntTreeSet.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableIntSet of(int value1, int value2, int value3, int value4) {
        return MutableIntTreeSet.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableIntSet of(int value1, int value2, int value3, int value4, int value5) {
        return MutableIntTreeSet.of(value1, value2, value3, value4, value5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableIntSet of(int ... values) {
        return MutableIntTreeSet.of(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableIntSet from(int @NotNull [] values) {
        return MutableIntTreeSet.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableIntSet from(@NotNull IntTraversable values) {
        return MutableIntTreeSet.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableIntSet from(@NotNull IntIterator it) {
        return MutableIntTreeSet.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableIntSet";
    }

    @NotNull
    default public IntCollectionFactory<?, ? extends MutableIntSet> iterableFactory() {
        return MutableIntSet.factory();
    }

    @Contract(mutates="this")
    public boolean add(@Flow(targetIsContainer=true) int var1);

    @Contract(mutates="this")
    default public boolean addAll(@Flow(sourceIsContainer=true, targetIsContainer=true) int @NotNull [] values) {
        Objects.requireNonNull(values);
        return this.addAll(IntArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean addAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) IntTraversable values) {
        if (values == this) {
            return false;
        }
        boolean m = false;
        IntIterator it = values.iterator();
        while (it.hasNext()) {
            if (!this.add(it.nextInt())) continue;
            m = true;
        }
        return m;
    }

    default public void plusAssign(int value) {
        this.add(value);
    }

    default public void plusAssign(int @NotNull [] values) {
        this.addAll(values);
    }

    default public void plusAssign(@NotNull IntTraversable values) {
        this.addAll(values);
    }

    @Contract(mutates="this")
    public void clear();

    default public void trimToSize() {
    }

    @Contract(mutates="this")
    public boolean remove(int var1);

    @Contract(mutates="this")
    default public boolean removeAll(int @NotNull [] values) {
        Objects.requireNonNull(values);
        return this.removeAll(IntArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean removeAll(@NotNull IntTraversable values) {
        Objects.requireNonNull(values);
        boolean m = false;
        IntIterator it = values.iterator();
        while (it.hasNext()) {
            if (!this.remove(it.nextInt())) continue;
            m = true;
        }
        return m;
    }

    @Contract(mutates="this")
    default public boolean removeIf(@NotNull IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        int[] arr = this.toArray();
        int oldSize = arr.length;
        for (int e : arr) {
            if (!predicate.test(e)) continue;
            this.remove(e);
        }
        return this.size() != oldSize;
    }

    @Deprecated
    default public boolean removeAll(@NotNull IntPredicate predicate) {
        return this.removeIf(predicate);
    }

    @Contract(mutates="this")
    default public boolean retainAll(int @NotNull [] values) {
        return this.retainAll(IntArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean retainAll(@NotNull IntTraversable values) {
        Objects.requireNonNull(values);
        if (this.isEmpty() || values.isEmpty()) {
            return false;
        }
        int[] arr = this.toArray();
        int oldSize = arr.length;
        IntIterator it = this.iterator();
        while (it.hasNext()) {
            int v = it.nextInt();
            if (values.contains(v)) continue;
            this.remove(v);
        }
        return this.size() != oldSize;
    }

    @Contract(mutates="this")
    default public boolean retainIf(@NotNull IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        int[] arr = this.toArray();
        int oldSize = arr.length;
        for (int e : arr) {
            if (predicate.test(e)) continue;
            this.remove(e);
        }
        return this.size() != oldSize;
    }

    @Deprecated
    default public boolean retainAll(@NotNull IntPredicate predicate) {
        return this.retainIf(predicate);
    }

    @Contract(mutates="this")
    default public void filterInPlace(@NotNull IntPredicate predicate) {
        this.retainAll(predicate);
    }

    @Contract(mutates="this")
    default public void filterNotInPlace(@NotNull IntPredicate predicate) {
        this.removeAll(predicate);
    }
}

