/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.LongPredicate;
import kala.Conditions;
import kala.collection.base.primitive.LongGrowable;
import kala.collection.base.primitive.LongIterator;
import kala.collection.base.primitive.LongTraversable;
import kala.collection.factory.primitive.LongCollectionFactory;
import kala.collection.mutable.primitive.MutableLongArrayList;
import kala.collection.mutable.primitive.MutableLongListIterator;
import kala.collection.mutable.primitive.MutableLongSeq;
import kala.collection.mutable.primitive.MutablePrimitiveList;
import kala.collection.primitive.LongArraySeq;
import kala.collection.primitive.LongSeq;
import kala.collection.primitive.internal.LongSeqIterators;
import kala.control.primitive.LongOption;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MutableLongList
extends MutablePrimitiveList<Long>,
MutableLongSeq,
LongGrowable {
    @NotNull
    public static LongCollectionFactory<?, MutableLongList> factory() {
        return LongCollectionFactory.narrow(MutableLongArrayList.factory());
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableLongList create() {
        return MutableLongArrayList.create();
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableLongList of() {
        return MutableLongArrayList.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableLongList of(long value1) {
        return MutableLongArrayList.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableLongList of(long value1, long value2) {
        return MutableLongArrayList.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableLongList of(long value1, long value2, long value3) {
        return MutableLongArrayList.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableLongList of(long value1, long value2, long value3, long value4) {
        return MutableLongArrayList.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableLongList of(long value1, long value2, long value3, long value4, long value5) {
        return MutableLongArrayList.of(value1, value2, value3, value4, value5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableLongList of(long ... values) {
        return MutableLongArrayList.of(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableLongList from(long @NotNull [] values) {
        return MutableLongArrayList.from(values);
    }

    @NotNull
    public static MutableLongList from(@NotNull LongTraversable values) {
        return MutableLongArrayList.from(values);
    }

    @NotNull
    public static MutableLongList from(@NotNull LongIterator it) {
        return MutableLongArrayList.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableLongList";
    }

    @NotNull
    default public LongCollectionFactory<?, ? extends MutableLongList> iterableFactory() {
        return MutableLongList.factory();
    }

    @Override
    @NotNull
    default public MutableLongListIterator seqIterator() {
        return this.seqIterator(0);
    }

    @Override
    @NotNull
    default public MutableLongListIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size());
        return new LongSeqIterators.DefaultMutableLongListIterator<MutableLongList>(this, index);
    }

    @Contract(mutates="this")
    public void append(@Flow(targetIsContainer=true) long var1);

    @Contract(mutates="this")
    default public void appendAll(@Flow(sourceIsContainer=true, targetIsContainer=true) long @NotNull [] values) {
        int length = values.length;
        if (length != 0) {
            if (length == 1) {
                this.append(values[0]);
            } else {
                this.appendAll(LongArraySeq.wrap(values));
            }
        }
    }

    @Contract(mutates="this")
    default public void appendAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) LongTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            for (long e : this.toArray()) {
                this.append(e);
            }
        } else {
            values.forEach(this::append);
        }
    }

    default public void plusAssign(long value) {
        this.append(value);
    }

    default public void plusAssign(long @NotNull [] values) {
        this.appendAll(values);
    }

    default public void plusAssign(@NotNull LongTraversable values) {
        this.appendAll(values);
    }

    @Contract(mutates="this")
    public void prepend(long var1);

    @Contract(mutates="this")
    default public void prependAll(@Flow(sourceIsContainer=true, targetIsContainer=true) long @NotNull [] values) {
        this.prependAll(LongArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public void prependAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) LongTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            long[] arr = values.toArray();
            for (int i = arr.length - 1; i >= 0; --i) {
                this.prepend(arr[i]);
            }
            return;
        }
        if (values instanceof LongSeq && ((LongSeq)values).supportsFastRandomAccess()) {
            LongSeq seq = (LongSeq)values;
            int s = seq.size();
            for (int i = s - 1; i >= 0; --i) {
                this.prepend(seq.get(i));
            }
            return;
        }
        long[] cv = values.toArray();
        for (int i = cv.length - 1; i >= 0; --i) {
            this.prepend(cv[i]);
        }
    }

    @Contract(mutates="this")
    public void insert(int var1, @Flow(targetIsContainer=true) long var2);

    @Contract(mutates="this")
    default public void insertAll(int index, @Flow(sourceIsContainer=true, targetIsContainer=true) long @NotNull [] values) {
        this.insertAll(index, LongArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public void insertAll(int index, @NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) LongTraversable values) {
        long[] valuesArray;
        Objects.requireNonNull(values);
        if (this.isEmpty() && index != 0) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        for (long e : valuesArray = values.toArray()) {
            this.insert(index++, e);
        }
    }

    @Contract(mutates="this")
    @Flow(sourceIsContainer=true)
    public long removeAt(int var1);

    default public void removeInRange(int beginIndex, int endIndex) {
        int size = this.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int rangeLength = endIndex - beginIndex;
        if (rangeLength == 0) {
            return;
        }
        if (rangeLength == size) {
            this.clear();
            return;
        }
        for (int i = 0; i < rangeLength; ++i) {
            this.removeAt(beginIndex);
        }
    }

    @Contract(mutates="this")
    default public long removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Seq is empty");
        }
        return this.removeAt(0);
    }

    @Contract(mutates="this")
    @Nullable
    default public Long removeFirstOrNull() {
        return this.isEmpty() ? null : Long.valueOf(this.removeAt(0));
    }

    @Contract(mutates="this")
    @NotNull
    default public LongOption removeFirstOption() {
        return this.isEmpty() ? LongOption.none() : LongOption.some((long)this.removeAt(0));
    }

    @Contract(mutates="this")
    default public long removeLast() {
        int size = this.size();
        if (size == 0) {
            throw new NoSuchElementException("Seq is empty");
        }
        return this.removeAt(size - 1);
    }

    @Contract(mutates="this")
    @Nullable
    default public long removeLastOrNull() {
        int size = this.size();
        return size == 0 ? null : Long.valueOf(this.removeAt(size - 1));
    }

    @Contract(mutates="this")
    @NotNull
    default public LongOption removeLastOption() {
        int size = this.size();
        return size == 0 ? LongOption.none() : LongOption.some((long)this.removeAt(size - 1));
    }

    @Contract(mutates="this")
    default public boolean removeIf(@NotNull LongPredicate predicate) {
        MutableLongListIterator it = this.seqIterator();
        boolean changed = false;
        while (it.hasNext()) {
            long value = it.nextLong();
            if (!predicate.test(value)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Deprecated
    default public boolean removeAll(@NotNull LongPredicate predicate) {
        return this.removeIf(predicate);
    }

    @Contract(mutates="this")
    default public boolean retainIf(@NotNull LongPredicate predicate) {
        MutableLongListIterator it = this.seqIterator();
        boolean changed = false;
        while (it.hasNext()) {
            long value = it.nextLong();
            if (predicate.test(value)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Deprecated
    @Contract(mutates="this")
    default public boolean retainAll(@NotNull LongPredicate predicate) {
        return this.retainIf(predicate);
    }

    @Contract(mutates="this")
    public void clear();

    @Contract(mutates="this")
    default public void dropInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return;
        }
        MutableLongListIterator it = this.seqIterator();
        for (int i = 0; i < n && it.hasNext(); ++i) {
            it.nextLong();
            it.remove();
        }
    }

    @Contract(mutates="this")
    default public void takeInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            this.clear();
            return;
        }
        int knownSize = this.knownSize();
        if (knownSize >= 0 && n >= knownSize) {
            return;
        }
        MutableLongListIterator it = this.seqIterator(n);
        while (it.hasNext()) {
            it.nextLong();
            it.remove();
        }
    }

    @Contract(mutates="this")
    default public void filterInPlace(@NotNull LongPredicate predicate) {
        this.retainAll(predicate);
    }

    @Contract(mutates="this")
    default public void filterNotInPlace(@NotNull LongPredicate predicate) {
        this.removeAll(predicate);
    }
}

