/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.Conditions;
import kala.collection.base.primitive.ShortArrays;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.base.primitive.ShortTraversable;
import kala.collection.factory.primitive.ShortCollectionFactory;
import kala.collection.immutable.primitive.ImmutableShortArray;
import kala.collection.mutable.primitive.AbstractMutableShortList;
import kala.collection.mutable.primitive.AbstractMutableShortListFactory;
import kala.collection.mutable.primitive.MutableShortListIterator;
import kala.collection.primitive.AbstractShortSeqIterator;
import kala.collection.primitive.IndexedShortSeq;
import kala.collection.primitive.ShortSeqLike;
import kala.function.ShortSupplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MutableShortArrayList
extends AbstractMutableShortList
implements IndexedShortSeq,
Serializable {
    private static final long serialVersionUID = 2545219250020890853L;
    private static final Factory FACTORY = new Factory();
    static final int DEFAULT_CAPACITY = 10;
    static final short[] DEFAULT_EMPTY_ARRAY = new short[0];
    short @NotNull [] elements;
    int size;

    private MutableShortArrayList(short @NotNull [] elements, int size) {
        this.elements = elements;
        this.size = size;
    }

    public MutableShortArrayList() {
        this(DEFAULT_EMPTY_ARRAY, 0);
    }

    public MutableShortArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("illegal initialCapacity: " + initialCapacity);
        }
        this.elements = initialCapacity == 0 ? ShortArrays.EMPTY : new short[initialCapacity];
        this.size = 0;
    }

    @NotNull
    public static ShortCollectionFactory<?, MutableShortArrayList> factory() {
        return FACTORY;
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableShortArrayList create() {
        return new MutableShortArrayList();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableShortArrayList create(int initialCapacity) {
        return new MutableShortArrayList(initialCapacity);
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableShortArrayList of() {
        return new MutableShortArrayList();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableShortArrayList of(short value1) {
        short[] arr = new short[10];
        arr[0] = value1;
        return new MutableShortArrayList(arr, 1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableShortArrayList of(short value1, short value2) {
        short[] arr = new short[10];
        arr[0] = value1;
        arr[1] = value2;
        return new MutableShortArrayList(arr, 2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableShortArrayList of(short value1, short value2, short value3) {
        short[] arr = new short[10];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        return new MutableShortArrayList(arr, 3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableShortArrayList of(short value1, short value2, short value3, short value4) {
        short[] arr = new short[10];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        arr[3] = value4;
        return new MutableShortArrayList(arr, 4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableShortArrayList of(short value1, short value2, short value3, short value4, short value5) {
        short[] arr = new short[10];
        arr[0] = value1;
        arr[1] = value2;
        arr[2] = value3;
        arr[3] = value4;
        arr[4] = value5;
        return new MutableShortArrayList(arr, 5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableShortArrayList of(short ... values) {
        return MutableShortArrayList.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableShortArrayList from(short @NotNull [] values) {
        int length = values.length;
        return length != 0 ? new MutableShortArrayList(Arrays.copyOf(values, Integer.max(10, values.length)), length) : new MutableShortArrayList();
    }

    @NotNull
    public static MutableShortArrayList from(@NotNull ShortTraversable values) {
        MutableShortArrayList buffer = new MutableShortArrayList();
        buffer.appendAll(values);
        return buffer;
    }

    @NotNull
    public static MutableShortArrayList from(@NotNull ShortIterator it) {
        MutableShortArrayList buffer = new MutableShortArrayList();
        while (it.hasNext()) {
            buffer.append(it.next());
        }
        return buffer;
    }

    @NotNull
    public static MutableShortArrayList fill(int n, short value) {
        if (n <= 0) {
            return new MutableShortArrayList();
        }
        short[] arr = new short[Integer.max(10, n)];
        if (value != 0) {
            Arrays.fill(arr, 0, n, value);
        }
        return new MutableShortArrayList(arr, n);
    }

    @NotNull
    public static MutableShortArrayList fill(int n, @NotNull ShortSupplier supplier) {
        if (n <= 0) {
            return new MutableShortArrayList();
        }
        short[] arr = new short[Integer.max(10, n)];
        for (int i = 0; i < n; ++i) {
            arr[i] = supplier.getAsShort();
        }
        return new MutableShortArrayList(arr, n);
    }

    private void grow() {
        this.grow(this.size + 1);
    }

    private void grow(int minCapacity) {
        short[] newArray = this.growArray(minCapacity);
        if (this.elements.length != 0) {
            System.arraycopy(this.elements, 0, newArray, 0, this.size);
        }
        this.elements = newArray;
    }

    private short[] growArray(int minCapacity) {
        int oldCapacity = this.elements.length;
        if (this.elements == DEFAULT_EMPTY_ARRAY && oldCapacity == 0) {
            return new short[Math.max(10, minCapacity)];
        }
        int newCapacity = Math.max(Math.max(oldCapacity, minCapacity), oldCapacity + (oldCapacity >> 1));
        return new short[newCapacity];
    }

    private void checkInBound(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
    }

    short @NotNull [] getArray() {
        return this.elements;
    }

    private void reduceToSize(int newSize) {
        this.size = newSize;
    }

    public void sizeHint(int s) {
        int len = this.elements.length;
        int size = this.size;
        if (s > 0 && s + size > len) {
            this.grow(size + s);
        }
    }

    @Override
    @NotNull
    public String className() {
        return "MutableShortArrayList";
    }

    @NotNull
    public ShortCollectionFactory<?, MutableShortArrayList> iterableFactory() {
        return MutableShortArrayList.factory();
    }

    @Override
    @NotNull
    public ShortIterator iterator() {
        return ShortArrays.iterator((short[])this.elements, (int)0, (int)this.size);
    }

    @Override
    @NotNull
    public ShortIterator iterator(int beginIndex) {
        return ShortArrays.iterator((short[])this.elements, (int)beginIndex, (int)this.size);
    }

    @Override
    @NotNull
    public MutableShortListIterator seqIterator(int index) {
        Conditions.checkPositionIndex((int)index, (int)this.size);
        return new SeqItr(this, index);
    }

    public MutableShortArrayList clone() {
        return new MutableShortArrayList(this.elements.length == 0 ? this.elements : (short[])this.elements.clone(), this.size);
    }

    public int size() {
        return this.size;
    }

    @Override
    public short get(int index) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        return this.elements[index];
    }

    @Override
    public void set(int index, short newValue) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        this.elements[index] = newValue;
    }

    @Override
    public void prepend(short value) {
        short[] values = this.elements;
        if (this.size == values.length) {
            values = this.growArray(this.size + 1);
        }
        System.arraycopy(this.elements, 0, values, 1, this.size);
        values[0] = value;
        this.elements = values;
        ++this.size;
    }

    @Override
    public void prependAll(@NotNull ShortTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            this.appendThis();
            return;
        }
        int size = this.size;
        if (values instanceof ShortSeqLike && ((ShortSeqLike)values).supportsFastRandomAccess()) {
            ShortSeqLike seq = (ShortSeqLike)values;
            int s = seq.size();
            if (s == 0) {
                return;
            }
            short[] arr = this.elements;
            if (arr.length < size + s) {
                arr = this.growArray(size + s);
            }
            System.arraycopy(this.elements, 0, arr, s, size);
            for (int i = 0; i < s; ++i) {
                arr[i] = seq.get(i);
            }
            this.elements = arr;
            this.size += s;
            return;
        }
        short[] cv = values.toArray();
        if (cv.length == 0) {
            return;
        }
        short[] elements = this.elements;
        if (elements.length < size + cv.length) {
            elements = this.growArray(size + cv.length);
        }
        System.arraycopy(this.elements, 0, elements, cv.length, size);
        System.arraycopy(cv, 0, elements, 0, cv.length);
        this.elements = elements;
        this.size += cv.length;
    }

    @Override
    public void append(short value) {
        if (this.size == this.elements.length) {
            this.grow();
        }
        this.elements[this.size++] = value;
    }

    @Override
    public void appendAll(@NotNull ShortTraversable values) {
        Objects.requireNonNull(values);
        if (values == this) {
            this.appendThis();
            return;
        }
        int knowSize = values.knownSize();
        if (knowSize > 0 && this.size + knowSize > this.elements.length) {
            this.grow(this.size + knowSize);
        }
        values.forEach(this::append);
    }

    private void appendThis() {
        int size = this.size;
        if (size == 0) {
            return;
        }
        if (size > 0x3FFFFFFF) {
            throw new OutOfMemoryError("Requested array size exceeds VM limit");
        }
        int newSize = size * 2;
        if (this.elements.length < newSize) {
            this.grow(newSize);
        }
        short[] elements = this.elements;
        System.arraycopy(elements, 0, elements, size, size);
        this.size = newSize;
    }

    @Override
    public int binarySearch(int beginIndex, int endIndex, short value) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.size);
        return Arrays.binarySearch(this.elements, beginIndex, endIndex, value);
    }

    @Override
    public void sort() {
        ShortArrays.sort((short[])this.elements, (int)0, (int)this.size);
    }

    @Override
    public void insert(int index, short value) {
        Conditions.checkPositionIndex((int)index, (int)this.size);
        if (index == this.size) {
            this.append(value);
            return;
        }
        if (this.elements.length == this.size) {
            this.grow();
        }
        System.arraycopy(this.elements, index, this.elements, index + 1, this.size - index);
        this.elements[index] = value;
        ++this.size;
    }

    @Override
    public void insertAll(int index, @NotNull ShortTraversable values) {
        Objects.requireNonNull(values);
        Conditions.checkPositionIndex((int)index, (int)this.size);
        int otherSize = values.size();
        short[] elements = this.elements;
        if (elements.length < this.size + otherSize || values == this) {
            elements = this.growArray(this.size + otherSize);
        }
        System.arraycopy(this.elements, 0, elements, 0, index);
        System.arraycopy(this.elements, index, elements, index + otherSize, this.size - index);
        ShortIterator it = values.iterator();
        for (int i = 0; i < otherSize; ++i) {
            elements[i + index] = it.nextShort();
        }
        assert (!it.hasNext());
        this.elements = elements;
        this.size += otherSize;
    }

    @Override
    public void insertAll(int index, short @NotNull [] values) {
        Objects.requireNonNull(values);
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        if (values.length == 0) {
            return;
        }
        short[] elements = this.elements;
        if (elements.length < this.size + values.length) {
            elements = this.growArray(this.size + values.length);
        }
        System.arraycopy(this.elements, 0, elements, 0, index);
        System.arraycopy(values, 0, elements, index, values.length);
        System.arraycopy(this.elements, index, elements, index + values.length, this.size - index);
        this.elements = elements;
        this.size += values.length;
    }

    public void trimToSize() {
        if (this.size < this.elements.length) {
            this.elements = this.size == 0 ? DEFAULT_EMPTY_ARRAY : Arrays.copyOf(this.elements, this.size);
        }
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public short removeAt(int index) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        short oldValue = this.elements[index];
        int newSize = this.size - 1;
        if (newSize > index) {
            System.arraycopy(this.elements, index + 1, this.elements, index, newSize - index);
        }
        this.elements[newSize] = 0;
        this.size = newSize;
        return oldValue;
    }

    @Override
    public void removeInRange(int beginIndex, int endIndex) {
        int size = this.size();
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)size);
        int rangeLength = endIndex - beginIndex;
        if (rangeLength == 0) {
            return;
        }
        if (rangeLength == size) {
            this.clear();
            return;
        }
        if (rangeLength == 1) {
            this.removeAt(beginIndex);
            return;
        }
        int tailElementsCount = size - endIndex;
        System.arraycopy(this.elements, endIndex, this.elements, beginIndex, tailElementsCount);
        this.size = size - rangeLength;
    }

    @Override
    public void dropInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return;
        }
        if (n >= this.size) {
            this.clear();
            return;
        }
        int newSize = this.size - n;
        System.arraycopy(this.elements, n, this.elements, 0, newSize);
        this.reduceToSize(newSize);
    }

    @Override
    public void takeInPlace(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            this.clear();
            return;
        }
        if (n >= this.size) {
            return;
        }
        this.size = n;
    }

    public int copyToArray(int srcPos, short @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + destPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        int destLength = dest.length;
        int size = this.size();
        if (destPos >= destLength || srcPos >= size) {
            return 0;
        }
        int n = Math.min(Math.min(size - srcPos, destLength - destPos), limit);
        System.arraycopy(this.elements, srcPos, dest, destPos, n);
        return n;
    }

    public short @NotNull [] toArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    @Override
    @NotNull
    public ImmutableShortArray toImmutableArray() {
        return this.size == 0 ? ImmutableShortArray.empty() : ImmutableShortArray.Unsafe.wrap(Arrays.copyOf(this.elements, this.size));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeShort(this.elements[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        short[] elements = size == 0 ? DEFAULT_EMPTY_ARRAY : new short[Integer.max(10, size)];
        for (int i = 0; i < size; ++i) {
            elements[i] = in.readShort();
        }
        this.size = size;
        this.elements = elements;
    }

    private static final class Factory
    extends AbstractMutableShortListFactory<MutableShortArrayList> {
        private Factory() {
        }

        public MutableShortArrayList newBuilder() {
            return new MutableShortArrayList();
        }

        public void sizeHint(@NotNull MutableShortArrayList buffer, int size) {
            buffer.sizeHint(size);
        }

        public MutableShortArrayList from(short @NotNull [] values) {
            return MutableShortArrayList.from(values);
        }

        public MutableShortArrayList from(@NotNull ShortTraversable values) {
            return MutableShortArrayList.from(values);
        }

        public MutableShortArrayList from(@NotNull ShortIterator it) {
            return MutableShortArrayList.from(it);
        }

        public MutableShortArrayList fill(int n, short value) {
            return MutableShortArrayList.fill(n, value);
        }

        public MutableShortArrayList fill(int n, @NotNull ShortSupplier supplier) {
            return MutableShortArrayList.fill(n, supplier);
        }
    }

    private static final class SeqItr
    extends AbstractShortSeqIterator
    implements MutableShortListIterator {
        private final MutableShortArrayList seq;
        private int lastReturned = -1;

        SeqItr(MutableShortArrayList seq, int index) {
            super(index);
            this.seq = seq;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.seq.size;
        }

        @Override
        public short nextShort() {
            int idx = this.cursor;
            if (idx >= this.seq.size) {
                throw new NoSuchElementException();
            }
            try {
                short res = this.seq.elements[idx];
                this.lastReturned = idx;
                this.cursor = idx + 1;
                return res;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ConcurrentModificationException(e);
            }
        }

        @Override
        public short previousShort() {
            int idx = this.cursor - 1;
            if (idx < 0) {
                throw new NoSuchElementException();
            }
            try {
                short res = this.seq.elements[idx];
                this.lastReturned = idx;
                this.cursor = idx;
                return res;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ConcurrentModificationException(e);
            }
        }

        @Override
        public void set(short e) {
            if (this.lastReturned < 0) {
                throw new IllegalStateException();
            }
            try {
                this.seq.set(this.lastReturned, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException(ex);
            }
        }

        @Override
        public void add(short e) {
            int idx = this.cursor;
            try {
                this.seq.insert(idx, e);
                this.cursor = idx + 1;
                this.lastReturned = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException(ex);
            }
        }

        @Override
        public void remove() {
            if (this.lastReturned < 0) {
                throw new IllegalStateException();
            }
            try {
                this.seq.removeAt(this.lastReturned);
                this.cursor = this.lastReturned;
                this.lastReturned = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException(String.format("lastReturned=%d,size=%d,array=%s", this.lastReturned, this.seq.size, Arrays.toString(this.seq.elements)), ex);
            }
        }
    }
}

