/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable.primitive;

import java.util.Objects;
import kala.collection.base.primitive.ShortGrowable;
import kala.collection.base.primitive.ShortIterator;
import kala.collection.base.primitive.ShortTraversable;
import kala.collection.factory.primitive.ShortCollectionFactory;
import kala.collection.mutable.primitive.MutablePrimitiveSet;
import kala.collection.mutable.primitive.MutableShortCollection;
import kala.collection.mutable.primitive.MutableShortTreeSet;
import kala.collection.primitive.ShortArraySeq;
import kala.collection.primitive.ShortSet;
import kala.function.ShortPredicate;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface MutableShortSet
extends MutablePrimitiveSet<Short>,
ShortSet,
MutableShortCollection,
ShortGrowable {
    @Contract(pure=true)
    @NotNull
    public static ShortCollectionFactory<?, MutableShortSet> factory() {
        return ShortCollectionFactory.narrow(MutableShortTreeSet.factory());
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableShortSet create() {
        return MutableShortTreeSet.create();
    }

    @Contract(value="-> new")
    @NotNull
    public static MutableShortSet of() {
        return MutableShortTreeSet.of();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableShortSet of(short value1) {
        return MutableShortTreeSet.of(value1);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MutableShortSet of(short value1, short value2) {
        return MutableShortTreeSet.of(value1, value2);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MutableShortSet of(short value1, short value2, short value3) {
        return MutableShortTreeSet.of(value1, value2, value3);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static MutableShortSet of(short value1, short value2, short value3, short value4) {
        return MutableShortTreeSet.of(value1, value2, value3, value4);
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static MutableShortSet of(short value1, short value2, short value3, short value4, short value5) {
        return MutableShortTreeSet.of(value1, value2, value3, value4, value5);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableShortSet of(short ... values) {
        return MutableShortTreeSet.of(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableShortSet from(short @NotNull [] values) {
        return MutableShortTreeSet.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableShortSet from(@NotNull ShortTraversable values) {
        return MutableShortTreeSet.from(values);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MutableShortSet from(@NotNull ShortIterator it) {
        return MutableShortTreeSet.from(it);
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableShortSet";
    }

    @NotNull
    default public ShortCollectionFactory<?, ? extends MutableShortSet> iterableFactory() {
        return MutableShortSet.factory();
    }

    @Contract(mutates="this")
    public boolean add(@Flow(targetIsContainer=true) short var1);

    @Contract(mutates="this")
    default public boolean addAll(@Flow(sourceIsContainer=true, targetIsContainer=true) short @NotNull [] values) {
        Objects.requireNonNull(values);
        return this.addAll(ShortArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean addAll(@NotNull @Flow(sourceIsContainer=true, targetIsContainer=true) ShortTraversable values) {
        if (values == this) {
            return false;
        }
        boolean m = false;
        ShortIterator it = values.iterator();
        while (it.hasNext()) {
            if (!this.add(it.nextShort())) continue;
            m = true;
        }
        return m;
    }

    default public void plusAssign(short value) {
        this.add(value);
    }

    default public void plusAssign(short @NotNull [] values) {
        this.addAll(values);
    }

    default public void plusAssign(@NotNull ShortTraversable values) {
        this.addAll(values);
    }

    @Contract(mutates="this")
    public void clear();

    default public void trimToSize() {
    }

    @Contract(mutates="this")
    public boolean remove(short var1);

    @Contract(mutates="this")
    default public boolean removeAll(short @NotNull [] values) {
        Objects.requireNonNull(values);
        return this.removeAll(ShortArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean removeAll(@NotNull ShortTraversable values) {
        Objects.requireNonNull(values);
        boolean m = false;
        ShortIterator it = values.iterator();
        while (it.hasNext()) {
            if (!this.remove(it.nextShort())) continue;
            m = true;
        }
        return m;
    }

    @Contract(mutates="this")
    default public boolean removeIf(@NotNull ShortPredicate predicate) {
        Objects.requireNonNull(predicate);
        short[] arr = this.toArray();
        int oldSize = arr.length;
        for (short e : arr) {
            if (!predicate.test(e)) continue;
            this.remove(e);
        }
        return this.size() != oldSize;
    }

    @Deprecated
    default public boolean removeAll(@NotNull ShortPredicate predicate) {
        return this.removeIf(predicate);
    }

    @Contract(mutates="this")
    default public boolean retainAll(short @NotNull [] values) {
        return this.retainAll(ShortArraySeq.wrap(values));
    }

    @Contract(mutates="this")
    default public boolean retainAll(@NotNull ShortTraversable values) {
        Objects.requireNonNull(values);
        if (this.isEmpty() || values.isEmpty()) {
            return false;
        }
        short[] arr = this.toArray();
        int oldSize = arr.length;
        ShortIterator it = this.iterator();
        while (it.hasNext()) {
            short v = it.nextShort();
            if (values.contains(v)) continue;
            this.remove(v);
        }
        return this.size() != oldSize;
    }

    @Contract(mutates="this")
    default public boolean retainIf(@NotNull ShortPredicate predicate) {
        Objects.requireNonNull(predicate);
        short[] arr = this.toArray();
        int oldSize = arr.length;
        for (short e : arr) {
            if (predicate.test(e)) continue;
            this.remove(e);
        }
        return this.size() != oldSize;
    }

    @Deprecated
    default public boolean retainAll(@NotNull ShortPredicate predicate) {
        return this.retainIf(predicate);
    }

    @Contract(mutates="this")
    default public void filterInPlace(@NotNull ShortPredicate predicate) {
        this.retainAll(predicate);
    }

    @Contract(mutates="this")
    default public void filterNotInPlace(@NotNull ShortPredicate predicate) {
        this.removeAll(predicate);
    }
}

