/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import kala.collection.base.primitive.AbstractByteIterator;
import kala.collection.base.primitive.ByteIterator;
import kala.collection.primitive.AbstractByteSet;
import kala.function.ByteConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class AbstractDefaultByteSet
extends AbstractByteSet
implements Serializable {
    private static final long serialVersionUID = -2058604240590412070L;
    protected int size = 0;
    protected long bits0;
    protected long bits1;
    protected long bits2;
    protected long bits3;

    public long bits0() {
        return this.bits0;
    }

    public long bits1() {
        return this.bits1;
    }

    public long bits2() {
        return this.bits2;
    }

    public long bits3() {
        return this.bits3;
    }

    @NotNull
    public ByteIterator iterator() {
        if (this.size == 0) {
            return ByteIterator.empty();
        }
        return new Itr(this.bits0, this.bits1, this.bits2, this.bits3);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public int knownSize() {
        return this.size;
    }

    @Override
    public boolean contains(byte value) {
        long bits;
        int v = value + 128;
        int bitsNumber = v / 64;
        int bitOffset = v % 64;
        switch (bitsNumber) {
            case 0: {
                bits = this.bits0;
                break;
            }
            case 1: {
                bits = this.bits1;
                break;
            }
            case 2: {
                bits = this.bits2;
                break;
            }
            case 3: {
                bits = this.bits3;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return (bits >> bitOffset & 1L) != 0L;
    }

    public void forEach(@NotNull ByteConsumer action) {
        if (this.size == 0) {
            return;
        }
        int cursor = 0;
        while (cursor <= 255) {
            long bits;
            int bitsNumber = cursor / 64;
            int bitOffset = cursor % 64;
            switch (bitsNumber) {
                case 0: {
                    bits = this.bits0;
                    break;
                }
                case 1: {
                    bits = this.bits1;
                    break;
                }
                case 2: {
                    bits = this.bits2;
                    break;
                }
                case 3: {
                    bits = this.bits3;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if ((bits >> bitOffset & 1L) != 0L) {
                action.accept((byte)(cursor++ - 128));
                continue;
            }
            if (bits == 0L) {
                cursor = (bitsNumber + 1) * 64;
                continue;
            }
            ++cursor;
        }
        return;
    }

    private static final class Itr
    extends AbstractByteIterator {
        private int cursor = 0;
        private final long bits0;
        private final long bits1;
        private final long bits2;
        private final long bits3;

        Itr(long bits0, long bits1, long bits2, long bits3) {
            this.bits0 = bits0;
            this.bits1 = bits1;
            this.bits2 = bits2;
            this.bits3 = bits3;
        }

        public boolean hasNext() {
            while (this.cursor <= 255) {
                long bits;
                int bitsNumber = this.cursor / 64;
                int bitOffset = this.cursor % 64;
                switch (bitsNumber) {
                    case 0: {
                        bits = this.bits0;
                        break;
                    }
                    case 1: {
                        bits = this.bits1;
                        break;
                    }
                    case 2: {
                        bits = this.bits2;
                        break;
                    }
                    case 3: {
                        bits = this.bits3;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                if ((bits >> bitOffset & 1L) != 0L) {
                    return true;
                }
                if (bits == 0L) {
                    this.cursor = (bitsNumber + 1) * 64;
                    continue;
                }
                ++this.cursor;
            }
            return false;
        }

        public byte nextByte() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (byte)(this.cursor++ - 128);
        }
    }
}

