/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import kala.Conditions;
import kala.collection.base.primitive.CharArrays;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.collection.factory.primitive.CharCollectionFactory;
import kala.collection.immutable.primitive.ImmutableCharArray;
import kala.collection.mutable.primitive.MutableCharArrayList;
import kala.collection.primitive.AbstractCharSeq;
import kala.collection.primitive.IndexedCharSeq;
import kala.function.CharBinaryOperator;
import kala.function.CharConsumer;
import kala.function.CharObjBiFunction;
import kala.function.CharPredicate;
import kala.function.CharSupplier;
import kala.function.ObjCharBiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;

@Debug.Renderer(hasChildren="isNotEmpty()", childrenArray="elements")
public class CharArraySeq
extends AbstractCharSeq
implements IndexedCharSeq,
Serializable {
    private static final long serialVersionUID = 4981379062449237945L;
    public static final CharArraySeq EMPTY = new CharArraySeq(CharArrays.EMPTY);
    private static final Factory FACTORY = new Factory();
    protected final char @NotNull [] elements;

    protected CharArraySeq(char @NotNull [] elements) {
        this.elements = elements;
    }

    @NotNull
    public static CharCollectionFactory<?, ? extends CharArraySeq> factory() {
        return FACTORY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static CharArraySeq wrap(char @NotNull [] array) {
        Objects.requireNonNull(array);
        return new CharArraySeq(array);
    }

    @NotNull
    public static CharArraySeq empty() {
        return EMPTY;
    }

    @NotNull
    public static CharArraySeq of() {
        return CharArraySeq.empty();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static CharArraySeq of(char value1) {
        return new CharArraySeq(new char[]{value1});
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static CharArraySeq of(char value1, char value2) {
        return new CharArraySeq(new char[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static CharArraySeq of(char value1, char value2, char value3) {
        return new CharArraySeq(new char[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static CharArraySeq of(char value1, char value2, char value3, char value4) {
        return new CharArraySeq(new char[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static CharArraySeq of(char value1, char value2, char value3, char value4, char value5) {
        return new CharArraySeq(new char[]{value1, value2, value3, value4, value5});
    }

    @Contract(pure=true)
    @NotNull
    public static CharArraySeq of(char ... values) {
        return CharArraySeq.from(values);
    }

    @Contract(pure=true)
    @NotNull
    public static CharArraySeq from(char @NotNull [] values) {
        return values.length == 0 ? CharArraySeq.empty() : new CharArraySeq((char[])values.clone());
    }

    @NotNull
    public static CharArraySeq from(@NotNull CharTraversable values) {
        if (values instanceof ImmutableCharArray) {
            return (CharArraySeq)values;
        }
        if (values.isEmpty()) {
            return CharArraySeq.empty();
        }
        char[] arr = values.toArray();
        return arr.length == 0 ? CharArraySeq.empty() : new CharArraySeq(arr);
    }

    @NotNull
    public static CharArraySeq from(@NotNull CharIterator it) {
        if (!it.hasNext()) {
            return CharArraySeq.empty();
        }
        return new CharArraySeq(it.toArray());
    }

    @NotNull
    public static CharArraySeq fill(int n, char value) {
        if (n <= 0) {
            return CharArraySeq.empty();
        }
        char[] ans = new char[n];
        if (value != '\u0000') {
            Arrays.fill(ans, value);
        }
        return new CharArraySeq(ans);
    }

    @NotNull
    public static CharArraySeq fill(int n, @NotNull CharSupplier supplier) {
        if (n <= 0) {
            return CharArraySeq.empty();
        }
        char[] ans = new char[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.getAsChar();
        }
        return new CharArraySeq(ans);
    }

    @Override
    @NotNull
    public String className() {
        return "CharArraySeq";
    }

    @Override
    @NotNull
    public final CharIterator iterator() {
        return CharArrays.iterator((char[])this.elements);
    }

    @Override
    @NotNull
    public CharIterator iterator(int beginIndex) {
        return CharArrays.iterator((char[])this.elements, (int)beginIndex);
    }

    @Override
    public final boolean isEmpty() {
        return this.elements.length == 0;
    }

    public final int size() {
        return this.elements.length;
    }

    @Override
    public final int knownSize() {
        return this.elements.length;
    }

    @Override
    @NotNull
    public final CharIterator reverseIterator() {
        return CharArrays.reverseIterator((char[])this.elements);
    }

    @Override
    public final char get(int index) {
        return this.elements[index];
    }

    @Override
    public final int binarySearch(int beginIndex, int endIndex, char value) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.elements.length);
        return Arrays.binarySearch(this.elements, beginIndex, endIndex, value);
    }

    @Override
    public final char first() {
        try {
            return this.elements[0];
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public final char last() {
        int size = this.elements.length;
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[size - 1];
    }

    public final boolean contains(char value) {
        if (this.elements.length == 0) {
            return false;
        }
        for (char e : this.elements) {
            if (value != e) continue;
            return true;
        }
        return false;
    }

    public final boolean containsAll(@NotNull CharTraversable values) {
        CharIterator it = values.iterator();
        while (it.hasNext()) {
            char v = it.nextChar();
            if (this.contains(v)) continue;
            return false;
        }
        return true;
    }

    public final boolean anyMatch(@NotNull CharPredicate predicate) {
        for (char e : this.elements) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    public final boolean allMatch(@NotNull CharPredicate predicate) {
        for (char e : this.elements) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public final boolean noneMatch(@NotNull CharPredicate predicate) {
        for (char e : this.elements) {
            if (!predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int indexOf(char value) {
        return CharArrays.indexOf((char[])this.elements, (char)value);
    }

    @Override
    public final int indexOf(char value, int from) {
        return CharArrays.indexOf((char[])this.elements, (char)value, (int)from);
    }

    @Override
    public final int indexWhere(@NotNull CharPredicate predicate) {
        return CharArrays.indexWhere((char[])this.elements, (CharPredicate)predicate);
    }

    @Override
    public final int indexWhere(@NotNull CharPredicate predicate, int from) {
        return CharArrays.indexWhere((char[])this.elements, (CharPredicate)predicate, (int)from);
    }

    @Override
    public final int lastIndexOf(char value) {
        return CharArrays.lastIndexOf((char[])this.elements, (char)value);
    }

    @Override
    public final int lastIndexOf(char value, int end) {
        return CharArrays.lastIndexOf((char[])this.elements, (char)value, (int)end);
    }

    @Override
    public final int lastIndexWhere(@NotNull CharPredicate predicate) {
        return CharArrays.lastIndexWhere((char[])this.elements, (CharPredicate)predicate);
    }

    @Override
    public final int lastIndexWhere(@NotNull CharPredicate predicate, int end) {
        return CharArrays.lastIndexWhere((char[])this.elements, (CharPredicate)predicate, (int)end);
    }

    public final int count(@NotNull CharPredicate predicate) {
        int c = 0;
        for (char e : this.elements) {
            if (!predicate.test(e)) continue;
            ++c;
        }
        return c;
    }

    public final char max() {
        return CharArrays.max((char[])this.elements);
    }

    public final char min() {
        return CharArrays.min((char[])this.elements);
    }

    public char foldLeft(char zero, @NotNull CharBinaryOperator op) {
        return CharArrays.foldLeft((char[])this.elements, (char)zero, (CharBinaryOperator)op);
    }

    public <U> U foldLeftToObj(U zero, @NotNull ObjCharBiFunction<U, U> op) {
        return (U)CharArrays.foldLeftToObj((char[])this.elements, zero, op);
    }

    public char foldRight(char zero, @NotNull CharBinaryOperator op) {
        return CharArrays.foldRight((char[])this.elements, (char)zero, (CharBinaryOperator)op);
    }

    public <U> U foldRightToObj(U zero, @NotNull CharObjBiFunction<U, U> op) {
        return (U)CharArrays.foldRightToObj((char[])this.elements, zero, op);
    }

    public char reduceLeft(@NotNull CharBinaryOperator op) {
        return CharArrays.reduceLeft((char[])this.elements, (CharBinaryOperator)op);
    }

    public char reduceRight(@NotNull CharBinaryOperator op) {
        return CharArrays.reduceRight((char[])this.elements, (CharBinaryOperator)op);
    }

    public final int copyToArray(int srcPos, char @NotNull [] dest, int destPos, int limit) {
        if (srcPos < 0) {
            throw new IllegalArgumentException("srcPos(" + destPos + ") < 0");
        }
        if (destPos < 0) {
            throw new IllegalArgumentException("destPos(" + destPos + ") < 0");
        }
        int dl = dest.length;
        int size = this.elements.length;
        if (destPos >= dl || srcPos >= size) {
            return 0;
        }
        int n = Math.min(Math.min(size - srcPos, dl - destPos), limit);
        System.arraycopy(this.elements, srcPos, dest, destPos, n);
        return n;
    }

    public final char @NotNull [] toArray() {
        return (char[])this.elements.clone();
    }

    @Override
    public final void forEach(@NotNull CharConsumer action) {
        for (char e : this.elements) {
            action.accept(e);
        }
    }

    @Override
    public final int hashCode() {
        int ans = 0;
        char[] cArray = this.elements;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character o = Character.valueOf(cArray[i]);
            ans = ans * 31 + Objects.hashCode(o);
        }
        return ans + -1140647423;
    }

    @NotNull
    public final <A extends Appendable> A joinTo(@NotNull A buffer, CharSequence separator, CharSequence prefix, CharSequence postfix) {
        int size = this.elements.length;
        try {
            buffer.append(prefix);
            if (size > 0) {
                buffer.append(Objects.toString(Character.valueOf(this.elements[0])));
                for (int i = 1; i < size; ++i) {
                    buffer.append(separator);
                    buffer.append(Objects.toString(Character.valueOf(this.elements[i])));
                }
            }
            buffer.append(postfix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer;
    }

    private static final class Factory
    implements CharCollectionFactory<MutableCharArrayList, CharArraySeq> {
        private Factory() {
        }

        public CharArraySeq empty() {
            return CharArraySeq.empty();
        }

        public CharArraySeq from(char @NotNull [] values) {
            return CharArraySeq.from(values);
        }

        public CharArraySeq from(@NotNull CharTraversable values) {
            return CharArraySeq.from(values);
        }

        public CharArraySeq from(@NotNull CharIterator it) {
            return CharArraySeq.from(it);
        }

        public CharArraySeq fill(int n, char value) {
            return CharArraySeq.fill(n, value);
        }

        public CharArraySeq fill(int n, @NotNull CharSupplier supplier) {
            return CharArraySeq.fill(n, supplier);
        }

        public MutableCharArrayList newBuilder() {
            return new MutableCharArrayList();
        }

        public void addToBuilder(@NotNull MutableCharArrayList buffer, char value) {
            buffer.append(value);
        }

        public MutableCharArrayList mergeBuilder(@NotNull MutableCharArrayList builder1, @NotNull MutableCharArrayList builder2) {
            throw new UnsupportedOperationException();
        }

        public void sizeHint(@NotNull MutableCharArrayList builder, int size) {
            builder.sizeHint(size);
        }

        public CharArraySeq build(@NotNull MutableCharArrayList builder) {
            return new CharArraySeq(builder.toArray());
        }
    }
}

