/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.Objects;
import kala.Conditions;
import kala.collection.SeqView;
import kala.collection.base.primitive.CharTraversable;
import kala.collection.immutable.primitive.ImmutableCharSeq;
import kala.collection.primitive.CharArraySeq;
import kala.collection.primitive.CharCollectionView;
import kala.collection.primitive.CharSeqLike;
import kala.collection.primitive.PrimitiveSeqView;
import kala.collection.primitive.internal.view.CharSeqViews;
import kala.function.CharFunction;
import kala.function.CharPredicate;
import kala.function.CharUnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface CharSeqView
extends CharSeqLike,
CharCollectionView,
PrimitiveSeqView<Character> {
    @NotNull
    public static CharSeqView empty() {
        return CharSeqViews.EMPTY;
    }

    @Override
    @NotNull
    default public String className() {
        return "CharSeqView";
    }

    @Override
    @NotNull
    default public CharSeqView view() {
        return this;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public CharSeqView slice(int beginIndex, int endIndex) {
        int ks = this.knownSize();
        if (ks == 0) {
            if (beginIndex != 0) {
                throw new IndexOutOfBoundsException("beginIndex: " + beginIndex);
            }
            if (endIndex != 0) {
                throw new IndexOutOfBoundsException("endIndex: " + endIndex);
            }
            return CharSeqView.empty();
        }
        if (ks > 0) {
            Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)ks);
        } else {
            if (beginIndex < 0) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") < 0");
            }
            if (beginIndex > endIndex) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") > endIndex(" + endIndex + ")");
            }
        }
        return new CharSeqViews.Slice(this, beginIndex, endIndex);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public CharSeqView drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return CharSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return CharSeqView.empty();
        }
        return new CharSeqViews.Drop(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public CharSeqView dropLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return CharSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return CharSeqView.empty();
        }
        return new CharSeqViews.DropLast(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public CharSeqView dropWhile(@NotNull CharPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new CharSeqViews.DropWhile(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public CharSeqView take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return CharSeqView.empty();
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return CharSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return this;
        }
        return new CharSeqViews.Take(this, n);
    }

    @Override
    @NotNull
    default public CharSeqView takeLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return CharSeqView.empty();
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return CharSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return this;
        }
        return new CharSeqViews.TakeLast(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public CharSeqView takeWhile(@NotNull CharPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new CharSeqViews.TakeWhile(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public CharSeqView updated(int index, char newValue) {
        int ks = this.knownSize();
        if (ks < 0) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
        } else {
            Conditions.checkElementIndex((int)index, (int)ks);
        }
        return new CharSeqViews.Updated(this, index, newValue);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public CharSeqView concat(@NotNull CharSeqLike other) {
        Objects.requireNonNull(other);
        return new CharSeqViews.Concat(this, other.view());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public CharSeqView prepended(char value) {
        return new CharSeqViews.Prepended(this, value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public CharSeqView prependedAll(char @NotNull [] values) {
        Objects.requireNonNull(values);
        return new CharSeqViews.Concat(CharArraySeq.wrap(values), this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public CharSeqView prependedAll(@NotNull CharTraversable values) {
        Objects.requireNonNull(values);
        return new CharSeqViews.Concat(values instanceof CharSeqLike ? (CharSeqLike)values : ImmutableCharSeq.from(values), this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public CharSeqView appended(char value) {
        return new CharSeqViews.Appended(this, value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public CharSeqView appendedAll(char @NotNull [] values) {
        Objects.requireNonNull(values);
        return new CharSeqViews.Concat(this, CharArraySeq.wrap(values));
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public CharSeqView appendedAll(@NotNull CharTraversable values) {
        Objects.requireNonNull(values);
        return new CharSeqViews.Concat(this, values instanceof CharSeqLike ? (CharSeqLike)values : ImmutableCharSeq.from(values));
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public CharSeqView sorted() {
        return new CharSeqViews.Sorted(this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public CharSeqView reversed() {
        return new CharSeqViews.Reversed(this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public CharSeqView filter(@NotNull CharPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new CharSeqViews.Filter(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public CharSeqView filterNot(@NotNull CharPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new CharSeqViews.FilterNot(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public CharSeqView map(@NotNull CharUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return new CharSeqViews.Mapped(this, mapper);
    }

    @Contract(pure=true)
    @NotNull
    default public <U> SeqView<U> mapToObj(@NotNull CharFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return new CharSeqViews.MapToObj<U>(this, mapper);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public CharSeqView flatMap(@NotNull CharFunction<? extends CharTraversable> mapper) {
        Objects.requireNonNull(mapper);
        return new CharSeqViews.FlatMapped(this, mapper);
    }

    @NotNull
    default public <T> SeqView<T> flatMapToObj(@NotNull CharFunction<? extends Iterable<? extends T>> mapper) {
        Objects.requireNonNull(mapper);
        return new CharSeqViews.FlatMapToObj(this, mapper);
    }
}

