/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import kala.collection.AnySet;
import kala.collection.base.primitive.CharIterator;
import kala.collection.base.primitive.CharTraversable;
import kala.collection.factory.primitive.CharCollectionFactory;
import kala.collection.immutable.primitive.ImmutableCharSet;
import kala.collection.primitive.CharCollection;
import kala.collection.primitive.CharSetLike;
import kala.collection.primitive.CharSetView;
import kala.collection.primitive.PrimitiveSet;
import kala.collection.primitive.internal.view.CharSetViews;
import kala.function.CharPredicate;
import org.jetbrains.annotations.NotNull;

public interface CharSet
extends PrimitiveSet<Character>,
CharCollection,
CharSetLike {
    public static CharCollectionFactory<?, CharSet> factory() {
        return CharCollectionFactory.narrow(ImmutableCharSet.factory());
    }

    @NotNull
    public static CharSet empty() {
        return ImmutableCharSet.empty();
    }

    @NotNull
    public static CharSet of() {
        return ImmutableCharSet.of();
    }

    @NotNull
    public static CharSet of(char value1) {
        return ImmutableCharSet.of(value1);
    }

    @NotNull
    public static CharSet of(char value1, char value2) {
        return ImmutableCharSet.of(value1, value2);
    }

    @NotNull
    public static CharSet of(char value1, char value2, char value3) {
        return ImmutableCharSet.of(value1, value2, value3);
    }

    @NotNull
    public static CharSet of(char value1, char value2, char value3, char value4) {
        return ImmutableCharSet.of(value1, value2, value3, value4);
    }

    @NotNull
    public static CharSet of(char value1, char value2, char value3, char value4, char value5) {
        return ImmutableCharSet.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static CharSet of(char ... values) {
        return ImmutableCharSet.of(values);
    }

    @NotNull
    public static CharSet from(char @NotNull [] values) {
        return ImmutableCharSet.from(values);
    }

    @NotNull
    public static CharSet from(@NotNull CharTraversable values) {
        return ImmutableCharSet.from(values);
    }

    @NotNull
    public static CharSet from(@NotNull CharIterator it) {
        return ImmutableCharSet.from(it);
    }

    public static int hashCode(@NotNull CharSet set) {
        int h = 1045751549;
        CharIterator it = set.iterator();
        while (it.hasNext()) {
            h += Character.hashCode(it.nextChar());
        }
        return h;
    }

    public static boolean equals(@NotNull CharSet set1, @NotNull AnySet<?> set2) {
        if (set1 == set2) {
            return true;
        }
        if (!set1.canEqual(set2) || !set2.canEqual((Object)set1)) {
            return false;
        }
        if (set1.size() != set2.size()) {
            return false;
        }
        if (set2 instanceof CharSet) {
            return set1.containsAll((CharSet)set2);
        }
        for (Object v : set2.asGeneric()) {
            if (v instanceof Character && set1.contains(((Character)v).charValue())) continue;
            return false;
        }
        return true;
    }

    default public boolean contains(char value) {
        return this.iterator().contains(value);
    }

    @Override
    @NotNull
    default public String className() {
        return "CharSet";
    }

    @NotNull
    default public CharCollectionFactory<?, ? extends CharSet> iterableFactory() {
        return CharSet.factory();
    }

    @Override
    @NotNull
    default public CharSetView view() {
        return new CharSetViews.Of<CharSet>(this);
    }

    @Override
    @NotNull
    default public ImmutableCharSet filter(@NotNull CharPredicate predicate) {
        return ImmutableCharSet.from(this.view().filter(predicate));
    }

    @Override
    @NotNull
    default public ImmutableCharSet filterNot(@NotNull CharPredicate predicate) {
        return ImmutableCharSet.from(this.view().filterNot(predicate));
    }
}

