/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.primitive;

import java.util.Objects;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import kala.Conditions;
import kala.collection.SeqView;
import kala.collection.base.primitive.DoubleTraversable;
import kala.collection.immutable.primitive.ImmutableDoubleSeq;
import kala.collection.primitive.DoubleArraySeq;
import kala.collection.primitive.DoubleCollectionView;
import kala.collection.primitive.DoubleSeqLike;
import kala.collection.primitive.PrimitiveSeqView;
import kala.collection.primitive.internal.view.DoubleSeqViews;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface DoubleSeqView
extends DoubleSeqLike,
DoubleCollectionView,
PrimitiveSeqView<Double> {
    @NotNull
    public static DoubleSeqView empty() {
        return DoubleSeqViews.EMPTY;
    }

    @Override
    @NotNull
    default public String className() {
        return "DoubleSeqView";
    }

    @Override
    @NotNull
    default public DoubleSeqView view() {
        return this;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public DoubleSeqView slice(int beginIndex, int endIndex) {
        int ks = this.knownSize();
        if (ks == 0) {
            if (beginIndex != 0) {
                throw new IndexOutOfBoundsException("beginIndex: " + beginIndex);
            }
            if (endIndex != 0) {
                throw new IndexOutOfBoundsException("endIndex: " + endIndex);
            }
            return DoubleSeqView.empty();
        }
        if (ks > 0) {
            Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)ks);
        } else {
            if (beginIndex < 0) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") < 0");
            }
            if (beginIndex > endIndex) {
                throw new IndexOutOfBoundsException("beginIndex(" + beginIndex + ") > endIndex(" + endIndex + ")");
            }
        }
        return new DoubleSeqViews.Slice(this, beginIndex, endIndex);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public DoubleSeqView drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return DoubleSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return DoubleSeqView.empty();
        }
        return new DoubleSeqViews.Drop(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public DoubleSeqView dropLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return DoubleSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return DoubleSeqView.empty();
        }
        return new DoubleSeqViews.DropLast(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public DoubleSeqView dropWhile(@NotNull DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        return new DoubleSeqViews.DropWhile(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public DoubleSeqView take(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return DoubleSeqView.empty();
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return DoubleSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return this;
        }
        return new DoubleSeqViews.Take(this, n);
    }

    @Override
    @NotNull
    default public DoubleSeqView takeLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return DoubleSeqView.empty();
        }
        int ks = this.knownSize();
        if (ks == 0) {
            return DoubleSeqView.empty();
        }
        if (ks > 0 && n >= ks) {
            return this;
        }
        return new DoubleSeqViews.TakeLast(this, n);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public DoubleSeqView takeWhile(@NotNull DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        return new DoubleSeqViews.TakeWhile(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public DoubleSeqView updated(int index, double newValue) {
        int ks = this.knownSize();
        if (ks < 0) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index(" + index + ") < 0");
            }
        } else {
            Conditions.checkElementIndex((int)index, (int)ks);
        }
        return new DoubleSeqViews.Updated(this, index, newValue);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public DoubleSeqView concat(@NotNull DoubleSeqLike other) {
        Objects.requireNonNull(other);
        return new DoubleSeqViews.Concat(this, other.view());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public DoubleSeqView prepended(double value) {
        return new DoubleSeqViews.Prepended(this, value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public DoubleSeqView prependedAll(double @NotNull [] values) {
        Objects.requireNonNull(values);
        return new DoubleSeqViews.Concat(DoubleArraySeq.wrap(values), this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public DoubleSeqView prependedAll(@NotNull DoubleTraversable values) {
        Objects.requireNonNull(values);
        return new DoubleSeqViews.Concat(values instanceof DoubleSeqLike ? (DoubleSeqLike)values : ImmutableDoubleSeq.from(values), this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public DoubleSeqView appended(double value) {
        return new DoubleSeqViews.Appended(this, value);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public DoubleSeqView appendedAll(double @NotNull [] values) {
        Objects.requireNonNull(values);
        return new DoubleSeqViews.Concat(this, DoubleArraySeq.wrap(values));
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public DoubleSeqView appendedAll(@NotNull DoubleTraversable values) {
        Objects.requireNonNull(values);
        return new DoubleSeqViews.Concat(this, values instanceof DoubleSeqLike ? (DoubleSeqLike)values : ImmutableDoubleSeq.from(values));
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public DoubleSeqView sorted() {
        return new DoubleSeqViews.Sorted(this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public DoubleSeqView reversed() {
        return new DoubleSeqViews.Reversed(this);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public DoubleSeqView filter(@NotNull DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        return new DoubleSeqViews.Filter(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public DoubleSeqView filterNot(@NotNull DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        return new DoubleSeqViews.FilterNot(this, predicate);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public DoubleSeqView map(@NotNull DoubleUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return new DoubleSeqViews.Mapped(this, mapper);
    }

    @Contract(pure=true)
    @NotNull
    default public <U> SeqView<U> mapToObj(@NotNull DoubleFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return new DoubleSeqViews.MapToObj<U>(this, mapper);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    default public DoubleSeqView flatMap(@NotNull DoubleFunction<? extends DoubleTraversable> mapper) {
        Objects.requireNonNull(mapper);
        return new DoubleSeqViews.FlatMapped(this, mapper);
    }

    @NotNull
    default public <T> SeqView<T> flatMapToObj(@NotNull DoubleFunction<? extends Iterable<? extends T>> mapper) {
        Objects.requireNonNull(mapper);
        return new DoubleSeqViews.FlatMapToObj(this, mapper);
    }
}

